/*
 * Decompiled with CFR 0.152.
 */
package org.wltea.analyzer.cfg;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.wltea.analyzer.cfg.Configuration;

public class DefaultConfig
implements Configuration {
    private static final String PATH_DIC_MAIN = "dict/magese.dic";
    private static final String PATH_DIC_QUANTIFIER = "dict/quantifier.dic";
    private static final String FILE_NAME = "IKAnalyzer.cfg.xml";
    private static final String USE_MAIN = "use_main_dict";
    private static final String EXT_DICT = "ext_dict";
    private static final String EXT_STOP = "ext_stopwords";
    private Properties props = new Properties();
    private boolean useSmart;
    private boolean useMainDict = true;

    public static Configuration getInstance() {
        return new DefaultConfig();
    }

    private DefaultConfig() {
        InputStream input = this.getClass().getClassLoader().getResourceAsStream(FILE_NAME);
        if (input != null) {
            try {
                this.props.loadFromXML(input);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public boolean useSmart() {
        return this.useSmart;
    }

    @Override
    public void setUseSmart(boolean useSmart) {
        this.useSmart = useSmart;
    }

    @Override
    public boolean useMainDict() {
        String useMainDictCfg = this.props.getProperty(USE_MAIN);
        if (useMainDictCfg != null && useMainDictCfg.trim().length() > 0) {
            this.setUseMainDict(Boolean.parseBoolean(useMainDictCfg));
        }
        return this.useMainDict;
    }

    @Override
    public void setUseMainDict(boolean useMainDict) {
        this.useMainDict = useMainDict;
    }

    @Override
    public String getMainDictionary() {
        return PATH_DIC_MAIN;
    }

    @Override
    public String getQuantifierDicionary() {
        return PATH_DIC_QUANTIFIER;
    }

    @Override
    public List<String> getExtDictionarys() {
        ArrayList<String> extDictFiles = new ArrayList<String>(2);
        String extDictCfg = this.props.getProperty(EXT_DICT);
        if (extDictCfg != null) {
            String[] filePaths;
            for (String filePath : filePaths = extDictCfg.split(";")) {
                if (filePath == null || "".equals(filePath.trim())) continue;
                extDictFiles.add(filePath.trim());
            }
        }
        return extDictFiles;
    }

    @Override
    public List<String> getExtStopWordDictionarys() {
        ArrayList<String> extStopWordDictFiles = new ArrayList<String>(2);
        String extStopWordDictCfg = this.props.getProperty(EXT_STOP);
        if (extStopWordDictCfg != null) {
            String[] filePaths;
            for (String filePath : filePaths = extStopWordDictCfg.split(";")) {
                if (filePath == null || "".equals(filePath.trim())) continue;
                extStopWordDictFiles.add(filePath.trim());
            }
        }
        return extStopWordDictFiles;
    }
}

