/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.stream;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.solr.client.solrj.io.Tuple;
import org.apache.solr.client.solrj.io.comp.StreamComparator;
import org.apache.solr.client.solrj.io.eval.StreamEvaluator;
import org.apache.solr.client.solrj.io.stream.StreamContext;
import org.apache.solr.client.solrj.io.stream.TupleStream;
import org.apache.solr.client.solrj.io.stream.expr.Explanation;
import org.apache.solr.client.solrj.io.stream.expr.Expressible;
import org.apache.solr.client.solrj.io.stream.expr.StreamExplanation;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionNamedParameter;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionParameter;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionValue;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public class ZplotStream
extends TupleStream
implements Expressible {
    private static final long serialVersionUID = 1L;
    private StreamContext streamContext;
    private Map letParams = new LinkedHashMap();
    private Iterator<Tuple> out;

    public ZplotStream(StreamExpression expression, StreamFactory factory) throws IOException {
        List<StreamExpressionNamedParameter> namedParams = factory.getNamedOperands(expression);
        for (StreamExpressionParameter streamExpressionParameter : namedParams) {
            String name = ((StreamExpressionNamedParameter)streamExpressionParameter).getName();
            StreamExpressionParameter param = ((StreamExpressionNamedParameter)streamExpressionParameter).getParameter();
            if (param instanceof StreamExpressionValue) {
                String paramValue = ((StreamExpressionValue)param).getValue();
                this.letParams.put(name, factory.constructPrimitiveObject(paramValue));
                continue;
            }
            if (!factory.isEvaluator((StreamExpression)param)) continue;
            StreamEvaluator evaluator = factory.constructEvaluator((StreamExpression)param);
            this.letParams.put(name, evaluator);
        }
    }

    @Override
    public StreamExpression toExpression(StreamFactory factory) throws IOException {
        return this.toExpression(factory, true);
    }

    private StreamExpression toExpression(StreamFactory factory, boolean includeStreams) throws IOException {
        StreamExpression expression = new StreamExpression(factory.getFunctionName(this.getClass()));
        return expression;
    }

    @Override
    public Explanation toExplanation(StreamFactory factory) throws IOException {
        StreamExplanation explanation = new StreamExplanation(this.getStreamNodeId().toString());
        explanation.setFunctionName(factory.getFunctionName(this.getClass()));
        explanation.setImplementingClass(this.getClass().getName());
        explanation.setExpressionType("stream-decorator");
        explanation.setExpression(this.toExpression(factory, false).toString());
        return explanation;
    }

    @Override
    public void setStreamContext(StreamContext context) {
        this.streamContext = context;
    }

    @Override
    public List<TupleStream> children() {
        ArrayList<TupleStream> l = new ArrayList<TupleStream>();
        return l;
    }

    @Override
    public Tuple read() throws IOException {
        if (this.out.hasNext()) {
            return this.out.next();
        }
        HashMap<String, Boolean> m = new HashMap<String, Boolean>();
        m.put("EOF", true);
        Tuple t = new Tuple(m);
        return t;
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public void open() throws IOException {
        List l;
        Map<String, Object> lets = this.streamContext.getLets();
        Set entries = this.letParams.entrySet();
        HashMap<String, Object> evaluated = new HashMap<String, Object>();
        int numTuples = -1;
        int columns = 0;
        boolean table = false;
        for (Map.Entry entry : entries) {
            Object o;
            ++columns;
            String name = (String)entry.getKey();
            if (name.equals("table")) {
                table = true;
            }
            if ((o = entry.getValue()) instanceof StreamEvaluator) {
                Tuple eTuple = new Tuple(lets);
                StreamEvaluator evaluator = (StreamEvaluator)o;
                evaluator.setStreamContext(this.streamContext);
                Object eo = evaluator.evaluate(eTuple);
                if (eo instanceof List) {
                    List l2 = (List)eo;
                    if (numTuples == -1) {
                        numTuples = l2.size();
                    } else if (l2.size() != numTuples) {
                        throw new IOException("All lists provided to the zplot function must be the same length.");
                    }
                    evaluated.put(name, l2);
                    continue;
                }
                if (!(eo instanceof Tuple)) continue;
                evaluated.put(name, eo);
                continue;
            }
            Object eval = lets.get(o);
            if (eval instanceof List) {
                l = (List)eval;
                if (numTuples == -1) {
                    numTuples = l.size();
                } else if (l.size() != numTuples) {
                    throw new IOException("All lists provided to the zplot function must be the same length.");
                }
                evaluated.put(name, l);
                continue;
            }
            if (!(eval instanceof Tuple)) continue;
            evaluated.put(name, eval);
        }
        if (columns > 1 && table) {
            throw new IOException("If the table parameter is set there can only be one parameter.");
        }
        ArrayList<Tuple> outTuples = new ArrayList<Tuple>();
        if (!table) {
            for (int i = 0; i < numTuples; ++i) {
                Tuple tuple = new Tuple(new HashMap());
                for (String key : evaluated.keySet()) {
                    l = (List)evaluated.get(key);
                    tuple.put(key, l.get(i));
                }
                outTuples.add(tuple);
            }
        } else {
            Object o = evaluated.get("table");
            if (o instanceof List) {
                List tuples = (List)o;
                outTuples.addAll(tuples);
            } else if (o instanceof Tuple) {
                outTuples.add((Tuple)o);
            }
        }
        this.out = outTuples.iterator();
    }

    @Override
    public StreamComparator getStreamSort() {
        return null;
    }

    @Override
    public int getCost() {
        return 0;
    }
}

