/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.ltr.feature;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.solr.ltr.DocInfo;
import org.apache.solr.ltr.feature.FeatureException;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.request.macro.MacroExpander;
import org.apache.solr.util.SolrPluginUtils;

public abstract class Feature
extends Query {
    protected final String name;
    private int index = -1;
    private float defaultValue = 0.0f;
    private final Map<String, Object> params;

    public static Feature getInstance(SolrResourceLoader solrResourceLoader, String className, String name, Map<String, Object> params) {
        Feature f = (Feature)((Object)solrResourceLoader.newInstance(className, Feature.class, new String[0], new Class[]{String.class, Map.class}, new Object[]{name, params}));
        if (params != null) {
            SolrPluginUtils.invokeSetters((Object)((Object)f), params.entrySet());
        }
        f.validate();
        return f;
    }

    public Feature(String name, Map<String, Object> params) {
        this.name = name;
        this.params = params;
    }

    protected abstract void validate() throws FeatureException;

    public String toString(String field) {
        StringBuilder sb = new StringBuilder(64);
        sb.append(((Object)((Object)this)).getClass().getSimpleName());
        sb.append(" [name=").append(this.name);
        LinkedHashMap<String, Object> params = this.paramsToMap();
        if (params != null) {
            sb.append(", params=").append(params);
        }
        sb.append(']');
        return sb.toString();
    }

    public abstract FeatureWeight createWeight(IndexSearcher var1, boolean var2, SolrQueryRequest var3, Query var4, Map<String, String[]> var5) throws IOException;

    public float getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String value) {
        this.defaultValue = Float.parseFloat(value);
    }

    public int hashCode() {
        int prime = 31;
        int result = this.classHash();
        result = 31 * result + this.index;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.params == null ? 0 : this.params.hashCode());
        return result;
    }

    public boolean equals(Object o) {
        return this.sameClassAs(o) && this.equalsTo((Feature)((Object)((Object)((Object)this)).getClass().cast(o)));
    }

    private boolean equalsTo(Feature other) {
        if (this.index != other.index) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.params == null ? other.params != null : !this.params.equals(other.params));
    }

    public String getName() {
        return this.name;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public abstract LinkedHashMap<String, Object> paramsToMap();

    public abstract class FeatureWeight
    extends Weight {
        protected final IndexSearcher searcher;
        protected final SolrQueryRequest request;
        protected final Map<String, String[]> efi;
        protected final MacroExpander macroExpander;
        protected final Query originalQuery;

        public FeatureWeight(Query q, IndexSearcher searcher, SolrQueryRequest request, Query originalQuery, Map<String, String[]> efi) {
            super(q);
            this.searcher = searcher;
            this.request = request;
            this.originalQuery = originalQuery;
            this.efi = efi;
            this.macroExpander = new MacroExpander(efi, true);
        }

        public String getName() {
            return Feature.this.getName();
        }

        public int getIndex() {
            return Feature.this.getIndex();
        }

        public float getDefaultValue() {
            return Feature.this.getDefaultValue();
        }

        public abstract FeatureScorer scorer(LeafReaderContext var1) throws IOException;

        public boolean isCacheable(LeafReaderContext ctx) {
            return false;
        }

        public Explanation explain(LeafReaderContext context, int doc) throws IOException {
            FeatureScorer r = this.scorer(context);
            float score = this.getDefaultValue();
            if (r != null) {
                r.iterator().advance(doc);
                if (r.docID() == doc) {
                    score = r.score();
                }
                return Explanation.match((float)score, (String)this.toString(), (Explanation[])new Explanation[0]);
            }
            return Explanation.match((float)score, (String)"The feature has no value", (Explanation[])new Explanation[0]);
        }

        public String toString() {
            return Feature.this.toString();
        }

        public void extractTerms(Set<Term> terms) {
        }

        public class ValueFeatureScorer
        extends FeatureScorer {
            float constScore;

            public ValueFeatureScorer(FeatureWeight weight, float constScore, DocIdSetIterator itr) {
                super(weight, itr);
                this.constScore = constScore;
            }

            @Override
            public float score() {
                return this.constScore;
            }
        }

        public abstract class FeatureScorer
        extends Scorer {
            protected final String name;
            private DocInfo docInfo;
            protected final DocIdSetIterator itr;

            public FeatureScorer(FeatureWeight weight, DocIdSetIterator itr) {
                super((Weight)weight);
                this.itr = itr;
                this.name = weight.getName();
                this.docInfo = null;
            }

            public abstract float score() throws IOException;

            public void setDocInfo(DocInfo docInfo) {
                this.docInfo = docInfo;
            }

            public DocInfo getDocInfo() {
                return this.docInfo;
            }

            public int docID() {
                return this.itr.docID();
            }

            public DocIdSetIterator iterator() {
                return this.itr;
            }
        }
    }
}

