/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import java.io.IOException;
import java.util.Set;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.ConstantScoreScorer;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.TwoPhaseIterator;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.Bits;

public abstract class Filter
extends Query {
    private final boolean applyLazily;

    protected Filter(boolean applyLazily) {
        this.applyLazily = applyLazily;
    }

    protected Filter() {
        this(false);
    }

    public abstract DocIdSet getDocIdSet(LeafReaderContext var1, Bits var2) throws IOException;

    public Weight createWeight(IndexSearcher searcher, boolean needsScores, float boost) throws IOException {
        return new Weight(this){

            public void extractTerms(Set<Term> terms) {
            }

            public Explanation explain(LeafReaderContext context, int doc) throws IOException {
                boolean match;
                Scorer scorer = this.scorer(context);
                boolean bl = match = scorer != null && scorer.iterator().advance(doc) == doc;
                if (match) {
                    assert (scorer.score() == 0.0f);
                    return Explanation.match((float)0.0f, (String)("Match on id " + doc), (Explanation[])new Explanation[0]);
                }
                return Explanation.match((float)0.0f, (String)("No match on id " + doc), (Explanation[])new Explanation[0]);
            }

            public Scorer scorer(LeafReaderContext context) throws IOException {
                DocIdSet set = Filter.this.getDocIdSet(context, null);
                if (set == null) {
                    return null;
                }
                if (Filter.this.applyLazily && set.bits() != null) {
                    final Bits bits = set.bits();
                    DocIdSetIterator approximation = DocIdSetIterator.all((int)context.reader().maxDoc());
                    TwoPhaseIterator twoPhase = new TwoPhaseIterator(approximation){

                        public boolean matches() throws IOException {
                            return bits.get(this.approximation.docID());
                        }

                        public float matchCost() {
                            return 10.0f;
                        }
                    };
                    return new ConstantScoreScorer((Weight)this, 0.0f, twoPhase);
                }
                DocIdSetIterator iterator = set.iterator();
                if (iterator == null) {
                    return null;
                }
                return new ConstantScoreScorer((Weight)this, 0.0f, iterator);
            }

            public boolean isCacheable(LeafReaderContext ctx) {
                return false;
            }
        };
    }
}

