/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.internal.csv;

import java.io.Serializable;
import org.apache.solr.internal.csv.ImmutableCSVStrategy;

public class CSVStrategy
implements Cloneable,
Serializable {
    private char delimiter;
    private char encapsulator;
    private char commentStart;
    private char escape;
    private boolean ignoreLeadingWhitespaces;
    private boolean ignoreTrailingWhitespaces;
    private boolean interpretUnicodeEscapes;
    private boolean ignoreEmptyLines;
    private String printerNewline;
    public static char COMMENTS_DISABLED = (char)65534;
    public static char ESCAPE_DISABLED = (char)65534;
    public static char ENCAPSULATOR_DISABLED = (char)65534;
    public static String DEFAULT_PRINTER_NEWLINE = "\n";
    public static final CSVStrategy DEFAULT_STRATEGY = new ImmutableCSVStrategy(',', '\"', COMMENTS_DISABLED, ESCAPE_DISABLED, true, true, false, true, DEFAULT_PRINTER_NEWLINE);
    public static final CSVStrategy EXCEL_STRATEGY = new ImmutableCSVStrategy(',', '\"', COMMENTS_DISABLED, ESCAPE_DISABLED, false, false, false, false, DEFAULT_PRINTER_NEWLINE);
    public static final CSVStrategy TDF_STRATEGY = new ImmutableCSVStrategy('\t', '\"', COMMENTS_DISABLED, ESCAPE_DISABLED, true, true, false, true, DEFAULT_PRINTER_NEWLINE);

    public CSVStrategy(char delimiter, char encapsulator, char commentStart) {
        this(delimiter, encapsulator, commentStart, ESCAPE_DISABLED, true, true, false, true, DEFAULT_PRINTER_NEWLINE);
    }

    public CSVStrategy(char delimiter, char encapsulator, char commentStart, char escape, boolean ignoreLeadingWhitespaces, boolean ignoreTrailingWhitespaces, boolean interpretUnicodeEscapes, boolean ignoreEmptyLines, String printerNewline) {
        this.delimiter = delimiter;
        this.encapsulator = encapsulator;
        this.commentStart = commentStart;
        this.escape = escape;
        this.ignoreLeadingWhitespaces = ignoreLeadingWhitespaces;
        this.ignoreTrailingWhitespaces = ignoreTrailingWhitespaces;
        this.interpretUnicodeEscapes = interpretUnicodeEscapes;
        this.ignoreEmptyLines = ignoreEmptyLines;
        this.printerNewline = printerNewline;
    }

    @Deprecated
    public CSVStrategy(char delimiter, char encapsulator, char commentStart, char escape, boolean ignoreLeadingWhitespaces, boolean ignoreTrailingWhitespaces, boolean interpretUnicodeEscapes, boolean ignoreEmptyLines) {
        this(delimiter, encapsulator, commentStart, escape, ignoreLeadingWhitespaces, ignoreTrailingWhitespaces, interpretUnicodeEscapes, ignoreEmptyLines, DEFAULT_PRINTER_NEWLINE);
    }

    @Deprecated
    public void setDelimiter(char delimiter) {
        this.delimiter = delimiter;
    }

    public char getDelimiter() {
        return this.delimiter;
    }

    @Deprecated
    public void setEncapsulator(char encapsulator) {
        this.encapsulator = encapsulator;
    }

    public char getEncapsulator() {
        return this.encapsulator;
    }

    @Deprecated
    public void setCommentStart(char commentStart) {
        this.commentStart = commentStart;
    }

    public char getCommentStart() {
        return this.commentStart;
    }

    public boolean isCommentingDisabled() {
        return this.commentStart == COMMENTS_DISABLED;
    }

    @Deprecated
    public void setEscape(char escape) {
        this.escape = escape;
    }

    public char getEscape() {
        return this.escape;
    }

    @Deprecated
    public void setIgnoreLeadingWhitespaces(boolean ignoreLeadingWhitespaces) {
        this.ignoreLeadingWhitespaces = ignoreLeadingWhitespaces;
    }

    public boolean getIgnoreLeadingWhitespaces() {
        return this.ignoreLeadingWhitespaces;
    }

    @Deprecated
    public void setIgnoreTrailingWhitespaces(boolean ignoreTrailingWhitespaces) {
        this.ignoreTrailingWhitespaces = ignoreTrailingWhitespaces;
    }

    public boolean getIgnoreTrailingWhitespaces() {
        return this.ignoreTrailingWhitespaces;
    }

    @Deprecated
    public void setUnicodeEscapeInterpretation(boolean interpretUnicodeEscapes) {
        this.interpretUnicodeEscapes = interpretUnicodeEscapes;
    }

    public boolean getUnicodeEscapeInterpretation() {
        return this.interpretUnicodeEscapes;
    }

    @Deprecated
    public void setIgnoreEmptyLines(boolean ignoreEmptyLines) {
        this.ignoreEmptyLines = ignoreEmptyLines;
    }

    public boolean getIgnoreEmptyLines() {
        return this.ignoreEmptyLines;
    }

    @Deprecated
    public void setPrinterNewline(String newline) {
        this.printerNewline = newline;
    }

    public String getPrinterNewline() {
        return this.printerNewline;
    }

    @Deprecated
    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }
}

