/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.core.backup.repository;

import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.Optional;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.solr.util.plugin.NamedListInitializedPlugin;

public interface BackupRepository
extends NamedListInitializedPlugin,
Closeable {
    default public String getBackupLocation(String override) {
        return Optional.ofNullable(override).orElse((String)this.getConfigProperty("location"));
    }

    public <T> T getConfigProperty(String var1);

    public URI createURI(String var1);

    public URI resolve(URI var1, String ... var2);

    public boolean exists(URI var1) throws IOException;

    public PathType getPathType(URI var1) throws IOException;

    public String[] listAll(URI var1) throws IOException;

    public IndexInput openInput(URI var1, String var2, IOContext var3) throws IOException;

    public OutputStream createOutput(URI var1) throws IOException;

    public void createDirectory(URI var1) throws IOException;

    public void deleteDirectory(URI var1) throws IOException;

    public void copyFileFrom(Directory var1, String var2, URI var3) throws IOException;

    public void copyFileTo(URI var1, String var2, Directory var3) throws IOException;

    public static enum PathType {
        DIRECTORY,
        FILE;

    }
}

