/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics.facet;

import java.util.EnumSet;
import java.util.List;
import java.util.function.Consumer;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.solr.analytics.facet.AbstractSolrQueryFacet;
import org.apache.solr.analytics.function.ReductionCollectionManager;
import org.apache.solr.analytics.util.FacetRangeGenerator;
import org.apache.solr.common.params.FacetParams;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.Filter;

public class RangeFacet
extends AbstractSolrQueryFacet {
    protected final SchemaField field;
    protected final String start;
    protected final String end;
    protected final List<String> gaps;
    protected boolean hardEnd = false;
    protected EnumSet<FacetParams.FacetRangeInclude> include;
    protected EnumSet<FacetParams.FacetRangeOther> others;

    public RangeFacet(String name, SchemaField field, String start, String end, List<String> gaps) {
        super(name);
        this.field = field;
        this.start = start;
        this.end = end;
        this.gaps = gaps;
        this.include = EnumSet.of(FacetParams.FacetRangeInclude.LOWER);
        this.others = EnumSet.of(FacetParams.FacetRangeOther.NONE);
    }

    @Override
    public void createFacetValueExecuters(Filter filter, SolrQueryRequest queryRequest, Consumer<AbstractSolrQueryFacet.FacetValueQueryExecuter> consumer) {
        FacetRangeGenerator<Comparable<?>> rec = FacetRangeGenerator.create(this);
        SchemaField sf = this.field;
        for (FacetRangeGenerator.FacetRange range : rec.getRanges()) {
            Query q = sf.getType().getRangeQuery(null, sf, range.lower, range.upper, range.includeLower, range.includeUpper);
            BooleanQuery rangeQuery = new BooleanQuery.Builder().add(q, BooleanClause.Occur.MUST).add((Query)filter, BooleanClause.Occur.FILTER).build();
            ReductionCollectionManager.ReductionDataCollection dataCol = this.collectionManager.newDataCollection();
            this.reductionData.put(range.toString(), dataCol);
            consumer.accept(new AbstractSolrQueryFacet.FacetValueQueryExecuter(dataCol, (Query)rangeQuery));
        }
    }

    public String getStart() {
        return this.start;
    }

    public String getEnd() {
        return this.end;
    }

    public EnumSet<FacetParams.FacetRangeInclude> getInclude() {
        return this.include;
    }

    public void setInclude(EnumSet<FacetParams.FacetRangeInclude> include) {
        this.include = include;
    }

    public List<String> getGaps() {
        return this.gaps;
    }

    public boolean isHardEnd() {
        return this.hardEnd;
    }

    public void setHardEnd(boolean hardEnd) {
        this.hardEnd = hardEnd;
    }

    public EnumSet<FacetParams.FacetRangeOther> getOthers() {
        return this.others;
    }

    public void setOthers(EnumSet<FacetParams.FacetRangeOther> others) {
        this.others = others;
    }

    public SchemaField getField() {
        return this.field;
    }
}

