/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.text.preprocessing.pipeline;

import java.util.List;
import org.carrot2.core.Document;
import org.carrot2.core.LanguageCode;
import org.carrot2.text.linguistic.LanguageModel;
import org.carrot2.text.preprocessing.DocumentAssigner;
import org.carrot2.text.preprocessing.LabelFilterProcessor;
import org.carrot2.text.preprocessing.PhraseExtractor;
import org.carrot2.text.preprocessing.PreprocessingContext;
import org.carrot2.text.preprocessing.pipeline.BasicPreprocessingPipeline;
import org.carrot2.util.attribute.Bindable;

@Bindable(prefix="PreprocessingPipeline")
public class CompletePreprocessingPipeline
extends BasicPreprocessingPipeline {
    public final PhraseExtractor phraseExtractor = new PhraseExtractor();
    public final LabelFilterProcessor labelFilterProcessor = new LabelFilterProcessor();
    public final DocumentAssigner documentAssigner = new DocumentAssigner();

    @Override
    public PreprocessingContext preprocess(List<Document> documents, String query, LanguageCode language) {
        PreprocessingContext context = new PreprocessingContext(LanguageModel.create(language, this.stemmerFactory, this.tokenizerFactory, this.lexicalDataFactory), documents, query);
        this.tokenizer.tokenize(context);
        this.caseNormalizer.normalize(context);
        this.languageModelStemmer.stem(context);
        this.stopListMarker.mark(context);
        this.phraseExtractor.extractPhrases(context);
        this.labelFilterProcessor.process(context);
        this.documentAssigner.assign(context);
        context.preprocessingFinished();
        return context;
    }
}

