/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.zml.statement;

import java.lang.reflect.InvocationTargetException;
import org.zhiqim.kernel.util.Strings;
import org.zhiqim.kernel.util.Validates;
import org.zhiqim.zml.Expression;
import org.zhiqim.zml.ExpressionParser;
import org.zhiqim.zml.Statement;
import org.zhiqim.zml.ZmlEngine;
import org.zhiqim.zml.ZmlVariable;
import org.zhiqim.zml.exception.ExpressionException;
import org.zhiqim.zml.exception.StatementException;

public class _Include
extends Statement {
    private Expression expression;

    @Override
    public boolean isNesting() {
        return true;
    }

    @Override
    public void parseStatement() throws StatementException {
        String s = Strings.trim((String)this.getStatement(), (String)"<#include ", (String)"/>");
        if (Validates.isEmptyBlank((String)s)) {
            throw new StatementException(this, "<#include>\u672a\u914d\u7f6e\u88ab\u5305\u542b\u7684\u6587\u4ef6\u8def\u5f84");
        }
        try {
            this.expression = ExpressionParser.parseExpression(s);
        }
        catch (ExpressionException e) {
            throw new StatementException(this, "<#include>" + e.getMessage());
        }
    }

    @Override
    public String process(ZmlVariable variableMap) throws StatementException {
        try {
            String path = this.getIncludePath(variableMap);
            ZmlEngine engine = this.getZml().getEngine();
            return engine.getZml(path).process(variableMap, this.getZml());
        }
        catch (StatementException e) {
            throw e;
        }
        catch (Exception e) {
            if (e instanceof InvocationTargetException) {
                throw new StatementException(this, "<#include>" + ((InvocationTargetException)e).getTargetException().getMessage());
            }
            if (e.getCause() != null) {
                throw new StatementException(this, "<#include>" + e.getCause().getMessage());
            }
            throw new StatementException(this, "<#include>" + e.getMessage());
        }
    }

    public void define(ZmlVariable variableMap) throws StatementException {
        try {
            String path = this.getIncludePath(variableMap);
            ZmlEngine engine = this.getZml().getEngine();
            engine.getZml(path).define(variableMap);
        }
        catch (StatementException e) {
            throw e;
        }
        catch (Exception e) {
            if (e instanceof InvocationTargetException) {
                throw new StatementException(this, "<#include>" + ((InvocationTargetException)e).getTargetException().getMessage());
            }
            throw new StatementException(this, "<#include>" + e.getMessage());
        }
    }

    public String getIncludePath(ZmlVariable variableMap) throws StatementException {
        try {
            return String.valueOf(this.expression.build(variableMap));
        }
        catch (ExpressionException e) {
            throw new StatementException(this, "<#include>" + e.getMessage());
        }
    }
}

