/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.zml.expression.operator;

import org.zhiqim.kernel.util.Types;
import org.zhiqim.zml.Expression;
import org.zhiqim.zml.ZmlVariable;
import org.zhiqim.zml.exception.ExpressionException;
import org.zhiqim.zml.expression.Operator;

public class _EqualEqual
extends Operator {
    private final Expression left;
    private final Expression right;

    public _EqualEqual(Expression left, Expression right) {
        this.left = left;
        this.right = right;
    }

    @Override
    public int getType() {
        return 61610;
    }

    @Override
    public Object build(ZmlVariable variableMap) throws ExpressionException {
        Object privous = this.left.build(variableMap);
        Object next = this.right.build(variableMap);
        if (privous == null || next == null) {
            return privous == null ? next == null : next != null;
        }
        if (privous instanceof String || next instanceof String) {
            return String.valueOf(privous).equals(String.valueOf(next));
        }
        if (!Types.isNumber((Object)privous)) {
            return privous.equals(next);
        }
        if (!Types.isNumber((Object)next)) {
            return false;
        }
        if (Types.isInteger((Object)privous)) {
            if (!Types.isInteger((Object)next)) {
                return false;
            }
            if (((Number)privous).longValue() == ((Number)next).longValue()) {
                return true;
            }
            return false;
        }
        if (!Types.isDecimal((Object)next)) {
            return false;
        }
        if (((Number)privous).doubleValue() == ((Number)next).doubleValue()) {
            return true;
        }
        return false;
    }

    @Override
    public String toString() {
        return this.left + " == " + this.right;
    }
}

