/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.zml.exception;

import org.zhiqim.kernel.util.Validates;
import org.zhiqim.zml.Statement;

public class StatementException
extends Exception {
    private static final long serialVersionUID = 1L;
    private String path;
    private int lineNo;
    private int columnNo;

    public StatementException(Statement s, String message) {
        this(s.getPath(), s.getBeginLine(), s.getBeginColumn(), message);
    }

    public StatementException(Statement s, String message, Throwable exception) {
        this(s.getPath(), s.getBeginLine(), s.getBeginColumn(), message, exception);
    }

    public StatementException(String path, int lineNo, int columnNo, String message) {
        super("[" + (Validates.isEmptyBlank((String)path) ? "\u81ea\u5b9a\u4e49ZML" : path) + "]" + "[\u7b2c" + lineNo + "\u884c],[\u7b2c" + columnNo + "\u5217][" + message + "]");
        this.path = path;
        this.lineNo = lineNo;
        this.columnNo = columnNo;
    }

    public StatementException(String path, int lineNo, int columnNo, String message, Throwable exception) {
        super("[" + (Validates.isEmptyBlank((String)path) ? "\u81ea\u5b9a\u4e49ZML" : path) + "]" + "[\u7b2c" + lineNo + "\u884c],[\u7b2c" + columnNo + "\u5217][" + message + "]", exception);
        this.path = path;
        this.lineNo = lineNo;
        this.columnNo = columnNo;
    }

    public String getPath() {
        return this.path;
    }

    public int getLineNo() {
        return this.lineNo;
    }

    public int getColumnNo() {
        return this.columnNo;
    }
}

