/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.zml;

import java.util.Iterator;
import org.zhiqim.kernel.extend.HashMapSV;
import org.zhiqim.kernel.schedule.Interval;
import org.zhiqim.kernel.schedule.Task;
import org.zhiqim.zml.Zml;

public class ZmlCache
implements Task {
    private final HashMapSV<Zml> cache = new HashMapSV();
    private int maxIdleTime;
    private int maxKeepTime;

    public ZmlCache(int maxIdleTime, int maxKeepTime) {
        this.maxIdleTime = maxIdleTime;
        this.maxKeepTime = maxKeepTime;
        Interval.shedule((Task)this, (int)900000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Zml get(String path) {
        HashMapSV<Zml> hashMapSV = this.cache;
        synchronized (hashMapSV) {
            Zml zml = (Zml)this.cache.get(path);
            if (zml != null) {
                zml.setLastAccessed();
            }
            return zml;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(String path, Zml zml) {
        HashMapSV<Zml> hashMapSV = this.cache;
        synchronized (hashMapSV) {
            if (this.cache.containsKey(path)) {
                this.cache.remove(path);
            }
            this.cache.put(path, (Object)zml);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(String path) {
        HashMapSV<Zml> hashMapSV = this.cache;
        synchronized (hashMapSV) {
            this.cache.remove(path);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() {
        boolean hasMaxKeepTime;
        boolean hasMaxIdleTime = this.maxIdleTime > 0;
        boolean bl = hasMaxKeepTime = this.maxKeepTime > 0;
        if (!hasMaxIdleTime && !hasMaxKeepTime) {
            return;
        }
        long lastKeepTimeMs = System.currentTimeMillis() - (long)(this.maxKeepTime * 1000);
        long lastIdleTimeMs = System.currentTimeMillis() - (long)(this.maxIdleTime * 1000);
        HashMapSV<Zml> hashMapSV = this.cache;
        synchronized (hashMapSV) {
            Iterator it = this.cache.values().iterator();
            while (it.hasNext()) {
                Zml zml = (Zml)it.next();
                long lastAccessed = zml.getLastAccessed();
                if ((!hasMaxKeepTime || lastAccessed >= lastKeepTimeMs) && (!hasMaxIdleTime || lastAccessed >= lastIdleTimeMs)) continue;
                it.remove();
            }
        }
    }

    public int getMaxIdleTime() {
        return this.maxIdleTime;
    }

    public int getMaxKeepTime() {
        return this.maxKeepTime;
    }

    public void setMaxIdleTime(int maxIdleTime) {
        this.maxIdleTime = maxIdleTime;
    }

    public void setMaxKeepTime(int maxKeepTime) {
        this.maxKeepTime = maxKeepTime;
    }
}

