/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.zml;

import java.util.Comparator;
import java.util.List;
import org.zhiqim.kernel.constants.SignConstants;
import org.zhiqim.kernel.util.Validates;
import org.zhiqim.zml.StatementNesting;
import org.zhiqim.zml.StatementParser;
import org.zhiqim.zml.Zml;
import org.zhiqim.zml.ZmlConstants;
import org.zhiqim.zml.ZmlLineIndex;
import org.zhiqim.zml.ZmlVariable;
import org.zhiqim.zml.exception.StatementException;
import org.zhiqim.zml.statement._For;

public abstract class Statement
implements ZmlConstants,
SignConstants {
    public static final StatementComparator COMPARATOR = new StatementComparator();
    private Zml zml;
    private StatementNesting parent;
    private String statement;
    private int beginLine;
    private int beginColumn;
    private int endLine;
    private int endColumn;
    private int beginIndex;
    private int endIndex;
    private int innerBeginIndex;
    private int innerEndIndex;

    public abstract boolean isNesting();

    public abstract void parseStatement() throws StatementException;

    public abstract String process(ZmlVariable var1) throws StatementException;

    public void setStatement(Zml zml, StatementNesting parent, String statement) {
        this.zml = zml;
        this.parent = parent;
        this.statement = statement;
    }

    public void setIndexAll(int beginIndex, int endIndex) {
        this.beginIndex = beginIndex;
        this.endIndex = endIndex;
        int[] begins = StatementParser.getLineColumnNoByIndex(this.zml.getIndexList(), beginIndex);
        int[] ends = StatementParser.getLineColumnNoByIndex(this.zml.getIndexList(), endIndex);
        this.beginLine = begins[0];
        this.beginColumn = begins[1];
        this.endLine = ends[0];
        this.endColumn = ends[1];
    }

    public void setIndexInner(int innerBeginIndex, int innerEndIndex) {
        this.innerBeginIndex = innerBeginIndex;
        this.innerEndIndex = innerEndIndex;
    }

    public boolean isExclusiveLine() throws StatementException {
        String content;
        if (this.beginColumn > 1 && (content = this.parent.getPrevStatement(this)) != null) {
            if (content.length() < this.beginColumn - 1) {
                return false;
            }
            String previous = content.substring(content.length() - (this.beginColumn - 1));
            if (!Validates.isEmptyBlank((String)previous)) {
                return false;
            }
        }
        if (this.beginLine == this.endLine) {
            return this.isEndBreak();
        }
        return true;
    }

    public boolean isEndBreak() throws StatementException {
        String content = this.parent.getNextStatement(this);
        return content == null || content.startsWith("\r") || content.startsWith("\n");
    }

    public _For getNearestNestingFor() {
        if (this instanceof _For) {
            return (_For)this;
        }
        StatementNesting sp = this.parent;
        while (sp != null) {
            if (sp instanceof _For) {
                return (_For)sp;
            }
            if (sp instanceof Zml) {
                return null;
            }
            sp = ((Statement)((Object)sp)).parent;
        }
        return null;
    }

    public Zml getZml() {
        return this.zml;
    }

    public String getPath() {
        return this.getZml().getPath();
    }

    public List<ZmlLineIndex> getIndexList() {
        return this.zml.getIndexList();
    }

    public String getStatement() {
        return this.statement;
    }

    public int getBeginIndex() {
        return this.beginIndex;
    }

    public int getEndIndex() {
        return this.endIndex;
    }

    public int getBeginLine() {
        return this.beginLine;
    }

    public int getBeginColumn() {
        return this.beginColumn;
    }

    public int getEndLine() {
        return this.endLine;
    }

    public int getEndColumn() {
        return this.endColumn;
    }

    public int getInnerBeginIndex() {
        return this.innerBeginIndex;
    }

    public int getInnerEndIndex() {
        return this.innerEndIndex;
    }

    public String toString() {
        return this.statement;
    }

    private static class StatementComparator
    implements Comparator<Statement> {
        private StatementComparator() {
        }

        @Override
        public int compare(Statement o1, Statement o2) {
            return o1.getBeginIndex() - o2.getBeginIndex();
        }
    }
}

