/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.uploadlarge.action;

import org.zhiqim.httpd.HttpRequest;
import org.zhiqim.httpd.context.core.Action;
import org.zhiqim.kernel.util.Files;
import org.zhiqim.kernel.util.Ints;
import org.zhiqim.kernel.util.Validates;
import org.zhiqim.orm.dbo.Selector;
import org.zhiqim.uploadlarge.ZulBootstrap;
import org.zhiqim.uploadlarge.ZulDao;
import org.zhiqim.uploadlarge.dbo.UpllChunk;

public class FileChunkDeleteAction
implements Action {
    public void execute(HttpRequest request) throws Exception {
        String fileId = request.getParameter("fileId");
        if (Validates.isEmpty((String)fileId) || fileId.indexOf(",") == -1) {
            request.returnHistory("\u8bf7\u9009\u62e9\u4e00\u4e2a\u6709\u6548\u7684\u6570\u636e");
            return;
        }
        int ind = fileId.indexOf(",");
        String fileMd5 = fileId.substring(0, ind);
        int chunkSize = Ints.toInt((String)fileId.substring(ind + 1), (int)-1);
        if (!Validates.isAlphaNumericLen((String)fileMd5, (int)48, (int)48) || chunkSize == -1) {
            request.returnHistory("\u8bf7\u9009\u62e9\u4e00\u4e2a\u6709\u6548\u7684\u6570\u636e");
            return;
        }
        Selector selector = new Selector();
        selector.addReplace("id", request.getNestAttributeString("orm.id"));
        selector.addMust("fileMd5", (Object)fileMd5);
        selector.addMust("chunkSize", (Object)chunkSize);
        UpllChunk chunk = (UpllChunk)ZulBootstrap.table(request).item(UpllChunk.class, selector);
        Files.deleteFile((String)ZulDao.getFilePath(chunk));
        ZulBootstrap.table(request).delete(UpllChunk.class, selector);
    }
}

