/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.texteditor;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.zhiqim.httpd.HttpRequest;
import org.zhiqim.kernel.annotation.AnAlias;
import org.zhiqim.kernel.annotation.AnFilterNot;
import org.zhiqim.kernel.constants.CodeConstants;
import org.zhiqim.kernel.httpclient.HttpGetStream;
import org.zhiqim.kernel.json.Jsons;
import org.zhiqim.kernel.util.DateTimes;
import org.zhiqim.kernel.util.Files;
import org.zhiqim.kernel.util.Ids;
import org.zhiqim.kernel.util.Strings;
import org.zhiqim.kernel.util.Validates;
import org.zhiqim.kernel.util.codes.Base64;
import org.zhiqim.uploadlarge.ZulUploader;
import org.zhiqim.uploadlarge.dbo.UpllFile;

@AnAlias(value={"ZteUploadImagePresenter"})
public class ZteUploadImagePresenter
implements CodeConstants {
    public static void saveImage(HttpRequest request) throws Exception {
        String fileData = request.getParameter("fileData");
        String midDir = request.getParameter("midDir");
        String uploadDir = request.getParameter("uploadDir");
        String param = request.getParameter("param");
        String[] str = fileData.split(",");
        byte[] bytes = Base64.decode((String)str[1]);
        int index = str[0].indexOf(";");
        String fileExt = "jpg";
        String contentType = "image/jpeg";
        if (index != -1) {
            fileExt = str[0].substring(11, index);
            contentType = "image/" + fileExt;
        }
        String fileName = String.valueOf(Ids.longId13()) + "." + fileExt;
        String pathDir = "";
        if (Validates.isNotEmpty((String)midDir)) {
            midDir = Strings.addStartsWith((String)midDir, (String)"/");
            pathDir = String.valueOf(pathDir) + Strings.removeEndsWith((String)midDir, (String)"/");
        }
        if (Validates.isNotEmpty((String)uploadDir)) {
            uploadDir = Strings.addStartsWith((String)uploadDir, (String)"/");
            pathDir = String.valueOf(pathDir) + Strings.removeEndsWith((String)uploadDir, (String)"/");
        }
        if (Validates.isNotEmpty((String)pathDir)) {
            pathDir = Strings.addEndsWith((String)uploadDir, (String)"/");
        }
        String rootDir = request.getContext().getAttributeString("upload.large.rootDir");
        String filePath = String.valueOf(rootDir = Files.toLinuxPath((String)new File(rootDir).getCanonicalPath())) + File.separator + DateTimes.getDateTime8String() + File.separator + "textEditor";
        if (!Files.exists((String)filePath)) {
            Files.mkDirectory((String)filePath);
        }
        filePath = String.valueOf(filePath) + File.separator + fileName;
        request.setAttribute("orm.id", (Object)param);
        UpllFile uFile = ZulUploader.saveFile((HttpRequest)request, (byte[])bytes, (String)filePath, (String)contentType);
        URI uri = new URI(request.getRequestURL().toString());
        String scheme = uri.getScheme();
        if (!(uri.getHost().startsWith("localhost") || uri.getHost().startsWith("127") || uri.getHost().startsWith("192"))) {
            request.setResponseResult("https://design.yangcai365.com" + uFile.getFileUrl());
        } else {
            URI effectiveURI = new URI(scheme, uri.getUserInfo(), uri.getHost(), uri.getPort(), null, null, null);
            request.setResponseResult(effectiveURI + uFile.getFileUrl());
        }
    }

    @AnFilterNot
    public static void downloadImage(HttpRequest request) throws Exception {
        String imgUrl = request.getParameter("imgUrl");
        String midDir = request.getParameter("midDir");
        String param = request.getParameter("param");
        HttpGetStream conn = new HttpGetStream(imgUrl);
        conn.setConnectTimeout(10);
        conn.execute();
        if (conn.getResponseStatus() != 200) {
            request.setResponseResult(701, "\u8bfb\u53d6\u7f51\u7edc\u56fe\u7247\u8d85\u65f6\uff0c\u8bf7\u91cd\u8bd5");
            return;
        }
        byte[] bytes = conn.getBytes();
        String contentType = "image/jpeg";
        String fileExt = Files.getFileExt((String)imgUrl);
        if (!"jpg".equalsIgnoreCase(fileExt)) {
            contentType = "image/" + fileExt;
        }
        String fileName = String.valueOf(Ids.longId13()) + "." + fileExt;
        String pathDir = "";
        if (Validates.isNotEmpty((String)midDir)) {
            midDir = Strings.addStartsWith((String)midDir, (String)"/");
            pathDir = String.valueOf(pathDir) + Strings.removeEndsWith((String)midDir, (String)"/");
        }
        String rootDir = request.getContext().getAttributeString("upload.large.rootDir");
        String filePath = String.valueOf(rootDir = Files.toLinuxPath((String)new File(rootDir).getCanonicalPath())) + File.separator + DateTimes.getDateTime8String() + File.separator + "textEditor";
        if (!Files.exists((String)filePath)) {
            Files.mkDirectory((String)filePath);
        }
        filePath = String.valueOf(filePath) + File.separator + fileName;
        request.setAttribute("orm.id", (Object)param);
        UpllFile uFile = ZulUploader.saveFile((HttpRequest)request, (byte[])bytes, (String)filePath, (String)contentType);
        URI uri = new URI(request.getRequestURL().toString());
        String scheme = uri.getScheme();
        if (!(uri.getHost().startsWith("localhost") || uri.getHost().startsWith("127") || uri.getHost().startsWith("192"))) {
            request.setResponseResult("https://design.yangcai365.com" + uFile.getFileUrl());
        } else {
            URI effectiveURI = new URI(scheme, uri.getUserInfo(), uri.getHost(), uri.getPort(), null, null, null);
            request.setResponseResult(effectiveURI + uFile.getFileUrl());
        }
    }

    public static void getUploadImageList(HttpRequest request, String path) throws Exception {
        String rootDir = request.getContext().getAttributeString("upload.large.rootDir");
        path = path.replaceAll("/service/upll", rootDir).replaceAll("/", "\\\\");
        request.setResponseResult(Jsons.toString(ZteUploadImagePresenter.getFile(rootDir, path)));
    }

    public static List<String> getFile(String rootDir, String path) {
        File file = new File(path);
        File[] array = file.listFiles();
        ArrayList<String> resultList = new ArrayList<String>();
        if (array == null || array.length == 0) {
            if (path.lastIndexOf("\\") != path.indexOf("\\")) {
                path = path.substring(0, path.lastIndexOf("\\"));
                resultList.add("dir;\u8fd4\u56de\u4e0a\u7ea7;" + path);
            } else {
                resultList.add("dir;\u65e0\u5185\u5bb9;" + path);
            }
            return resultList;
        }
        int i = 0;
        while (i < array.length) {
            String itemPath = array[i].getPath().replaceAll("\\\\", "/").replaceAll(rootDir, "");
            String resultStr = "";
            if (array[i].isFile()) {
                resultStr = String.valueOf(resultStr) + "img;";
                if (Validates.isNotEmptyBlank((String)(itemPath = Base64.encodeFileUrlUTF8((String)itemPath.substring(0, itemPath.lastIndexOf("/")))))) {
                    itemPath = String.valueOf(itemPath) + "/";
                }
                resultStr = String.valueOf(resultStr) + array[i].getName() + ";/service/upll/" + itemPath + array[i].getName();
            } else if (array[i].isDirectory()) {
                resultStr = String.valueOf(resultStr) + "dir;";
                resultStr = String.valueOf(resultStr) + array[i].getName() + ";/service/upll" + itemPath;
            }
            resultList.add(resultStr);
            ++i;
        }
        return resultList;
    }
}

