/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.orm.executor;

import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.LinkedList;
import org.zhiqim.kernel.extend.MapSS;
import org.zhiqim.kernel.extend.SO;
import org.zhiqim.kernel.util.Sqls;
import org.zhiqim.orm.ORMException;
import org.zhiqim.orm.ORMServer;
import org.zhiqim.orm.datasource.ZDBClose;
import org.zhiqim.orm.datasource.ZStatement;
import org.zhiqim.orm.dbo.Dbo;
import org.zhiqim.orm.executor.UpdateExecutor;

public class UpdateExecutorClass
implements UpdateExecutor {
    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int execute(ORMServer server, Connection conn, String sql, Object param, MapSS replaceMap) throws ORMException, SQLException {
        int n;
        PreparedStatement pstmt = null;
        String str = null;
        try {
            sql = Sqls.formatReplaceMap((String)sql, (MapSS)replaceMap);
            Dbo dbo = server.getDbo(param.getClass().getName());
            LinkedList<SO> paramKeyList = new LinkedList<SO>();
            int i = 0;
            int start = 0;
            int end = sql.indexOf(35);
            while (end != -1) {
                if (i % 2 != 0) {
                    String paramKey = sql.substring(start + 1, end);
                    String method = dbo.getGetMethod(paramKey);
                    if (method == null) {
                        throw new ORMException("_Table/_View/_Dbo[" + dbo.getClass().getName() + "]\u6ca1\u6709\u627e\u5230" + paramKey + "\u5bf9\u5e94\u7684\u65b9\u6cd5]");
                    }
                    Method m = param.getClass().getMethod(method, new Class[0]);
                    Object value = m.invoke(param, new Object[0]);
                    paramKeyList.add(new SO(paramKey, value));
                }
                ++i;
                start = end;
                end = sql.indexOf(35, start + 1);
            }
            i = 0;
            while (i < paramKeyList.size()) {
                String paramKey = ((SO)paramKeyList.get(i)).key();
                sql = sql.replaceAll("#" + paramKey + "#", "?");
                ++i;
            }
            if (server.isUpdateSqlLog()) {
                str = sql;
            }
            pstmt = conn.prepareStatement(sql);
            i = 0;
            while (i < paramKeyList.size()) {
                Object value = ((SO)paramKeyList.get(i)).value();
                if (server.isUpdateSqlLog()) {
                    str = ZStatement.setParameter(server, pstmt, i + 1, value, str);
                } else {
                    ZStatement.setParameter(server, pstmt, i + 1, value);
                }
                ++i;
            }
            int result = pstmt.executeUpdate();
            if (server.isUpdateSqlLog()) {
                str = str.replaceAll("-%6-%-3%-", "?");
                uSqlLog.info((Object)str);
            }
            n = result;
        }
        catch (SQLException e) {
            try {
                log.error((Object)"UpdateExecutorClass[SQLException][%s][sql=%s]", (Throwable)e, new Object[]{e.getMessage(), sql});
                throw e;
                catch (Exception e2) {
                    log.error((Object)"UpdateExecutorClass[Exception][%s]", (Throwable)e2, new Object[]{e2.getMessage()});
                    throw new ORMException(e2.getMessage(), e2);
                }
            }
            catch (Throwable throwable) {
                ZDBClose.close(pstmt);
                throw throwable;
            }
        }
        ZDBClose.close(pstmt);
        return n;
    }
}

