/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.orm.executor;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.zhiqim.kernel.extend.MapSS;
import org.zhiqim.kernel.util.Arrays;
import org.zhiqim.kernel.util.Sqls;
import org.zhiqim.kernel.util.Types;
import org.zhiqim.orm.ORMException;
import org.zhiqim.orm.ORMServer;
import org.zhiqim.orm.datasource.ZDBClose;
import org.zhiqim.orm.datasource.ZStatement;
import org.zhiqim.orm.executor.UpdateExecutor;

public class UpdateExecutorBase
implements UpdateExecutor {
    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int execute(ORMServer server, Connection conn, String sql, Object param, MapSS replaceMap) throws ORMException, SQLException {
        int n;
        PreparedStatement pstmt = null;
        String str = null;
        try {
            sql = Sqls.formatReplaceMap((String)sql, (MapSS)replaceMap);
            if (server.isUpdateSqlLog()) {
                str = sql;
            }
            pstmt = conn.prepareStatement(sql);
            if (Types.isArray((Object)param)) {
                Object[] objs = Arrays.toArray((Object)param);
                int i = 0;
                while (i < objs.length) {
                    Object value = objs[i];
                    if (server.isUpdateSqlLog()) {
                        str = ZStatement.setParameter(server, pstmt, i + 1, value, str);
                    } else {
                        ZStatement.setParameter(server, pstmt, i + 1, value);
                    }
                    ++i;
                }
            } else if (param != null) {
                if (server.isUpdateSqlLog()) {
                    str = ZStatement.setParameter(server, pstmt, 1, param, str);
                } else {
                    ZStatement.setParameter(server, pstmt, 1, param);
                }
            }
            int result = pstmt.executeUpdate();
            if (server.isUpdateSqlLog()) {
                str = str.replaceAll("-%6-%-3%-", "?");
                uSqlLog.info((Object)str);
            }
            n = result;
        }
        catch (SQLException e) {
            try {
                log.error((Object)"UpdateExecutorBase[SQLException][%s][sql=%s]", (Throwable)e, new Object[]{e.getMessage(), sql});
                throw e;
                catch (Exception e2) {
                    log.error((Object)"UpdateExecutorBase[Exception][%s]", (Throwable)e2, new Object[]{e2.getMessage()});
                    throw new ORMException(e2.getMessage(), e2);
                }
            }
            catch (Throwable throwable) {
                ZDBClose.close(pstmt);
                throw throwable;
            }
        }
        ZDBClose.close(pstmt);
        return n;
    }
}

