/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.orm.dbo;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import org.zhiqim.kernel.extend.LinkedMapSS;
import org.zhiqim.kernel.extend.MapSO;
import org.zhiqim.kernel.util.Asserts;
import org.zhiqim.kernel.util.Types;
import org.zhiqim.kernel.util.Validates;
import org.zhiqim.orm.ORMConstants;
import org.zhiqim.orm.ORMException;
import org.zhiqim.orm.dbo.Condition;
import org.zhiqim.orm.dbo.Dbo;
import org.zhiqim.orm.dbo.Selector;
import org.zhiqim.orm.dbo.condition._Equal;
import org.zhiqim.orm.dbo.condition._EqualNot;
import org.zhiqim.orm.dbo.condition._Expression;
import org.zhiqim.orm.dbo.condition._In;
import org.zhiqim.orm.dbo.condition._InNot;
import org.zhiqim.orm.dbo.condition._IsEmpty;
import org.zhiqim.orm.dbo.condition._IsNotEmpty;
import org.zhiqim.orm.dbo.condition._IsNotNull;
import org.zhiqim.orm.dbo.condition._IsNull;
import org.zhiqim.orm.dbo.condition._Like;
import org.zhiqim.orm.dbo.condition._LikeL;
import org.zhiqim.orm.dbo.condition._LikeNot;
import org.zhiqim.orm.dbo.condition._LikeNotL;
import org.zhiqim.orm.dbo.condition._LikeNotR;
import org.zhiqim.orm.dbo.condition._LikeR;
import org.zhiqim.orm.dbo.condition._Or;
import org.zhiqim.orm.dbo.condition._ThenG;
import org.zhiqim.orm.dbo.condition._ThenGE;
import org.zhiqim.orm.dbo.condition._ThenL;
import org.zhiqim.orm.dbo.condition._ThenLE;

abstract class Conditioner<C extends Conditioner<?>>
implements Serializable,
ORMConstants {
    private static final long serialVersionUID = 1L;
    protected List<Condition> conditionList = null;
    protected LinkedMapSS replaceMap = new LinkedMapSS();

    Conditioner() {
    }

    public LinkedMapSS getReplaceMap() {
        return this.replaceMap;
    }

    public List<Condition> getConditionList() {
        return this.conditionList;
    }

    public boolean hasCondition() {
        return this.conditionList != null && !this.conditionList.isEmpty();
    }

    public C addMaybe(String field, Object value) {
        if (!this.chkMaybeFieldValue(field, value)) {
            return this.self();
        }
        this.addCondition(new _Equal(field, value));
        return this.self();
    }

    public C addMust(String field, Object value) {
        this.chkMustFieldValue(field, value);
        this.addCondition(new _Equal(field, value));
        return this.self();
    }

    public C addMaybeNotEqual(String field, Object value) {
        if (!this.chkMaybeFieldValue(field, value)) {
            return this.self();
        }
        this.addCondition(new _EqualNot(field, value));
        return this.self();
    }

    public C addMustNotEqual(String field, Object value) {
        this.chkMustFieldValue(field, value);
        this.addCondition(new _EqualNot(field, value));
        return this.self();
    }

    public C addMaybeLike(String field, Object value) {
        if (!this.chkMaybeFieldValue(field, value)) {
            return this.self();
        }
        this.addCondition(new _Like(field, String.valueOf(value)));
        return this.self();
    }

    public C addMustLike(String field, Object value) {
        this.chkMustFieldValue(field, value);
        this.addCondition(new _Like(field, String.valueOf(value)));
        return this.self();
    }

    public C addMaybeLikeLeft(String field, Object value) {
        if (!this.chkMaybeFieldValue(field, value)) {
            return this.self();
        }
        this.addCondition(new _LikeL(field, String.valueOf(value)));
        return this.self();
    }

    public C addMustLikeLeft(String field, Object value) {
        this.chkMustFieldValue(field, value);
        this.addCondition(new _LikeL(field, String.valueOf(value)));
        return this.self();
    }

    public C addMaybeLikeRight(String field, Object value) {
        if (!this.chkMaybeFieldValue(field, value)) {
            return this.self();
        }
        this.addCondition(new _LikeR(field, String.valueOf(value)));
        return this.self();
    }

    public C addMustLikeRight(String field, Object value) {
        this.chkMustFieldValue(field, value);
        this.addCondition(new _LikeR(field, String.valueOf(value)));
        return this.self();
    }

    public C addMaybeNotLike(String field, Object value) {
        if (!this.chkMaybeFieldValue(field, value)) {
            return this.self();
        }
        this.addCondition(new _LikeNot(field, String.valueOf(value)));
        return this.self();
    }

    public C addMustNotLike(String field, Object value) {
        this.chkMustFieldValue(field, value);
        this.addCondition(new _LikeNot(field, String.valueOf(value)));
        return this.self();
    }

    public C addMaybeNotLikeLeft(String field, Object value) {
        if (!this.chkMaybeFieldValue(field, value)) {
            return this.self();
        }
        this.addCondition(new _LikeNotL(field, String.valueOf(value)));
        return this.self();
    }

    public C addMustNotLikeLeft(String field, Object value) {
        this.chkMustFieldValue(field, value);
        this.addCondition(new _LikeNotL(field, String.valueOf(value)));
        return this.self();
    }

    public C addMaybeNotLikeRight(String field, Object value) {
        if (!this.chkMaybeFieldValue(field, value)) {
            return this.self();
        }
        this.addCondition(new _LikeNotR(field, String.valueOf(value)));
        return this.self();
    }

    public C addMustNotLikeRight(String field, Object value) {
        this.chkMustFieldValue(field, value);
        this.addCondition(new _LikeNotR(field, String.valueOf(value)));
        return this.self();
    }

    public C addMaybeThenG(String field, Object value) {
        if (!this.chkMaybeFieldValue(field, value)) {
            return this.self();
        }
        this.addCondition(new _ThenG(field, value));
        return this.self();
    }

    public C addMustThenG(String field, Object value) {
        this.chkMustFieldValue(field, value);
        this.addCondition(new _ThenG(field, value));
        return this.self();
    }

    public C addMaybeThenGE(String field, Object value) {
        if (!this.chkMaybeFieldValue(field, value)) {
            return this.self();
        }
        this.addCondition(new _ThenGE(field, value));
        return this.self();
    }

    public C addMustThenGE(String field, Object value) {
        this.chkMustFieldValue(field, value);
        this.addCondition(new _ThenGE(field, value));
        return this.self();
    }

    public C addMaybeThenL(String field, Object value) {
        if (!this.chkMaybeFieldValue(field, value)) {
            return this.self();
        }
        this.addCondition(new _ThenL(field, value));
        return this.self();
    }

    public C addMustThenL(String field, Object value) {
        this.chkMustFieldValue(field, value);
        this.addCondition(new _ThenL(field, value));
        return this.self();
    }

    public C addMaybeThenLE(String field, Object value) {
        if (!this.chkMaybeFieldValue(field, value)) {
            return this.self();
        }
        this.addCondition(new _ThenLE(field, value));
        return this.self();
    }

    public C addMustThenLE(String field, Object value) {
        this.chkMustFieldValue(field, value);
        this.addCondition(new _ThenLE(field, value));
        return this.self();
    }

    public C addMaybeIsNull(String field) {
        if (!this.chkMaybeFieldValue(field)) {
            return this.self();
        }
        this.addCondition(new _IsNull(field));
        return this.self();
    }

    public C addMustIsNull(String field) {
        this.chkMustFieldValue(field);
        this.addCondition(new _IsNull(field));
        return this.self();
    }

    public C addMaybeIsNotNull(String field) {
        if (!this.chkMaybeFieldValue(field)) {
            return this.self();
        }
        this.addCondition(new _IsNotNull(field));
        return this.self();
    }

    public C addMustIsNotNull(String field) {
        this.chkMustFieldValue(field);
        this.addCondition(new _IsNotNull(field));
        return this.self();
    }

    public C addMaybeIsEmpty(String field) {
        if (!this.chkMaybeFieldValue(field)) {
            return this.self();
        }
        this.addCondition(new _IsEmpty(field));
        return this.self();
    }

    public C addMustIsEmpty(String field) {
        this.chkMustFieldValue(field);
        this.addCondition(new _IsEmpty(field));
        return this.self();
    }

    public C addMaybeIsNotEmpty(String field) {
        if (!this.chkMaybeFieldValue(field)) {
            return this.self();
        }
        this.addCondition(new _IsNotEmpty(field));
        return this.self();
    }

    public C addMustIsNotEmpty(String field) {
        this.chkMustFieldValue(field);
        this.addCondition(new _IsNotEmpty(field));
        return this.self();
    }

    public C addMaybeIn(String field, String ... values) {
        if (!this.chkMaybeFieldValue(field, values)) {
            return this.self();
        }
        this.addCondition(new _In(field, values));
        return this.self();
    }

    public C addMustIn(String field, String ... values) {
        this.chkMustFieldValue(field, values);
        this.addCondition(new _In(field, values));
        return this.self();
    }

    public C addMaybeIn(String field, int ... values) {
        if (!this.chkMaybeFieldValue(field, values)) {
            return this.self();
        }
        this.addCondition(new _In(field, values));
        return this.self();
    }

    public C addMustIn(String field, int ... values) {
        this.chkMustFieldValue(field, values);
        this.addCondition(new _In(field, values));
        return this.self();
    }

    public C addMaybeInLong(String field, long ... values) {
        if (!this.chkMaybeFieldValue(field, values)) {
            return this.self();
        }
        this.addCondition(new _In(field, values));
        return this.self();
    }

    public C addMustInLong(String field, long ... values) {
        this.chkMustFieldValue(field, values);
        this.addCondition(new _In(field, values));
        return this.self();
    }

    public C addMaybeNotIn(String field, String ... values) {
        if (!this.chkMaybeFieldValue(field, values)) {
            return this.self();
        }
        this.addCondition(new _InNot(field, values));
        return this.self();
    }

    public C addMustNotIn(String field, String ... values) {
        this.chkMustFieldValue(field, values);
        this.addCondition(new _InNot(field, values));
        return this.self();
    }

    public C addMaybeNotIn(String field, int ... values) {
        if (!this.chkMaybeFieldValue(field, values)) {
            return this.self();
        }
        this.addCondition(new _InNot(field, values));
        return this.self();
    }

    public C addMustNotIn(String field, int ... values) {
        this.chkMustFieldValue(field, values);
        this.addCondition(new _InNot(field, values));
        return this.self();
    }

    public C addMaybeNotInLong(String field, long ... values) {
        if (!this.chkMaybeFieldValue(field, values)) {
            return this.self();
        }
        this.addCondition(new _InNot(field, values));
        return this.self();
    }

    public C addMustNotInLong(String field, long ... values) {
        this.chkMustFieldValue(field, values);
        this.addCondition(new _InNot(field, values));
        return this.self();
    }

    public C addExpression(String field, String expression) {
        return this.addExpression(field, expression, "=");
    }

    public C addExpressionNotEqual(String field, String expression) {
        return this.addExpression(field, expression, "<>");
    }

    public C addExpressionThenG(String field, String expression) {
        return this.addExpression(field, expression, ">");
    }

    public C addExpressionThenGE(String field, String expression) {
        return this.addExpression(field, expression, ">=");
    }

    public C addExpressionThenL(String field, String expression) {
        return this.addExpression(field, expression, "<");
    }

    public C addExpressionThenLE(String field, String expression) {
        return this.addExpression(field, expression, "<=");
    }

    private C addExpression(String field, String expression, String condition) {
        Asserts.notEmptyBlank((String)field, (String)"field");
        Asserts.notEmptyBlank((String)expression, (String)"value");
        this.addCondition(new _Expression(field, expression, condition));
        return this.self();
    }

    public C addOr(Selector selector) {
        List conditionList = selector.getConditionList();
        Asserts.as((String)(conditionList != null ? null : "\u589e\u52a0[or]\u67e5\u8be2\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a"));
        Asserts.as((String)(conditionList.size() >= 2 ? null : "\u589e\u52a0[or]\u67e5\u8be2\u6761\u4ef6\u5fc5\u987b>=2\u4e2a"));
        _Or or = new _Or();
        for (Condition condition : conditionList) {
            or.addCondition(condition);
        }
        this.addCondition(or);
        return this.self();
    }

    public String getWhereSQL(Dbo dbo, MapSO paramMap) throws ORMException {
        if (this.conditionList == null || this.conditionList.isEmpty()) {
            return "";
        }
        boolean hasEqualJoin = dbo.hasEqualJoin();
        StringBuilder whereSQL = new StringBuilder();
        whereSQL.append(hasEqualJoin ? " and " : " where ");
        whereSQL.append(this.conditionList.get(0).toSql(dbo, paramMap));
        int i = 1;
        while (i < this.conditionList.size()) {
            whereSQL.append(" and ").append(this.conditionList.get(i).toSql(dbo, paramMap));
            ++i;
        }
        return whereSQL.toString();
    }

    protected final C self() {
        return (C)this;
    }

    protected void addReplaceInner(String key, String value) {
        if (this.replaceMap == null) {
            this.replaceMap = new LinkedMapSS(2);
        }
        this.replaceMap.put(key, value);
    }

    protected void addCondition(Condition condition) {
        if (this.conditionList == null) {
            this.conditionList = new ArrayList<Condition>(3);
        }
        this.conditionList.add(condition);
    }

    protected boolean chkMaybeFieldValue(String field) {
        return !Validates.isEmptyBlank((String)field);
    }

    protected void chkMustFieldValue(String field) {
        Asserts.notEmptyBlank((String)field);
    }

    protected boolean chkMaybeFieldValue(String field, Object value) {
        if (Validates.isEmptyBlank((String)field) || value == null) {
            return false;
        }
        if (value instanceof String && Validates.isEmpty((String)((String)value))) {
            return false;
        }
        if (value instanceof Integer && (Integer)value == -1) {
            return false;
        }
        if (value instanceof Long && (Long)value == -1L) {
            return false;
        }
        return !Types.isArray((Object)value) || Array.getLength(value) != 0;
    }

    protected void chkMustFieldValue(String field, Object value) {
        Asserts.notEmptyBlank((String)field, (String)"field");
        Asserts.notNull((Object)value, (String)"value");
        Asserts.as(!(value instanceof String) || !Validates.isEmpty((String)((String)value)) ? null : "\u5b57\u6bb5[" + field + "]\u7684[" + value + "]\u4e3aString\u578b\u65f6\u503c\u4e0d\u80fd\u4e3a\u7a7a\u5b57\u7b26\u4e32");
        Asserts.as(!(value instanceof Integer) || (Integer)value != -1 ? null : "\u5b57\u6bb5[" + field + "]\u7684[" + value + "]\u4e3aint\u578b\u65f6\u503c\u4e0d\u80fd\u4e3a-1");
        Asserts.as(!(value instanceof Long) || (Long)value != -1L ? null : "\u5b57\u6bb5[" + field + "]\u7684[" + value + "]\u4e3along\u578b\u65f6\u503c\u4e0d\u80fd\u4e3a-1");
        if (Types.isArray((Object)value)) {
            Asserts.as(Array.getLength(value) > 0 ? null : "\u5b57\u6bb5[" + field + "]\u6216[" + value + "]\u4e3aArray\u578b\u65f6\u6570\u76ee\u5fc5\u987b>0");
        }
    }
}

