
/******************************/
var hasSvg2pdfAPI = false;
if (typeof ServiceAPI !== "undefined")
    hasSvg2pdfAPI = !!ServiceAPI && !!ServiceAPI.svg2pdf && Z.T.isFunction(ServiceAPI.svg2pdf);

/*****************************/

/******************************/
/** 1：保存按钮 **/
function doSaveMediaLocalSave(dialogObj, doneCallback, doneParam)
{
    doSoftwareLocalSave(1, 0, 0, 0, -1, dialogObj, null, null, doneCallback, doneParam);
}
/** 2：下载，0：jpg、1：png、2：pdf **/
function doDownloadFileLocalSave(dialogObj, fileType)
{
    doSoftwareLocalSave(0, 0, 0, 0, parseFloat(fileType), dialogObj);
}
/** 3：初稿 **/
function doSubmitDraftLocalSave(saveCallback, saveParam)
{
    doSoftwareLocalSave(1, 0, 0, 0, -1, null, null, null, saveCallback, saveParam);
}
/** 4：定稿：预览操作 **/
function doPreviewFileLocalSave(dialogObj)
{
    doSoftwareLocalSave(1, 1, 0, 1, -1, dialogObj);
}
/** 5：生成、更新缩略图 **/
function doUpdateImageLocalSave(dialogObj, doneCallback, doneParam)
{
    doSoftwareLocalSave(1, 1, 0, 0, -1, dialogObj, null, null, doneCallback, doneParam);
}

/** 执行客户端操作 **/
function doSoftwareLocalSave(doSave, doUpdateImage, doUploadPdf, doPreviewPdf, doDownloadType, dialogObj, saveCallback, saveParam, doneCallback, doneParam)
{
    // 1：定义flag
    ServiceAPI.doUpdateImage = doUpdateImage;      // 上传效果图
    ServiceAPI.doUploadPdf = doUploadPdf;          // 上传成品PDF
    ServiceAPI.doPreviewPdf = doPreviewPdf;        // 预览PDF
    ServiceAPI.doDownloadType = doDownloadType;    // -1：不下载，0：jpg，1：png，2：pdf
    ServiceAPI.dialogObj = dialogObj;              // dialog 对象
    ServiceAPI.pdfList = [];                       // 初始化 pdfList
    ServiceAPI.removeList = [];                    // 待删除列表 removeList
    ServiceAPI.saveCallback = saveCallback;        // 保存完成，回调方法
    ServiceAPI.saveParam = saveParam;              // 保存完成，回调参数
    ServiceAPI.doneCallback = doneCallback;        // 处理完成，回调方法
    ServiceAPI.doneParam = doneParam;              // 处理完成，回调参数
    ServiceAPI.finishLocal = 0;                    // 结束标识

    // 2：dialogObj避免闪屏，添加时间标识
    if (dialogObj)
        ServiceAPI.dialogObj.creatTime_localSave = new Date().getTime();

    // 2：ajax更新数据库
    if (doSave)
        mediaUpdateLocalSave();
    else
        getPdfStartLocalSave();
}
/** 执行media数据库更新 **/
function mediaUpdateLocalSave()
{
    var ajax = new Z.Ajax();
    ajax.setSync();
    ajax.setClassName("MediaPresenter");
    ajax.setMethodName("doSaveMediaData");
    ajax.addParam("mediaJson", media.toString());
    ajax.addParam("mediaId", media.canvas.mediaId);
    ajax.setFailure(function()
    {
        doClearErrorLocalSave(this.responseText);
    });
    ajax.setSuccess(function()
    {
        Z.T.isFunction(ServiceAPI.saveCallback) && saveCallback(ServiceAPI.saveParam);
        getPdfStartLocalSave();
    });
    ajax.execute();
}
/** 获取pdf开始 **/
function getPdfStartLocalSave()
{
    var pageNum = media.bgList.length;
    if (!ServiceAPI.doUploadPdf && !ServiceAPI.doPreviewPdf && ServiceAPI.doDownloadType === -1)
    {
        if (ServiceAPI.doUpdateImage)
            pageNum = 2;
        else
            pageNum = 0;
    }
    getPdfBySoftware(media, pageNum);
}

/** 预览/定稿，清空临时变量 **/
function doClearPreviewLocalSave(text)
{
    ServiceAPI.doUploadPdf = 0;
    ServiceAPI.doPreviewPdf = 0;
    doClearSuccessLocalSave(text);
}
/** 完成，清空临时变量 **/
function doClearSuccessLocalSave(text)
{
    doClearTempLocalSave(text);
}
/** 出错，清空临时变量 **/
function doClearErrorLocalSave(errText)
{
    ServiceAPI.doUpdateImage = 0;
    ServiceAPI.doUploadPdf = 0;
    ServiceAPI.doPreviewPdf = 0;
    ServiceAPI.doDownloadType = -1;
    if (typeof errText === "undefined")
        errText = "处理出错！";
    doClearTempLocalSave(errText);
}
/** 清空临时变量 **/
function doClearTempLocalSave(text)
{
    // 结束标识
    if (ServiceAPI.finishLocal)
        return;

    if (ServiceAPI.doUpdateImage || ServiceAPI.doUploadPdf || ServiceAPI.doPreviewPdf || ServiceAPI.doDownloadType >= 0)
    {
        setTimeout(doClearTempLocalSave,100,text);
        return;
    }

    // 清除弹窗
    var dialogObj = ServiceAPI.dialogObj;
    if (dialogObj && dialogObj.close && Z.T.isFunction(dialogObj.close))
    {
        var nowTime = new Date().getTime();
        var creatTime = dialogObj.creatTime_localSave;
        var minTime = 400;
        if (nowTime - creatTime < minTime)
        {
            setTimeout(dialogObj.close, minTime);
        }
        else
            dialogObj.close();
    }
    dialogObj = null;

    // 清除缓存
    // ServiceAPI.doUpdateImage = 0;      // 上传效果图
    // ServiceAPI.doUploadPdf = 0;        // 上传成品PDF
    // ServiceAPI.doPreviewPdf = 0;       // 预览PDF
    // ServiceAPI.doDownloadType = -1;    // -1：不下载，0：jpg，1：png，2：pdf
    ServiceAPI.dialogObj = null;      // dialog 对象
    ServiceAPI.pdfList = [];           // 初始化 pdfList
    ServiceAPI.pdfFinaly = null;      // 成品（合并后的）pdf数据
    ServiceAPI.imgPath = "";           // 缩略图服务器地址

    // 删除所有文件
    for(var i = 0;i < ServiceAPI.removeList.length;i++)
    {
        var fileReader = ServiceAPI.removeList[i];
        if (typeof fileReader === "object" && Z.T.isFunction(fileReader.remove))
        {
            fileReader.remove().then(function()
            {
                //
            }).catch(function(err)
            {
                console.log(err);
            });
        }
    }
    ServiceAPI.removeList = [];        // 待删除列表 removeList

    // 结束标识
    ServiceAPI.finishLocal = 1;

    // 弹窗
    if (text)
    {
        Z.T.isString(text) && Z.failure(text);
        (typeof text === "object") && Z.T.isString(text.message) && Z.failure(text.message);
    }
    else
    {
        // 完成回调
        Z.T.isFunction(ServiceAPI.doneCallback) && ServiceAPI.doneCallback(ServiceAPI.doneParam);
    }
    ServiceAPI.doneCallback = null;
    ServiceAPI.doneParam = null;
}

/** 执行客户端的 pdfList 生成 **/
function getPdfBySoftware(mediaObj, pageNum)
{
    // 替换图片地址
    function setImgNetUri (str)
    {
        var imgTag = "</image>";
        if (str.indexOf(imgTag) > -1)
        {
            var strList = str.split(imgTag);
            var pattAll = /<image[^>]+((xlink:href)|(href))[^>]+>/;
            var pattXlink = /<image[^>]+xlink:href[^>]+>/;
            var xlinkMatch = /<image[^>]+xlink:href[^>"']+(?:"|')([^>"']+)(?:"|')[^>]+>/;
            var pattHref = /<image[^>]+href[^>]+>/;
            var hrefMatch = /<image[^>]+href[^>"']+(?:"|')([^>"']+)(?:"|')[^>]+>/;
            var matchResult = null;

            var i = 0, strPart = "", uriStr = "";
            var doneTag = false;
            for (i;i < strList.length;i++)
            {
                strPart = strList[i];
                if (!pattAll.test(strPart))
                    continue;

                doneTag = false;
                if (pattXlink.test(strPart))
                {
                    matchResult = xlinkMatch.exec(strPart);
                    uriStr = matchResult && matchResult[1];
                    if (uriStr)
                        strPart = strPart.replace(new RegExp(uriStr, "g"), window.location.origin + uriStr);
                    doneTag = true;
                }
                if (pattHref.test(strPart) && !doneTag)
                {
                    matchResult = hrefMatch.exec(strPart);
                    uriStr = matchResult && matchResult[1];
                    if (uriStr)
                        strPart = strPart.replace(new RegExp(uriStr, "g"), window.location.origin + uriStr);
                }
                strList[i] = strPart;
            }
            str = strList.join(imgTag);
        }
        return str;
    };
    // 循环背景列表，生成pdf，添加到 pdfList
    function getPdfList ()
    {
        var bgObj = bgList[listIndex];

        // 1：新建容器 svg，版面最终的 svg
        var $svgWrap = document.createElementNS(xmlns, "svg");
        $svgWrap.setAttribute("xmlns", xmlns);
        $svgWrap.setAttribute("width", fullWidth);
        $svgWrap.setAttribute("height", fullHeight);
        $svgWrap.setAttribute("viewBox", "0 0 " + fullWidth + " " + fullHeight);

        // 2：新建容器 g，用于偏移和旋转
        var $gPage = document.createElementNS(xmlns, "g");
        var transX = 0, transY = 0, transR = "", deg = 0;
        if (bgObj.oddEven === 1)
        {
            if (listIndex % 2 === 0)
            {
                deg = 90;
                transX = fullWidth;
            }
            else
            {
                deg = 270;
                transY = fullHeight;
            }
            transR = " rotate(" + deg + " 0 0)";
        }
        var gTrans = "translate(" + transX + " " + transY + ")";
        gTrans += transR ? transR : "";
        $gPage.setAttribute("transform", gTrans);

        // 3：新建内容 svg，包含背景、素材、遮罩
        var $svgPage = document.createElementNS(xmlns, "svg");
        var svgWidth = 0, svgHeight = 0, svgView = "";
        if (bgObj.oddEven === 0)
        {
            svgWidth = fullWidth;
            svgHeight = fullHeight;
            if (listIndex % 2 === 0)
                svgView = '0 0';
            else
                svgView = widthSpace + ' 0';
            svgView += ' ' + fullWidth + ' ' + fullHeight;
        }
        else
        {
            svgWidth = fullHeight;
            svgHeight = fullWidth;
            if (listIndex % 2 === 0)
                svgView = '0 ' +  widthSpace;
            else
                svgView = heightSpace + ' ' +  widthSpace;
            svgView += ' ' + fullHeight + ' ' + fullWidth;
        }
        $svgPage.setAttribute("width", svgWidth);
        $svgPage.setAttribute("height", svgHeight);
        $svgPage.setAttribute("viewBox", svgView);

        // 4：插入背景
        var sourceStr = setImgNetUri(bgObj.source);
        $svgPage.insertAdjacentHTML("beforeend", sourceStr);

        // 5：插入素材
        var i = 0;
        var material = null;
        for (i;i < materialList.length;i++)
        {
            material = materialList[i];
            if (material.bid !== bgObj.bid)
                continue;
            // 替换图片相对路径为网络路径
            sourceStr = setImgNetUri(material.source);
            $svgPage.insertAdjacentHTML("beforeend", sourceStr);
        }

        // 6：插入遮罩
        var coverMaterial = null;
        for (i = 0;i < coverMaterialList.length;i++)
        {
            coverMaterial = coverMaterialList[i];
            if (coverMaterial.bid !== bgObj.bid)
                continue;
            $svgPage.insertAdjacentHTML("beforeend", coverMaterial.source);
        }

        // 7：组合成 $svgWrap
        $gPage.appendChild($svgPage);
        $svgWrap.appendChild($gPage);

        // 8：生成版面 pdf
        var svgCode = $svgWrap.outerHTML;
        var pdfName = serviceName + "_" + listIndex + "_";
        ServiceAPI.svg2pdf(svgCode, pdfName, pdfWidthMm, pdfHeightMm).then(function(file)
        {
            listIndex++;
            ServiceAPI.removeList.push(file);
            ServiceAPI.pdfList.push(file.path);
            if (listIndex >= pageNum)
                localSvg2PdfDone();
            else
                getPdfList();
        }).catch(function(err)
        {
            doClearErrorLocalSave(err);
        });
    };

    // 1：判断参数可用
    if (pageNum <= 0)
        return doClearErrorLocalSave(null);

    // 2：变量 - media 对象
    mediaObj = mediaObj || media;
    var canvas = mediaObj.canvas;
    var bgList = mediaObj.bgList;
    var materialList = mediaObj.materialList;
    var coverMaterialList = mediaObj.coverMaterialList;

    var fullWidth = canvas.fullWidth;
    var fullHeight = canvas.fullHeight;
    var widthSpace = canvas.width - canvas.fullWidth;
    var heightSpace = canvas.height - canvas.fullHeight;

    var serviceName = canvas.mediaId;
    var pdfWidthMm = canvas.fullWidthMm;
    var pdfHeightMm = canvas.fullHeightMm;
    ServiceAPI.pdfWidthMm = pdfWidthMm;
    ServiceAPI.pdfHeightMm = pdfHeightMm;

    // 3：循环背景列表，组装成 pdfList
    var listIndex = 0;
    getPdfList();
}
/** 客户端生成 pdfList 完成 **/
function localSvg2PdfDone()
{
    if (ServiceAPI.pdfList.length === 0)
        return doClearErrorLocalSave();

    var pdfName = media.canvas.mediaId + ".pdf";
    ServiceAPI.mergePdf(ServiceAPI.pdfList, pdfName).then(function(pdfFile)
    {
        ServiceAPI.removeList.push(pdfFile);
        ServiceAPI.pdfFinaly = pdfFile;

        // 1：更新缩略图
        // 2：预览pdf，先更新缩略图，再预览
        if (ServiceAPI.doPreviewPdf)
        {
            if (ServiceAPI.doUpdateImage)
                uploadImageLocal(previewPdfLocal);
            else
                previewPdfLocal();
        }
        else if (ServiceAPI.doUpdateImage)
        {
            uploadImageLocal();
        }
        // 3：下载 jpg
        if(ServiceAPI.doDownloadType === 0)
            downloadJpgLocal();
        // 4：下载 png
        if (ServiceAPI.doDownloadType === 1)
            downloadPngLocal();
        // 5：下载 pdf
        if (ServiceAPI.doDownloadType === 2)
            downloadPdfLocal();
    }).catch(function(err)
    {
        doClearErrorLocalSave(err);
    });
}

/** 上传本地生成的成品 pdf **/
function doUploadPdfLocal(pdfName, prePath, callback, ajaxParam)
{
    // 调用大文件上传
    pdfName = pdfName || media.canvas.mediaId + ".pdf";
    prePath = prePath || "";
    callback = callback || function(){doClearPreviewLocalSave()};

    // 执行上传
    var buffer = ServiceAPI.pdfFinaly.result;
    ServiceAPI.className = ajaxParam.className;
    ServiceAPI.methodName = ajaxParam.methodName;
    ServiceAPI.mediaId = ajaxParam.mediaId;
    ServiceAPI.mediaUrl = ajaxParam.mediaUrl;
    ServiceAPI.pdfPath = ajaxParam.pdfPath;
    uploadFileLocalByLarge(buffer, pdfName, prePath, callback, 1);
}
/** 上传效果图 **/
function uploadImageLocal(callback)
{
    // 获取上传参数
    var ajax = new Z.Ajax();
    ajax.setClassName("MediaPresenter");
    ajax.setMethodName("getMediaEffectData");
    ajax.addParam("mediaId", media.canvas.mediaId);
    ajax.setFailure(function()
    {
        Z.alert(this.responseText);
    });
    ajax.setSuccess(function()
    {
        var dataObj = Z.J.toObject(this.responseText);
        var doneCallback = function()
        {
            // 上传成功，回调（预览或者完成操作）
            Z.T.isFunction(callback) && callback() || (ServiceAPI.doUpdateImage = 0, doClearSuccessLocalSave());
        };
        // 执行上传
        ServiceAPI.className = "MediaPresenter";
        ServiceAPI.methodName = "updateMediaEffectData";
        ServiceAPI.mediaId = media.canvas.mediaId;
        ServiceAPI.mediaUrl = dataObj.mediaUrl;
        ServiceAPI.imgPath = dataObj.imgPath;
        ServiceAPI.pdfPath = "";
        doUploadImageLocal(dataObj.fileName, dataObj.uploadPath, dataObj.rootDir, doneCallback);
    });
    ajax.execute();
}
function doUploadImageLocal(imgName, prePath, rootDir, callback)
{
    var pdfWidth = mm2px(ServiceAPI.pdfWidthMm, 72);
    var pdfHeight = mm2px(ServiceAPI.pdfHeightMm, 72);
    var imgNum = pdfWidth >= pdfHeight ? 2 : 1;
    var imgRatio = 600 / pdfWidth;
    ServiceAPI.pdfToImage(ServiceAPI.pdfFinaly, "JPG", imgNum, imgRatio).then(function(imageList)
    {
        ServiceAPI.removeList = ServiceAPI.removeList.concat(imageList);
        var options =
            {
                direction: true,
                color: 0XFFFFFFFF,
                align: "center",
                offset: 8,
                margin: 8,
                type: "JPG",
            };
        ServiceAPI.mergeImage(imageList, options).then(function(imageFile)
        {
            ServiceAPI.removeList.push(imageFile);
            // 执行上传，更新缩略图
            var buffer = imageFile.result;
            imgName = imgName || media.canvas.mediaId + ".jpg";
            prePath = prePath || "";
            uploadFileLocalByLarge(buffer, imgName, prePath, callback, 2);
        }).catch(function(err)
        {
            doClearErrorLocalSave(err);
        });
    }).catch(function(err)
    {
        doClearErrorLocalSave(err);
    });
}
/** 调用大文件上传 **/
function uploadFileLocalByLarge(buffer, fileName, prePath, callback, uploadType)
{
    // uploadType：1：pdf成品，2：缩略图，
    var fileObj = new File([Uint8Array.from(buffer).buffer], fileName);
    workerPdfMaker.upload([fileObj],{
        locPathName: window.location.pathname,
        fileDir: prePath,
        uploadType: uploadType,
        className: ServiceAPI.className,
        methodName: ServiceAPI.methodName,
        mediaId: ServiceAPI.mediaId,
        mediaUrl: ServiceAPI.mediaUrl,
        pdfPath: ServiceAPI.pdfPath,
    }).then(function()
    {
        switch (uploadType)
        {
            case 1:
                break;
            case 2:
                break;
        }
        Z.T.isFunction(callback) && callback();
    }).catch(function(err)
    {
        doClearErrorLocalSave(err);
    });
}

/** 下载成品：jpg **/
function downloadJpgLocal()
{
    downloadImageLocal("JPG");
}
/** 下载成品：png **/
function downloadPngLocal()
{
    downloadImageLocal("PNG");
}
/** 下载成品：PDF **/
function downloadPdfLocal()
{
    ServiceAPI.pdfFinaly.save().then(function(newPdf)
    {
        ServiceAPI.doDownloadType = -1;
        doClearSuccessLocalSave();
    }).catch(function(err)
    {
        doClearErrorLocalSave(err);
    });
}
/** 下载成品：jpg/png **/
function downloadImageLocal(suffix)
{
    var imgNum = media.bgList.length;
    var pdfWidth = mm2px(ServiceAPI.pdfWidthMm, 72);
    var imgWidth = suffix === "PNG" ? 1600 : 800;
    var imgRatio = imgWidth / pdfWidth;
    ServiceAPI.pdfToImage(ServiceAPI.pdfFinaly, suffix, imgNum, imgRatio).then(function(imageList)
    {
        ServiceAPI.removeList = ServiceAPI.removeList.concat(imageList);
        ServiceAPI.zipFiles(imageList).then(function(zipFile)
        {
            ServiceAPI.removeList.push(zipFile);
            // 执行打包，下载
            zipFile.save().then(function(newZip)
            {
                ServiceAPI.doDownloadType = -1;
                doClearSuccessLocalSave();
            }).catch(function(err)
            {
                doClearErrorLocalSave(err);
            });

        }).catch(function(err)
        {
            doClearErrorLocalSave(err);
        });
    }).catch(function(err)
    {
        doClearErrorLocalSave(err);
    });
}

/** 预览：PDF **/
function previewPdfLocal()
{
    // 完成预览
    ServiceAPI.doPreviewPdf = 0;
    doClearSuccessLocalSave();
}