(function(Z)
{
//BEGIN

/********************************************
******************* 通用定义 ****************
********************************************/
//svg画布对象
var stageId = "stage_design";
var canvasId = "stage_canvas";
var canvasSvgId = "svg_canvas";
var canvasBgId = "svg_canvas_bg";
var canvasRectId = "svg_canvas_rect";
var canvasMaterialId = "svg_canvas_material";
var canvasCoverId = "svg_canvas_cover";
var selectionCoverId = "selection_cover";
var layerListId = 'layerList';

/********************************************
************ 媒体工具类 Z.Media **************
********************************************/
Z.MediaTool = Z.Class.newInstance();
Z.MediaTool.prototype = {
    init: function()
    {
        this.$designStage = Z.D.id(stageId);                            //整个设计区域对象
        this.$stageCanvas = Z.D.id(canvasId);                           //画布盒子对象
        this.$canvasSvg = Z.D.id(canvasSvgId);                          //画布对象-svg
        this.$canvasBg = Z.D.id(canvasBgId);                            //画布背景
        this.$canvasRectBox =  Z.D.id(canvasRectId);                    //画布边框盒子
        this.$canvasMaterial =  Z.D.id(canvasMaterialId);               //画布素材容器
        this.$canvasCover =  Z.D.id(canvasCoverId);                     //画布遮罩容器
        this.$svgCover = Z.D.id(selectionCoverId);                      //画布拖动事件遮罩对象
        this.$layerList = Z.D.id(layerListId);                          //图层列表对象

        this.layerType = 0;                //图层列表类型，0所有，1有参数
        this.tempMetabolic = null;         //临时素材对象，用于快捷键“复制”、“剪切”、“粘贴”操作
        this.allSvgElemInfo = null;        //所有素材的坐标信息，用于拖动排版、辅助线展示
        this.ajaxLoadedLength = 0;         //粘贴网络图片时，需加载的图片数量；用于判断是否全部加载完成
        
        this.tempMaterial = null;          //方便计算，存储当前唯一的素材对象
        this.tempElement = null;           //方便计算，存储当前唯一的节点元素
        
        this.tempSelLineStart = {};         //起始行对象，包含行索引，行内文字索引
        this.tempSelStart = 0;              //选中内容在文本内容的起始索引
        this.tempSelEnd = 0;                //选中内容在文本内容的结束索引
    },
    //生成完整画布
    createSvgCanvas: function(noResize)
    {
        // 初始化画布
        var bgObj = media.getCurBg();
        var bgIndex = media.bgList.indexOf(bgObj);
        var svgView = '';
        var widthSpace = media.canvas.width - media.canvas.fullWidth;
        var heightSpace = media.canvas.height - media.canvas.fullHeight;

        // 完整预览显示
        if (media.canvas.fullShow)
        {
            // 横板名片
            if (bgObj.oddEven === 0)
            {
                // 偶序版面
                if (bgIndex % 2 === 0)
                    svgView = '0 0';
                // 奇序版面
                else
                    svgView = widthSpace + ' 0';
                // svgView
                svgView += ' ' + media.canvas.fullWidth + ' ' + media.canvas.fullHeight;
            }
            // 竖版名片
            else
            {
                // 偶序版面
                if (bgIndex % 2 === 0)
                    svgView = '0 ' +  widthSpace;
                // 奇序版面
                else
                    svgView = heightSpace + ' ' +  widthSpace;
                // svgView
                svgView += ' ' + media.canvas.fullHeight + ' ' + media.canvas.fullWidth;
            }
        }
        // 仅显示素材区域
        else
        {
            svgView = '0 0 ' + bgObj.width + ' ' + bgObj.height;
        }
        this.$canvasSvg.setAttribute('viewBox', svgView);

        // 缩放画布大小
        if (noResize){
            this.setRatioCanvas(this.showRatio, true);
        } else {
            this.setRatioCanvas();
            this.locationTrueCanvas();
        }
    },
    // 初始化画布事件绑定
    initStageEvent: function()
    {
        // 画布区域的操作事件
        Z(this.$designStage).on("mousedown",mediaEvent.canvasMouseDown, mediaEvent);
        Z(this.$designStage).on("drop",mediaEvent.wrapFilesDrop,mediaEvent);
        // 文本编辑框事件
        Z("#textEditor").on("paste",mediaEvent.textPastePath, mediaEvent).on("blur",mediaEvent.textBlurPath, mediaEvent).on("click dblclick",Z.E.forbidden);
        Z("#sideTextEditor").on("focus",mediaEvent.textSideFocusPath, mediaEvent).on("blur",mediaEvent.textSideBlur, mediaEvent)
            .on("paste",mediaEvent.textPastePath, mediaEvent).on("input",mediaEvent.textSideInputPath, mediaEvent);
        // 画布
        Z(this.$canvasSvg).on("contextmenu", mediaEvent.canvasContextMenu).on("mouseup",mediaEvent.removeImgDraging);
        Z(this.$designStage).on("drop", Z.E.cancel);
    },
    // 按比例缩放画布大小
    setRatioCanvas: function(showRatio, doNotJudge)
    {
        var svgView = this.$canvasSvg.viewBox.baseVal;
        var canvasWidth = svgView.width;
        var canvasHeight = svgView.height;
        var setWidth , setHeight;
        if (showRatio)
        {// 有参数，按比例缩放
            this.showRatio = showRatio;
            setWidth = canvasWidth * this.showRatio;
            setHeight = canvasHeight * this.showRatio;
        }
        else
        {// 无参数，自适应缩放
            var designRatio = this.$designStage.offsetWidth / this.$designStage.offsetHeight;
            var canvasRatio = canvasWidth / canvasHeight;
            if (designRatio > canvasRatio)
            {//取最大高度值，按比例取宽度值
                setHeight = this.$designStage.offsetHeight - 200;
                //var width = Math.round(height * canvasRatio);
                setWidth = setHeight * canvasRatio;
            }
            else
            {//取最大宽度值，按比例取高度值
                setWidth = this.$designStage.offsetWidth - 200;
                //var height = Math.round(width / canvasRatio);
                setHeight = setWidth / canvasRatio;
            }
            
            //缩放比例
            this.showRatio = (setWidth / canvasWidth + setHeight / canvasHeight)/2;
        }
        
        //最小值设定
        setWidth = (setWidth > 0)?(setWidth):(100);
        setHeight = (setHeight > 0)?(setHeight):(100);
        
        //设置
        this.$stageCanvas.style.width = (setWidth + "px");
        this.$stageCanvas.style.height = (setHeight + "px");
        this.$canvasSvg.setAttribute("width",setWidth);
        this.$canvasSvg.setAttribute("height",setHeight);
        
        //显示缩放比
        Z(".zoom-text").html(Math.round(this.showRatio * 100) + "%");
        
        //设置出血线
        setBleedTool();
        
        //调整缩略图
        if (!doNotJudge) zoomAreaJudge();
    },
    // 获取当前状态，showRatio
    setThisShowRatio: function()
    {
        var viewObj = this.$canvasSvg.viewBox.baseVal;
        var showRect = this.$canvasSvg.getBoundingClientRect();
        this.showRatio = (showRect.width/viewObj.width + showRect.height/viewObj.height) / 2;
    },
    // 确定画布位置
    locationTrueCanvas: function()
    {
        var stageRect = this.$designStage.getBoundingClientRect();
        var canvasRect = this.$canvasSvg.getBoundingClientRect();
        var setLeft = (stageRect.width - canvasRect.width)/2 + "px";
        var setTop = (stageRect.height - canvasRect.height)/2 + "px";
        // 设置盒子位置
        this.$stageCanvas.style.left = setLeft;
        this.$stageCanvas.style.top = setTop;
    },
    
    /********************************************
    *********** 背景<填充/透明度>设置 ************
    ********************************************/
    // 初始化背景
    initBg: function()
    {
        if (this.$canvasBg.querySelector("svg")) {
            this.$canvasBg.removeChild(this.$canvasBg.querySelector("svg"));
        }
        
        var bgSource = this.$media.getBg(this.$media.curPage).source;
        if (Z.V.isEmptyBlank(bgSource)) {
            var bgSvg = this.createBgSvgElement();
            this.$canvasBg.appendChild(bgSvg);
            this.$media.getBg(this.$media.curPage).source = bgSvg.outerHTML;
        } else {
            this.$canvasBg.appendChild(Z(bgSource)[0]);
        }
    },
    // 设置SVG背景
    setBgSvgCode: function(svgCode)
    {
        function setBgCode()
        {
            $bgSvg.setAttribute("width", media.getCurBg().width);
            $bgSvg.setAttribute("height", media.getCurBg().height);
            bgObj.source = $bgSvg.outerHTML;
            $bgWrap.innerHTML = bgObj.source;

            // 1：判断当前选中框
            if (media.selectedList.length === 0)
            {
                if (Z('#toolbar').hasClass('active') || !Z('#selection_lock').isHide() || !Z('#selection_tool').isHide())
                    hideEditSelected(true);
            }
        }
        function setBgMaterial()
        {
            // 设置图片类型
            function setImage()
            {
                if ($bgSvg.tagName.toLowerCase() !== 'svg')
                    return false;
                var $g = $bgSvg.children[0];
                if ($g.tagName.toLowerCase() !== 'g')
                    return false;
                var $$child = $g.children;
                var $image = $$child[0];
                if ($$child.length !== 1 || $image.tagName.toLowerCase() !== 'image')
                    return false;
                var linkHref = $image.getAttribute('xlink:href');
                if (!linkHref)
                    return false;

                var svgView = $bgSvg.viewBox.baseVal;
                $bgSvg.setAttribute('preserveAspectRatio', 'none');
                $image.setAttribute('width', svgView.width + '');
                $image.setAttribute('height', svgView.height + '');
                $image.setAttribute('href', linkHref);
                svgCode = $bgSvg.outerHTML;
                return true;
            }
            // 插入素材：大小不变，做上对齐，锁定，置底
            function insertBgMaterial()
            {
                // 1：定义素材对象
                var mid_pos = media.getBgMaterialList(media.curPage).length;
                var bgMaterial =  new Z.Material(
                {
                    $media: media,
                    mediaId: media.canvas.mediaId,
                    bid: media.curPage,
                    mid: mid_pos,
                    pos: mid_pos,
                    type: materialType,
                    status: 3,
                    source: svgCode,
                    bgMaterial: true,
                });

                // 2：新增背景素材节点
                // 创建节点
                var $gWrap = document.createElementNS(xmlns, "g");
                var $gSvg = document.createElementNS(xmlns, "g");
                $gSvg.appendChild($bgSvg);
                $gWrap.appendChild($gSvg);
                // 设置属性
                var trans = "translate(0 0) rotate(0 " + setWidth / 2 + " " + setHeight / 2 +")";
                $gWrap.setAttribute("transform", trans);
                $gSvg.setAttribute("transform", "translate(0 0) scale(1 1)");
                $gWrap.setAttribute("data-bgmaterial", 'bgmaterial');
                bgMaterial.source = $gWrap.outerHTML;
                $gWrap.setAttribute("id", "svgElementSon_" + mid_pos);
                $gWrap.setAttribute("data-mid", mid_pos);
                $gWrap.setAttribute("data-pos", mid_pos);
                // 插入辅助点击的矩形
                $gWrap.insertAdjacentHTML("afterbegin",'<rect fill="rgba(0,0,0,0)" width="0" height="0"></rect>');
                var rect = $gWrap.querySelector("rect");
                rect.setAttribute("width", setWidth + '');
                rect.setAttribute("height", setHeight + '');
                // 插入节点
                $materialWrap.insertBefore($gWrap, $materialWrap.querySelector('g[id^="svgElementSon_"]'));
                // 添加操作事件
                _this.addEleEvents($gWrap);
                media.addMaterial(bgMaterial);

                // 3：bgMaterial 置底
                while (bgMaterial.pos > 0) {
                    bgMaterial.doUp();
                }

                // 4：判断当前选中框
                if (media.selectedList.length === 0)
                {
                    if (Z('#toolbar').hasClass('active') || !Z('#selection_lock').isHide() || !Z('#selection_tool').isHide())
                        selectTheElement(bgMaterial, $gWrap);
                }
            }

            // 1：设置大小
            var bgObj = media.getCurBg();
            var setWidth = bgObj.width;
            var setHeight = bgObj.height;
            $bgSvg.setAttribute('data-oldwidth', setWidth);
            $bgSvg.setAttribute('data-oldheight', setHeight);
            $bgSvg.setAttribute('width', setWidth);
            $bgSvg.setAttribute('height', setHeight);
            // 2：判断类型
            var materialType;
            if (setImage()) materialType = 0;
            else materialType = 3;
            // 3：添加背景
            insertBgMaterial();
        }

        // 1：判断已存在的背景
        var _this = this;
        var $bgWrap = _this.$canvasBg;
        var $materialWrap = _this.$canvasMaterial;

        // 1.1：纯背景
        Z('#bg_color').addClass('bgNone');
        var $bgFillSvg = _this.createBgSvgElement();
        var bgHtml = $bgFillSvg.outerHTML;
        var bgObj = media.getBg(media.curPage);
        bgObj.bgUrl = null;
        bgObj.bgMinUrl = null;
        bgObj.fileId = null;
        bgObj.source = bgHtml;
        if (bgSetType)
            $bgWrap.innerHTML = bgHtml;
        else
            $bgWrap.innerHTML = '';
        // 1.2：图层背景
        var $firstBgElem = $materialWrap.querySelector('g[id^="svgElementSon_"][data-bgmaterial]');
        if ($firstBgElem)
        {
            var firstMaterial = media.getMaterialByMid($firstBgElem.getAttribute('data-mid'));
            if (firstMaterial.bgMaterial)
            {
                firstMaterial.doDelete();
                Z($firstBgElem).remove();
            } else {
                $firstBgElem.removeAttribute('data-bgmaterial');
            }
        }

        // 2：分类
        var $bgSvg = Z(svgCode)[0];
        if (bgSetType)
            setBgMaterial();
        else
            setBgCode();
    },
    // 更新当前背景大小
    updateCurBgSize: function()
    {
        var bgSvg = this.$canvasBg.querySelector("svg");
        bgSvg.setAttribute("width", media.getCurBg().width);
        bgSvg.setAttribute("height", media.getCurBg().height);
        this.$media.getBg(this.$media.curPage).source = bgSvg.outerHTML;
    },
    // 更新指定背景大小
    updateBgSize: function(bid)
    {
        var bgSvg = Z(media.getBg(bid).source)[0];
        bgSvg.setAttribute("width", media.getBg(bid).width);
        bgSvg.setAttribute("height", media.getBg(bid).height);
        this.$media.getBg(bid).source = bgSvg.outerHTML;
    },
    // 设置背景填充颜色
    setFillColor: function(backgroundColor)
    {
        // 1：定义纯颜色背景
        Z('#bg_color').addClass('bgNone');
        var $bgFillSvg = this.createBgSvgElement();
        var rect = $bgFillSvg.querySelector("rect");
        rect.setAttribute("fill", backgroundColor);
        this.$canvasBg.innerHTML = $bgFillSvg.outerHTML;
        var bgObj = media.getBg(media.curPage);
        bgObj.bgUrl = null;
        bgObj.bgMinUrl = null;
        bgObj.fileId = null;
        bgObj.source = $bgFillSvg.outerHTML;

        // 2：去除图层背景
        var $firstBgElem = this.$canvasMaterial.querySelector('g[id^="svgElementSon_"][data-bgmaterial]');
        if ($firstBgElem)
        {
            var firstMaterial = media.getMaterialByMid($firstBgElem.getAttribute('data-mid'));
            if (firstMaterial.bgMaterial)
            {
                firstMaterial.doDelete();
                Z($firstBgElem).remove();
            } else {
                $firstBgElem.removeAttribute('data-bgmaterial');
            }
        }
    },
    // 设置填充的背景图片
    setFillUrl: function(bgUrl, fileId)
    {
        if (this.$canvasBg.querySelector("svg")) {
            this.$canvasBg.removeChild(this.$canvasBg.querySelector("svg"));
        }
        
        var bgSvg = this.createBgSvgElement();
        this.$canvasBg.appendChild(bgSvg);

        var imageEle = document.createElementNS(xmlns, "image");
        imageEle.setAttribute("preserveAspectRatio", "none");
        imageEle.setAttribute("width", "100%");
        imageEle.setAttribute("height", "100%");
        imageEle.setAttribute("xlink:href", bgUrl);
        imageEle.setAttribute("href", bgUrl);
        imageEle.setAttribute("id", "cardBj");
        bgSvg.appendChild(imageEle);
        var bgObj = media.getBg(media.curPage);
        bgObj.bgUrl = bgUrl;
        bgObj.fileId = fileId;
        bgObj.source = this.$canvasBg.querySelector("svg").outerHTML;
    },
    
    /********************************************
    ******************* 创建svg元素 **************
    ********************************************/
    // 新增SVG元素
    createNewSvgElement: function()
    {
        var $gWrap = document.createElementNS(xmlns, "g");
        var $gSvg = document.createElementNS(xmlns, "g");
        var $svg = document.createElementNS(xmlns, "svg");
        var $gInner = document.createElementNS(xmlns, "g");
        $svg.setAttribute("xmlns:xlink", "http://www.w3.org/1999/xlink");
        $svg.setAttribute("version", "1.1");
        $svg.setAttribute("preserveAspectRatio", "none");
        $gSvg.setAttribute("transform", "translate(0 0) scale(1 1)");

        $svg.appendChild($gInner);
        $gSvg.appendChild($svg);
        $gWrap.appendChild($gSvg);
        return $gWrap;
    },
    // 新增背景svg
    createBgSvgElement: function()
    {
        var $svg = document.createElementNS(xmlns, "svg");
        var $rect = document.createElementNS(xmlns, "rect");
        $rect.setAttribute("x", "0");
        $rect.setAttribute("y", "0");
        $rect.setAttribute("width", "100%");
        $rect.setAttribute("height", "100%");
        $rect.setAttribute("fill", "none");

        $svg.setAttribute("xmlns", xmlns);
        $svg.setAttribute("xmlns:xlink", xlink);
        $svg.setAttribute("preserveAspectRatio","none");
        $svg.setAttribute("width", media.getCurBg().width);
        $svg.setAttribute("height", media.getCurBg().height);
        $svg.appendChild($rect);
        return $svg;
    },
    // 新增图片SVG元素
    createImgSvgElement: function($img, notSaveNew, fun)
    {
        // 图片加载完成后
        function imgLoaded($tempImage)
        {
            // SVG素材的通用设置
            function setSvgElementAttribute()
            {
                //参数设置
                var $svg = $gWrap.querySelector("svg");
                $gWrap.setAttribute("id", "svgElementSon_" + $img.mid);
                $gWrap.setAttribute("data-mid", $img.mid);
                $gWrap.setAttribute("data-pos", $img.pos);
                //位置设置
                $svg.setAttribute("viewBox", "0 0 " + width + " " + height);
                $svg.setAttribute("width", width);
                $svg.setAttribute("height", height);
                var translate = "translate(" + x + " " + y + ")";
                var rotate = "rotate(0" + " " + width/2 + " " + height/2 +")";
                $gWrap.setAttribute("transform", translate + " " + rotate);
                //插入辅助点击的矩形
                $gWrap.insertAdjacentHTML("afterbegin",'<rect fill="rgba(0,0,0,0)"></rect>');
                var rect = $gWrap.querySelector("rect");
                rect.setAttribute("width", width);
                rect.setAttribute("height", height);
            }

            // 计算合适的显示宽高；最大边为画布一半
            var imgRatio = $tempImage.width / $tempImage.height;
            var canvasRatio = $tempImage.$media.getPageRatio();
            var width, height;
            if (imgRatio > canvasRatio) {
                width = Math.round(media.getCurBg().width / 2);
                height = Math.round(width / imgRatio);
            } else {
                height = Math.round(media.getCurBg().height / 2);
                width = Math.round(height * imgRatio);
            }
            //缩放了，就取图片原有大小
            width = (width > $tempImage.width) ? ($tempImage.width) : (width);
            height = (height > $tempImage.height) ? ($tempImage.height) : (height);
            //定义为居中位置
            var x = (media.getCurBg().width - width) / 2;
            var y = (media.getCurBg().height - height) / 2;
            //基础设置
            setSvgElementAttribute();
            $img.newMaterial = null;

            // 新图片素材，保存
            $svg.setAttribute("viewBox", "0 0 " + $tempImage.width + " " + $tempImage.height);
            $image.setAttribute("width", $tempImage.width);
            $image.setAttribute("height", $tempImage.height);
            $gWrap.removeAttribute('opacity');
            media.addMaterial($img);
            updateMaterialSource($img, $gWrap);
            if (!notSaveNew) {
                saveHistory();
                //添加完，选中该素材
                selectTheElement($img, $gWrap);
            }
            Z.T.isFunction(fun) && fun($img, $gWrap);
            //添加事件
            tempImage.$this.addEleEvents($gWrap);
            //清空临时对象
            tempImage = null;
        }

        // 主方法
        if (Z.V.isEmptyBlank($img.source)) {
            return;
        }
        // 1：定义、设置图片基础属性
        var $gWrap = this.createNewSvgElement();
        var $gSvg = $gWrap.querySelector("g");
        var $svg = $gSvg.querySelector("svg");
        var $gInner = $svg.querySelector("g");
        var $image = document.createElementNS(xmlns,"image");
        $gWrap.setAttribute('opacity', '0');
        $image.setAttribute("preserveAspectRatio", "none");
        $image.setAttribute("width","100%");
        $image.setAttribute("height","100%");
        $image.setAttribute("xlink:href", $img.source);
        $image.setAttribute("href", $img.source);
        $gInner.appendChild($image);
        this.$canvasMaterial.appendChild($gWrap);
        
        // 2：用 onload，获取图片属性
        var tempImage = new Image();
        tempImage.src = $img.source;
        tempImage.$this = this;
        tempImage.$media = this.$media;
        tempImage.onload = function() {
            imgLoaded(this);
        };
        return $gWrap;
    },
    // 初始素材 g 标签
    createSvgGElement: function(material)
    {
        var $gNew = document.createElementNS(xmlns, "g");
        $gNew.setAttribute("id", "svgElementSon_" + material.mid);
        $gNew.setAttribute("data-mid", material.mid);
        var paramKey=material.paramKey?material.paramKey:'';
        $gNew.setAttribute("data-cardtype", paramKey);
        $gNew.setAttribute("data-pos", material.pos);
        
        //新增一个辅助标签，获取属性值
        var $svgNew = Z("<svg></svg>");
        $svgNew.appendTo(Z(document));
        $svgNew.html(material.source);
        
        var $gWrap = $svgNew.children("g");
        var attr = $gWrap[0].attributes;
        var i, attrName, attrVal;
        var attrLength = attr.length;
        var ignoredArr = ['id', 'data-mid', 'data-pos', "opacity", 'data-opacity'];
        var hasChangeSource = false;
        for (i = 0; i < attrLength; i++)
        {
            attrName = attr[i].name;
            attrVal = attr[i].value;
            if (ignoredArr.indexOf(attrName) > -1){
                hasChangeSource = true;
                continue;
            }
            // 匹配 transform 属性值，不匹配时返回 null
            if (attrName === "transform") {
                if (!transformReg.test(attrVal)) {
                    return null;
                }
            }
            // 当前透明度设置都设置为1
            if (attrName === "fill-opacity" || attrName === "stroke-opacity"){
                if (attrVal !== "1")
                    hasChangeSource = true;
                attrVal = "1";
            }
            // 校验样式hiddenDoing
            if (attrName === "class" && attrVal && attrVal.indexOf("hiddenDoing") > -1){
                hasChangeSource = true;
                attrVal = attrVal.replace(/hiddenDoing/g, "").replace(/\s\s/g," ").trim();
            }
            $gNew.setAttribute(attrName, attrVal);
        }
        var $gSvg;
        if (!$gWrap.children("g")[0]){
            $gSvg = document.createElementNS(xmlns, "g");
            $gSvg.setAttribute("transform","translate(0 0) scale(1 1)");
            $gSvg.innerHTML = $gWrap.html();
            $gNew.appendChild($gSvg);
        } else {
            $gNew.innerHTML = $gWrap.html();
        }
        this.$canvasMaterial.appendChild($gNew);

        $gSvg = $gNew.querySelector("g");
        var $$svg = $gSvg.children;
        var svgLength = $$svg.length;
        var $svg = $$svg[svgLength - 1];
        var setWidth = $svg.getAttribute("width");
        var setHeight = $svg.getAttribute("height");

        // svg 宽度高度存在问题
        if (!setWidth || !setHeight || !parseFloat(setWidth) || !parseFloat(setHeight))
            return null;
        // svg 宽度高度存在 % 的情况
        if (setWidth.indexOf('%') > -1 || setHeight.indexOf('%') > -1)
        {
            hasChangeSource = true;
            var canvasViewBox = media.tool.$canvasSvg.viewBox.baseVal;
            if (setWidth.indexOf('%') > -1)
                setWidth = parseFloat(setWidth) / 100 * canvasViewBox.width;
            if (setHeight.indexOf('%') > -1)
                setHeight = parseFloat(setHeight) / 100 * canvasViewBox.height;
        }

        // 设置属性
        var $svgElem;
        for (i = 0;i < svgLength;i++)
        {
            $svgElem = $$svg[i];
            // 尺寸
            $svgElem.setAttribute("width", setWidth + '');
            $svgElem.setAttribute("height", setHeight + '');
            // old 属性设置
            if (!$svg.getAttribute('data-oldwidth')) $svg.setAttribute('data-oldwidth', setWidth);
            if (!$svg.getAttribute('data-oldheight')) $svg.setAttribute('data-oldheight', setHeight);
        }
        // 百分比计算后，刷新 source
        hasChangeSource && updateMaterialSource(material, $gNew);

        // 插入辅助点击的矩形
        $gNew.insertAdjacentHTML("afterbegin",'<rect fill="rgba(0,0,0,0)"></rect>');
        var $rect = $gNew.querySelector("rect");
        $rect.setAttribute("width", setWidth);
        $rect.setAttribute("height", setHeight);
        //添加操作事件
        this.addEleEvents($gNew);
        
        //删除辅助标签
        $svgNew.remove();
        return $gNew;
    },
    // 新增SVG元素
    createSvgCodeElement: function(material)
    {
        if (material.source === "") {
            material.doDelete();
            return;
        }
        var $gWrap = document.createElementNS(xmlns, "g");
        var $gSvg = document.createElementNS(xmlns, "g");
        var $svg = Z(material.source);
        var width = $svg.attr("width").baseVal.value;
        var height = $svg.attr("height").baseVal.value;
        var x = (media.getCurBg().width - width) / 2;
        var y = (media.getCurBg().height - height) / 2;

        $gSvg.appendChild($svg[0]);
        $gWrap.appendChild($gSvg);
        this.$canvasMaterial.appendChild($gWrap);

        var translate = "translate(" + x + " " + y + ")";
        var rotate = "rotate(0 " + width / 2 + " " + height / 2 +")";
        $gWrap.setAttribute("transform", translate + " " + rotate);

        var gSvgX = 0;
        var gSvgY = 0;
        var gSvgScale = "1 1";
        if (material.reversal)
        {
            gSvgScale = material.reversal;
            if (material.reversal === "-1 -1"){
                gSvgX = -width;
                gSvgY = -height;
            } else if (material.reversal === "-1 1"){
                gSvgX = -width;
            } else if (material.reversal === "1 -1"){
                gSvgY = -height;
            }
        }
        $gSvg.setAttribute("transform", "translate(" + gSvgX + " " + gSvgY + ") scale(" + gSvgScale + ")");
        
        material.source = $gWrap.outerHTML;

        $gWrap.setAttribute("id", "svgElementSon_" + material.mid);
        $gWrap.setAttribute("data-mid", material.mid);
        $gWrap.setAttribute("data-pos", material.pos);

        //插入辅助点击的矩形
        $gWrap.insertAdjacentHTML("afterbegin",'<rect fill="rgba(0,0,0,0)" width="0" height="0"></rect>');
        var rect = $gWrap.querySelector("rect");
        rect.setAttribute("width", width);
        rect.setAttribute("height", height);
        //添加操作事件
        this.addEleEvents($gWrap);
        return $gWrap;
    },
    // 获取指定的素材元素
    getCurSvgElement: function(index)
    {
        if (this.$media.selectedList.length === 0)
            return null;
        index = index || 0;
        return this.$canvasMaterial.querySelector("#svgElementSon_" + this.$media.getCurMaterial(index).mid);
    },
    // 根据MID获取当前svg元素
    getSvgElementByMid: function(mid)
    {
        return this.$canvasMaterial.querySelector("#svgElementSon_" + mid);
    },
    //添加元素操作事件
    addEleEvents: function(ele)
    {
        Z(ele).on("dblclick",mediaEvent.dblEventStart, mediaEvent);
        Z(ele).on("mousedown",mediaEvent.eleMouseDown, mediaEvent);
        Z(ele).on("mouseenter",mediaEvent.eleMouseEnter, mediaEvent);
        Z(ele).on("mouseleave",mediaEvent.eleMouseLeave, mediaEvent);
        Z(ele).on("contextmenu",mediaEvent.materialContextMenu);
        Z(ele).on("dragstart",Z.E.forbidden);
        var $svgFrameImg = Z(ele).find(".svgFrame-img")[0];
        if ($svgFrameImg) {
            Z($svgFrameImg).on("mouseenter",mediaEvent.svgFrameMouseEnter, mediaEvent);
            Z($svgFrameImg).on("mouseleave",mediaEvent.svgFrameMouseLeave, mediaEvent);
            Z($svgFrameImg).on("mouseup",mediaEvent.svgFrameMouseUp, mediaEvent);
        }
    },
    // 获取SVG对象属性
    getEleData: function (ele)
    {
        if (!ele || Z(ele).attr("data-mid").length === 0){
            return {};
        }
        var eleData = {};
        var material = media.getMaterialByMid(Z(ele).attr("data-mid"));
        var $svgElem = ele.querySelector("svg");
        eleData.width = $svgElem.width.baseVal.value;
        eleData.height = $svgElem.height.baseVal.value;
        eleData.x = ele.transform.baseVal[0].matrix.e;
        eleData.y = ele.transform.baseVal[0].matrix.f;
        eleData.rotate =  ele.transform.baseVal[1].angle;
        eleData.opacity = Z(ele).attr('opacity');
        eleData.fontFamily = material.fontFamily;
        eleData.fontSize = material.fontSize;
        eleData.color = material.color;
        
        if (parseFloat(material.type) === 1) {
            var trueHeight = $svgElem.getBBox().height;
            eleData.heightRatio = trueHeight / eleData.height;
            eleData.sizeRatio = eleData.fontSize / trueHeight;
        }
        return eleData;
    },
    // 存储当前唯一的素材、节点
    setTempCurrent: function (material, $curElem)
    {
        this.tempMaterial = material || null;
        this.tempElement = $curElem || null;
    }
}

//END
})(zhiqim);