
/********************************************
******************* 全局常量 ****************
********************************************/
var xmlns = "http://www.w3.org/2000/svg";
var xlink = "http://www.w3.org/1999/xlink";
var transformReg = /^translate(\s+)?\((\s+)?-?\d+(\.\d+)?[,\s]+-?\d+(\.\d+)?(\s+)?\)(\s+)?rotate(\s+)?\((\s+)?-?\d+(\.\d+)?([,\s]+-?\d+(\.\d+)?[,\s]+-?\d+(\.\d+)?)?(\s+)?\).*/;
var frameDefaultUrl = 'https://yangcai-res.oss-cn-shenzhen.aliyuncs.com/inc/img/container_default.png';
var richTextHideId = '#tool_fontSize,#tool_fontSpacing,#tool_fontStroke,#tool_fontVertical,#tool_fontSpecial';
var toolBarObjList =
{// 第一行：左侧显示的按钮；第二行：右侧显示的按钮
    'text': [
        'tool_location', 'tool_svgColor',
        'tool_copy', 'tool_lock', 'tool_reversal', 'tool_sort', /*'tool_opacity',*/ 'tool_rotate', 'tool_delete'
    ], 'image':  [
        'tool_location', 'tool_svgSize', 'tool_svgCut', 'tool_svgRadius',
        'tool_copy', 'tool_lock', 'tool_reversal', 'tool_sort', 'tool_rotate', 'tool_delete'
    ], 'svg' :  [
        'tool_location', 'tool_svgSize', 'tool_insertAttr',
        'tool_copy', 'tool_lock', 'tool_reversal', 'tool_sort', 'tool_rotate', 'tool_delete'
    ], 'frame' :  [
        'tool_location', 'tool_svgCut',
        'tool_copy', 'tool_lock', 'tool_reversal', 'tool_sort', 'tool_rotate', 'tool_delete'
    ], 'shape' :  {
        'shape-line': [
            'tool_location', 'tool_svgSize', 'tool_svgColor', 'tool_lineCap', 'tool_lineDash',
            'tool_copy', 'tool_lock', 'tool_sort', 'tool_rotate', 'tool_delete'
        ],
        'shape-rect': [
            'tool_location', 'tool_svgSize', 'tool_svgColor', 'tool_svgRadius',
            'tool_copy', 'tool_lock', 'tool_sort', 'tool_rotate', 'tool_delete'
        ],
        'shape-rectStroke': [
            'tool_location', 'tool_svgSize', 'tool_svgColor', 'tool_svgRadius', 'tool_shapeStroke',
            'tool_copy', 'tool_lock', 'tool_sort', 'tool_rotate', 'tool_delete'
        ],
        'shape-ellipse': [
            'tool_location', 'tool_svgSize', 'tool_svgColor', 'tool_shapeStroke',
            'tool_copy', 'tool_lock', 'tool_sort', 'tool_rotate', 'tool_delete'
        ],
        'shape-pen': [
            'tool_location', 'tool_svgSize', 'tool_svgColor', 'tool_shapeStroke',
            'tool_copy', 'tool_lock', 'tool_sort', 'tool_rotate', 'tool_delete'
        ],
        'shape-table': [
            'tool_location', 'tool_svgSize', 'tool_fontFamily', 'tool_fontSize', 'tool_fontWeight', 'tool_fontStyle',
            'tool_fontDecoration', 'tool_fontAlign', 'tool_fontSpacing', 'tool_insertAttr',
            'tool_copy', 'tool_lock', 'tool_sort', 'tool_rotate', 'tool_delete'
        ],
    }, 'group' :  [
        'tool_location', 'tool_svgColor',
        'tool_copy', 'tool_lock', 'tool_sort', /*'tool_opacity',*/ 'tool_delete'
    ],
};
var svgTypeToName =
{
    'text' : { 'name' : '文字'},
    'image' : { 'name' : '图片', 'width' : '宽度', 'height' : '高度'},
    'svg' : { 'name' : '素材', 'width' : '宽度', 'height' : '高度'},
    'frame' : { 'name' : '容器'},
    'shape' : {
        'shape-line': {'name' : '线条','width' : '长度','height' : '大小'},
        'shape-rect': {'name' : '矩形','width' : '宽度','height' : '高度'},
        'shape-rectStroke': {'name' : '矩形框','width' : '宽度','height' : '高度'},
        'shape-ellipse': {'name' : '圆形','width' : 'x轴','height' : 'y轴'},
        'shape-pen': {'name' : '形状','width' : '宽度','height' : '高度'},
        'shape-table': {'name' : '表格','width' : '宽度','height' : '高度'},
    },
};
// 钢笔新切线
var newTangentString = '<div class="penTangent-item">' +
    '<div class="penTangent-item-current penTangent-item-prev"><div class="penTangent-item-btn"></div></div>' +
    '<div class="penTangent-item-current penTangent-item-next"><div class="penTangent-item-btn"></div></div>' +
    '<div class="penTangent-item-current penTangent-item-this"><div class="penTangent-item-btn"></div></div>' +
    '</div>';
// 常量：元素节点
var $toolbar, $toolsWrap, $toolsWrapLeft, $toolsWrapRight, $historyTips;
// 常量：操作对象素材ID
var midArr = [], bidArr = [];
// 背景添加模式
var bgSetType = true;
// 常量：数据对象
var cardBaseData;
// 常量，尺寸误差
var deviationSizeMm = 0.001;
var deviationSizePx = 0.01;
// 常量，默认的字体大小PX
var baseFontSizePt = 7;
var baseFontSizePx = 16;
var minFontSizePx = 12;
var fS2LHRatio = 1.3;
var tableTextAreaPdTop = 6;
var tableTextAreaPdRight = 6;
var tableTextAreaPdBottom = 6;
var tableTextAreaPdLeft = 7;

/********************************************
******************* 定位算法 ****************
********************************************/
/** 定位select-tool的位置、大小 */
function setToolStaticLoc ($curElem)
{
    // 1：定义变量
    $curElem = $curElem || media.tool.tempElement || media.tool.getCurSvgElement();
    var $gWrap = $curElem.querySelector('g');
    var $svg = [...$gWrap.children].pop();
    var transformList = $curElem.transform.baseVal;
    var svgType = $svg.getAttribute("data-type");
    var lt = matrixTranslate($curElem);
    var setLeft = 0, setTop = 0;
    if (svgType !== "shape-line" && !lt){
        setLeft = transformList[0].matrix.e;
        setTop = transformList[0].matrix.f;
    } else {
        setLeft = lt[0];
        setTop = lt[1];
    }
    var setTrans = "rotate(" + transformList[1].angle + "deg)";

    // 3：计算 width、height
    var showRatio = media.tool.showRatio;
    var setWidth = $svg.width.baseVal.value;
    var setHeight = $svg.height.baseVal.value;
    setWidth *= showRatio;
    setHeight *= showRatio;

    // 4：计算 left、top
    var designStage = media.tool.$designStage.getBoundingClientRect();
    var bgRect = media.tool.$canvasBg.getBoundingClientRect();
    setLeft *= showRatio;
    setTop *= showRatio;
    setLeft += bgRect.left - designStage.left;
    setTop += bgRect.top - designStage.top;

    // 5：形状“线条”，特殊处理
    if (svgType === "shape-line")
    {
        setWidth += 10;
        setHeight += 10;
        setLeft -= 5;
        setTop -= 5;
    }

    // 6：定位
    Z("#selection_tool").css(
    {
        "width": setWidth,
        "height": setHeight,
        "left": setLeft,
        "top": setTop,
        "transform": setTrans
    })
}
/*** 更新画布中显示的辅助框位置 ***/
function setAllToolLoc() {
    // 悬浮框
    var $hoverTool = Z("#selection_hover");
    if (!$hoverTool.isHide()) {
        selectionHover_show($hoverTool[0].$targ);
    }
    // 选中框、锁定框
    selectionToolsShow_group();

    // 如果存在编辑框
    if (Z.D.id("textEditor") && Z.D.id("textEditor").hasAttribute("style"))
        editorLocResize();
}

/** 重定义素材位置，矩阵计算 **/
function editOverSet ($curElem)
{
    // 主方法，定义变量
    $curElem = $curElem || media.tool.tempElement || media.tool.getCurSvgElement();
    var $gSvg = $curElem.querySelector("g");
    var $$svg = $gSvg.children;
    var svgLength = $$svg.length;
    var $svg = $$svg[svgLength - 1];
    var svgWidth = $svg.width.baseVal.value;
    var svgHeight = $svg.height.baseVal.value;
    var oldArr, oldW, oldH, nxy, trans;

    // 1：判断是否可计算
    oldArr = getElemOldData($curElem);
    oldW = oldArr[0];
    oldH = oldArr[1];
    if (!oldW || !oldH){
        return;
    }

    // 2：计算得到校准偏移
    oldW = parseFloat(oldW);
    oldH = parseFloat(oldH);
    nxy = matrixTranslate($curElem, oldW, oldH);
    
    // 3：素材修改偏移
    var r = $curElem.transform.baseVal[1].angle;
    var rx = svgWidth / 2;
    var ry = svgHeight / 2;
    trans = "translate("+ nxy[0] +" "+ nxy[1] +") rotate(" + r + " " + rx + " " + ry + ")";
    $curElem.setAttribute("transform",trans);
    
    // 4：重赋值 old 数据
    var targetData = mediaEvent.startData.targData;
    if (targetData && targetData.width && targetData.height){
        mediaEvent.startData.targData = media.tool.getEleData($curElem);
    }
    var $svgElem, i;
    for (i = 0;i < svgLength;i++) {
        $svgElem = $$svg[i];
        $svgElem.setAttribute("data-oldwidth", svgWidth + '');
        $svgElem.setAttribute("data-oldheight", svgHeight + '');
    }
}
// 计算并返回 left、top
function matrixTranslate($curElem, oldW, oldH)
{
    // 矩阵相乘
    function matrixMultiply(m1, m2)
    {
        m1 = m1.map(function(ele) {
            return parseFloat(ele);
        });

        m2 = m2.map(function(ele) {
            return parseFloat(ele);
        });

        var a = m1[0]*m2[0]+m1[2]*m2[1];
        var c = m1[0]*m2[2]+m1[2]*m2[3];
        var e = m1[0]*m2[4]+m1[2]*m2[5]+m1[4];

        var b = m1[1]*m2[0]+m1[3]*m2[1];
        var d = m1[1]*m2[2]+m1[3]*m2[3];
        var f = m1[1]*m2[4]+m1[3]*m2[5]+m1[5];

        return [a, b, c, d, e, f];
    }
    // 计算中心点坐标
    function computeCenter(x, y, width, height, m)
    {
        var maxCx, maxCy, minCx, minCy;
        //变换后的左上角x,y坐标,css默认以中心点为坐标原点，所以左上角相对于中心的位置是(-width/2,-height/2)
        //根据matrix变换运算公式得到如下新坐标
        var x1 = -m[0]*width/2 - m[2]*height/2 + m[4];
        var y1 = -m[1]*width/2 - m[3]*height/2 + m[5];
        //中心相对于原坐标系坐标为(x + width/2, y + height/2)
        //左上角新坐标需加上中心坐标偏移量才能得到其在原坐标体系中的坐标位置
        x1 = x + width/2 + x1;
        y1 = y + height/2 + y1;
        maxCx = x1;
        maxCy = y1;
        minCx = x1;
        minCy = y1;

        var x2 = -m[0]*width/2 + m[2]*height/2 + m[4];
        var y2 = -m[1]*width/2 + m[3]*height/2 + m[5];
        x2 = x + width/2 + x2;
        y2 = y + height/2 + y2;
        maxCx = x2>maxCx?x2:maxCx;
        maxCy = y2>maxCy?y2:maxCy;
        minCx = x2<minCx?x2:minCx;
        minCy = y2<minCy?y2:minCy;

        var x3 = m[0]*width/2 - m[2]*height/2 + m[4];
        var y3 = m[1]*width/2 - m[3]*height/2 + m[5];
        x3 = x + width/2 + x3;
        y3 = y + height/2 + y3;
        maxCx = x3>maxCx?x3:maxCx;
        maxCy = y3>maxCy?y3:maxCy;
        minCx = x3<minCx?x3:minCx;
        minCy = y3<minCy?y3:minCy;

        var x4 = m[0]*width/2 + m[2]*height/2 + m[4];
        var y4 = m[1]*width/2 + m[3]*height/2 + m[5];
        x4 = x + width/2 + x4;
        y4 = y + height/2 + y4;
        maxCx = x4>maxCx?x4:maxCx;
        maxCy = y4>maxCy?y4:maxCy;
        minCx = x4<minCx?x4:minCx;
        minCy = y4<minCy?y4:minCy;

        var ox = minCx+(maxCx-minCx)/2;
        var oy = minCy+(maxCy-minCy)/2;

        return [ox, oy];
    }

    // 主方法
    var $gWrap = $curElem.querySelector('g');
    var $svg = [...$gWrap.children].pop();
    if (!oldW && !oldH)
    {
        var oldArr = getElemOldData($curElem);
        oldW = oldArr[0];
        oldH = oldArr[1];
    }
    if (!oldW || !oldH){
        return;
    }
    var w = $svg.width.baseVal.value, h = $svg.height.baseVal.value;
    var sx = w / oldW, sy = h / oldH,
        array2 = [sx, 0, 0, sy, 0, 0],
        dx = (w - oldW)/(2*sx), dy = (h - oldH)/(2*sy),
        array3 = [-1, 0, 0, 1, dx, dy],

        m0 = $curElem.transform.baseVal[0].matrix,
        array0 = [m0.a, m0.b, m0.c, m0.d, m0.e, m0.f],
        m1 = $curElem.transform.baseVal[1].matrix,
        array1 = [m1.a, m1.b, m1.c, m1.d, 0, 0],

        matrix = matrixMultiply(matrixMultiply(matrixMultiply(array0, array1), array2), array3),
        center = computeCenter(0, 0, oldW, oldH, matrix),
        left = center[0] - w / 2,
        top = center[1] - h / 2;
    return [left, top, center];
}
// 获得素材 oldW、oldH
function getElemOldData($curElem)
{
    var $svgElem = $curElem.querySelector("svg");
    var hasTargetData, oldW, oldH;
    if (mediaEvent.startData.targData){
        hasTargetData = Boolean(mediaEvent.startData.targData.width && mediaEvent.startData.targData.height);
    } else {
        hasTargetData = false;
    }
    oldW = hasTargetData ? mediaEvent.startData.targData.width : ($svgElem.getAttribute('data-oldwidth') || 0);
    oldH = hasTargetData ? mediaEvent.startData.targData.height : ($svgElem.getAttribute('data-oldheight') || 0);
    if (!oldW || !oldH){
        console.log('计算 oldW、oldH 出错！素材id：' + $curElem.id);
        return [0, 0];
    }
    return [oldW, oldH];
}

/************* 辅助工具显示和隐藏 **************/
/** 显示辅助框 **/
// 悬浮展示框
function selectionHover_show(ele)
{
    ele = ele || media.tool.tempElement || media.tool.getCurSvgElement();
    selectionToolsShow("#selection_hover",ele);
}
// 缩放编辑框
function selectionTool_show(ele)
{
    ele = ele || media.tool.tempElement || media.tool.getCurSvgElement();
    selectionAll_hide();
    selectionToolsShow("#selection_tool",ele);
}
function selectionLock_show(ele)
{//锁定框辅助框
    ele = ele || media.tool.tempElement || media.tool.getCurSvgElement();
    selectionAll_hide();
    selectionToolsShow("#selection_lock",ele);
}
// 辅助框位置显示实现
function selectionToolsShow(id, $curElem)
{
    // 1：定义变量
    $curElem = $curElem || media.tool.tempElement || media.tool.getCurSvgElement();
    if (!$curElem)
        return;
    var material = media.getMaterialByMid($curElem.getAttribute("data-mid"));
    if (!material)
        return;
    if (!id)
    {
        if (material.status === 0)
            id = "#selection_tool";
        else if (material.status === 3)
            id = "#selection_lock";
    }
    var $gWrap = $curElem.querySelector('g');
    var $svg = [...$gWrap.children].pop();
    var showRatio = media.tool.showRatio;
    var $selTool = Z(id);

    // 2：获取素材偏移，考虑翻转后的效果
    var transList = $curElem.transform.baseVal;
    var i, transAngle, setLeft, setTop;
    for (i = 0;i < transList.length;i++)
    {
        if (transList[i].type === 2){
            setLeft = transList[i].matrix.e;
            setTop = transList[i].matrix.f;
        }
        if (transList[i].type === 4){
            transAngle = transList[i].angle;
        }
    }

    // 3：计算 width、height
    var setWidth = $svg.width.baseVal.value;
    var setHeight = $svg.height.baseVal.value;
    setWidth *= showRatio;
    setHeight *= showRatio;

    // 4：计算 left、top
    var canvasRect = media.tool.$designStage.getBoundingClientRect();
    var bgRect = media.tool.$canvasBg.getBoundingClientRect();
    setLeft *= showRatio;
    setTop *= showRatio;
    setLeft += bgRect.left - canvasRect.left;
    setTop += bgRect.top - canvasRect.top;

    // 5：形状“线条”特殊处理
    if ($svg.getAttribute("data-type") === "shape-line")
    {
        setWidth += 10;
        setHeight += 10;
        setLeft -= 5;
        setTop -= 5;
        $selTool.addClass("lineRotate");
    } else {
        $selTool.removeClass("lineRotate");
    }

    // 6：定位
    $selTool.css({
        "width": setWidth,
        "height": setHeight,
        "left": setLeft,
        "top": setTop,
        "transform": "rotate(" + transAngle + "deg)",
        "display": "block",
    });

    // 7：显示辅助框时，如果是选中框，判断参数列表是否需要显示
    if (id !== "#selection_tool" && id !== "#selection_lock")
        return;
    Z('#paramList>li').removeClass("active");
    if (media.selectedList.length === 1)
    {
        if (!material.paramKey || !material.paramName)
            return;
        var $targLi = Z('#paramList>li[data-mid="'+material.mid+'"][data-bid="'+material.bid+'"]');
        if (parseFloat($targLi.attr("data-bid")) === parseFloat(media.curPage))
            $targLi.addClass("active");
        else
            Z("#paramList>li").removeClass("active");
    }

    // 8：缩放选择框显示，区分不同类型
    if (id === "#selection_lock")
        return;
    Z("#selection_tool>.rotate>span").html("");
    var svgType = $curElem.querySelector("svg").getAttribute("data-type");
    if (material.type === 1)
        $selTool.attr("class", "selection-tool resizePoint textTool");
    else if (material.type === 4)
        $selTool.attr("class", "selection-tool resizePoint frameTool");
    else if (material.type === 5)
    {
        if (svgType === "shape-line")
            $selTool.attr("class", "selection-tool resizePoint lineRotate");
        else
            $selTool.attr("class", "selection-tool resizePoint");
    } else
        $selTool.attr("class", "selection-tool resizePoint");
}
/** 同步缩放文本编辑框 **/
function editorLocResize()
{
    var material = media.tool.tempMaterial || media.getCurMaterial();
    var $wrap = Z.D.id("textEditorWrap");
    var $editor = Z.D.id("textEditor");
    var showRatio = media.tool.showRatio;
    var oldR = mediaEvent.startData.editorOldLoc.r;
    var setWidth = parseFloat(Z($editor).css('width')) * showRatio / oldR;
    var setHeight = parseFloat(Z($editor).css('height')) * showRatio / oldR;
    var setLeft = parseFloat(Z($wrap).css('left')) * showRatio / oldR;
    var setTop = parseFloat(Z($wrap).css('top')) * showRatio / oldR;

    var textZoom = material.textZoom.split(" ");
    var fontSize = material.fontSize;
    var transOrigin = setWidth * parseFloat(textZoom[0]) / 2 + "px " + setHeight * parseFloat(textZoom[1]) / 2 + "px 0px";
    if (parseFloat(media.canvas.createMode) === 0) {
        fontSize = pt2px(fontSize);
    }
    Z($editor).css({
        "width": setWidth,
        "fontSize" : fontSize * showRatio,
        "letterSpacing": parseFloat(material.letterSpacing) * showRatio + "px",
        "lineHeight": parseFloat(material.lineHeight) * showRatio + "px",
    });
    Z($wrap).css({
        "left": setLeft,
        "top": setTop,
        "transform-origin": transOrigin,
    });

    // 重计算 editorOldLoc
    var oldX = mediaEvent.startData.editorOldLoc.x;
    var oldY = mediaEvent.startData.editorOldLoc.y;
    mediaEvent.startData.editorOldLoc = {
        'x' : oldX * showRatio / oldR,
        'y' : oldY * showRatio / oldR,
        'r' : showRatio,
    }
}
/** 隐藏辅助框 **/
function selectionHover_hide(clear)
{//悬浮展示框
    selectionToolsHide("#selection_hover", clear);
}
function selectionTool_hide(clear)
{//缩放编辑框
    selectionToolsHide("#selection_tool", clear);
}
function selectionLock_hide(clear)
{//锁定框
    selectionToolsHide("#selection_lock", clear);
}
function selectionAll_hide(clear)
{//全部隐藏
    selectionToolsHide(".selection-tool", clear);
}
function selectionToolsHide(selector, clear)
{
    Z(selector).removeAttr("style").removeClass("groupTool");
    if (clear)
        media.clearSelected();
}

/** 拖动对齐辅助线 **/
// 获取对比对象
function guideGetInfo(isAll)
{
    // 1：定义变量
    // 第一个数组存放“竖列”（left、right），
    // 第二个数组存放“横行”（top、bottom），
    // 第三个数组存放对应的对象
    media.tool.allSvgElemInfo = [[],[],[]];

    // 2：记录其他素材的位置信息，添加到数组
    Z.each(Z("[id^=svgElementSon]"), function($elem)
    {
        var thisId = parseInt(Z($elem).attr("data-mid"));
        var $childRect = $elem.querySelector("rect");
        var thisRect = $elem.getBoundingClientRect();
        if ($childRect) {
            thisRect = $childRect.getBoundingClientRect();
        }
        // 是否是所有对象
        if (!isAll)
        {
            // 如果是当前选中对象，或是被删除、被隐藏、；则返回
            for (var i = 0;i < media.selectedList.length;i++)
                if (thisId === media.getCurMaterial(i).mid)
                    return;
        }
        media.tool.allSvgElemInfo[0].push(thisRect.left, thisRect.left + thisRect.width/2, thisRect.right);
        media.tool.allSvgElemInfo[1].push(thisRect.top, thisRect.top + thisRect.height/2, thisRect.bottom);
        media.tool.allSvgElemInfo[2].push($elem);
    });
}
// 对比数据，设置辅助线
function guideSetInfo(deviation)
{
    deviation = deviation || 6;
    // 记录当前对象的位置信息
    var elemInfo = [], elemRect = Z("#selection_tool")[0].getBoundingClientRect();
    //“竖列”
    elemInfo.push(elemRect.left, elemRect.left + elemRect.width/2, elemRect.right);
    //“横行”
    elemInfo.push(elemRect.top, elemRect.top + elemRect.height/2, elemRect.bottom);
    
    // 辅助线设置之前，先移除，避免反复设置
    Z(".guide-line").remove();

    // 遍历6个参数，进行对比，找到最接近的值
    Z.each(elemInfo,function(info, index)
    {
        var arr = (index < 3)?(media.tool.allSvgElemInfo[0]):(media.tool.allSvgElemInfo[1]);
        var cssStyle = (index < 3)?("left"):("top");
        guideSetInfoAppend(info, arr, cssStyle, deviation, index);
    });
}
// 辅助线样式、插入
function guideSetInfoAppend(info, arr, cssStyle, deviation, index)
{
    // 1：定义变量
    var minusArr = arr.map(function(item) {
            return Math.abs(item - info)
        });
    var minMinus = deviation, minMinusIndex = 0;
    var showRatio = media.tool.showRatio;

    // 2：取出 minusArr 中最小值，及其索引
    minusArr.forEach(function(num, arrIndex)
    {
        if (num < minMinus)
        {
            minMinus = num;
            minMinusIndex = arrIndex;
        }
    });

    // 3：差值不在显示范围，返回
    if (minMinus >= deviation)
        return;

    // 4：则显示虚线框
    // 4.1：定义变量
    var canvasRect = media.tool.$canvasSvg.getBoundingClientRect();
    var bgRect = media.tool.$canvasBg.getBoundingClientRect();
    var setGuideLoc = arr[minMinusIndex] - canvasRect[cssStyle];                                    //对齐线的相对位置
    var guideBaseElem = media.tool.allSvgElemInfo[2][Math.floor(minMinusIndex / 3)];            //后续可能有用，对比的对象素材

    // 4.2：计算素材位置
    var shouldLoc;                                                                              //理论值
    var dataType = (cssStyle === "left")?("x"):("y");
    shouldLoc = mediaEvent.startData.targData[dataType] + mediaEvent.doingData[dataType];
    shouldLoc *= showRatio;
    var toolRect = Z("#selection_tool")[0].getBoundingClientRect();
    var setToolLoc = setGuideLoc;                                                               //设置值
    switch (index)
    {
        case 0:                                                     //left
            break;
        case 1:                                                     //left + width/2
            setToolLoc -= toolRect.width / 2;
            break;
        case 2:                                                     //right
            setToolLoc -= toolRect.width;
            break;
        case 3:                                                     //top
            break;
        case 4:                                                     //top + width/2
            setToolLoc -= toolRect.height / 2;
            break;
        case 5:                                                     //bottom
            setToolLoc -= toolRect.height;
            break;
    }
    var styleSpace = bgRect[cssStyle] - canvasRect[cssStyle];
    var deSetLoc = setToolLoc - (shouldLoc + styleSpace);
    if (Math.abs(deSetLoc) > deviation)
        return;

    // 4.4：插入对齐辅助线
    var $guideElem = Z('<div class="guide-line z-absolute z-w100p z-h100p" style="border-style:dashed;border-color:#bbb;border-width:1px 1px 0 0"></div>');
    var guideStyle_left = (cssStyle === "left")?("top"):("left"), guideStyle_width = (cssStyle === "left")?("width"):("height");
    $guideElem.appendTo(Z("#selection_guide")).css(cssStyle, setGuideLoc).css(guideStyle_left, 0).css(guideStyle_width, 1);

    // 4.5：选择框定位
    Z("#selection_tool").css(cssStyle, setToolLoc);

    // 4.6：素材位移，通过选择框反算
    var setSvgLoc = (setToolLoc - styleSpace) / showRatio;
    if (media.selectedList.length === 1)
    {
        var curElem = media.tool.tempElement || media.tool.getCurSvgElement();
        var x = curElem.transform.baseVal[0].matrix.e;
        var y = curElem.transform.baseVal[0].matrix.f;
        if (cssStyle === "left") updateMaterialPos(setSvgLoc, y, i);
        if (cssStyle === "top") updateMaterialPos(x, setSvgLoc, i);
    }
    else
    {
        toolRect = Z("#selection_tool")[0].getBoundingClientRect();
        var deGroupSetX = (toolRect.left - canvasRect.left) / showRatio - mediaEvent.startData.targData.x;
        var deGroupSetY = (toolRect.top - canvasRect.top) / showRatio - mediaEvent.startData.targData.y;
        var i, elemData, mLeft, mTop, $elem, trans;
        for (i = 0;i < mediaEvent.startData.elemsData.length;i++)
        {
            elemData = mediaEvent.startData.elemsData[i];
            mLeft = elemData.left + deGroupSetX;
            mTop = elemData.top + deGroupSetY;
            $elem = media.tool.getCurSvgElement(elemData.index);
            // 画布展示
            trans = $elem.getAttribute("transform");
            trans = trans.replace(/translate\([^)]+\)/, 'translate(' + mLeft + ' ' + mTop + ')');
            $elem.setAttribute("transform",trans);
        }
    }
}

/********************************************
**************** 多选对象的定位 **************
********************************************/
function getSvgElementGroup()
{//框选素材
    var tempList = [];
    var innerNum = 0;
    //计算选区范围内的SVG
    var selGroup = Z.D.id("selection_group").getBoundingClientRect();
    if (selGroup.width <= 2 || selGroup.height <= 2){
        return;
    }
    media.clearSelected();
    var itemXArr = media.tool.allSvgElemInfo[0], itemYArr = media.tool.allSvgElemInfo[1], itemArr = media.tool.allSvgElemInfo[2];
    var i, mid, material, itemLeft, itemTop, itemRight, itemBottom;

    // 遍历所有素材
    for (i = 0;i < itemArr.length;i++)
    {
        mid = itemArr[i].getAttribute("data-mid");
        material = media.getMaterialByMid(mid);
        // if (material.isTable)
        //     continue;

        itemLeft = itemXArr[3*i];
        itemTop = itemYArr[3*i];
        itemRight = itemXArr[3*i + 2];
        itemBottom = itemYArr[3*i + 2];
        if (itemLeft > selGroup.right || itemRight < selGroup.left ||
            itemTop > selGroup.bottom || itemBottom < selGroup.top)
        {// 不符合要求，跳过操作
            continue;
        }
        innerNum++;
        material.status = parseInt(material.status);
        // 选中的素材，加入选中列表
        if (material.status === 0)
        {// 默认选中正常素材
            if (!mediaEvent.selectGroup(material)) {
                material.doMutliSelected();
            }
        }
        if (material.status === 3)
        {// 临时数组用来存储 “已锁定” 素材
            tempList.push(mid);
        }
    }
    if (innerNum > 0 && tempList.length === innerNum)
    {//所有素材都是已锁定时；重新选中
        media.clearSelected();
        for (i = 0;i < tempList.length;i++) {
            material = media.getMaterialByMid(tempList[i]);
            if (!mediaEvent.selectGroup(material)) {
                material.doMutliSelected();
            }
        }
    }
    //执行缩放框显示定位
    selectionToolsShow_group();
}
function selectionToolsShow_group()
{//多选状态的辅助框位置显示实现
    if (media.selectedList.length === 0)
        return;

    // 显示工具栏
    showEditToolbar();
    Z('#tool_svgColor').show();//多选让颜色显示

    // 单素材
    if (media.selectedList.length === 1)
        return selectionToolsShow();

    // 多素材，最终的参数
    var width, height, left, top;

    // 过度数据
    var leftArr = [], topArr = [], rightArr = [], bottomArr = [];
    for (var i = 0;i < media.selectedList.length;i++)
    {
        var elem = media.tool.getSvgElementByMid(media.selectedList[i]);
        var elemData = getEleClientRect(elem);
        leftArr.push(elemData.left);
        topArr.push(elemData.top);
        rightArr.push(elemData.left_right);
        bottomArr.push(elemData.top_bottom);
    }

    // 赋值大小，定位
    var stageRect = media.tool.$designStage.getBoundingClientRect();
    var bgRect = media.tool.$canvasBg.getBoundingClientRect();
    left = getMinNum(leftArr);
    top = getMinNum(topArr);
    width = getMaxNum(rightArr) - left;
    height = getMaxNum(bottomArr) - top;
    left += bgRect.x - stageRect.x;
    top += bgRect.y - stageRect.y;

    // 页面呈现效果
    var firstMaterial = media.getMaterialByMid(media.selectedList[0]);
    var selector = "#selection_tool";
    if (firstMaterial.status === 3)
        selector = "#selection_lock";
        
    // 显示辅助框前，先隐藏所有
    selectionAll_hide();
    Z(selector).removeAttr("style").css({"width": width, "height": height, "left": left, "top": top}).addClass("groupTool").show();
    if (Z(selector).hasClass("lineRotate")){
        Z(selector).removeClass("lineRotate");
    }

    // 显示对应的图层选中
    Z(media.tool.$layerList).children("li").removeClass("active");
    for (var j = 0;j < media.selectedList.length;j++)
    {
        var theMid = media.getMaterialByMid(media.selectedList[j]).mid;
        var layerItem = Z(media.tool.$layerList).find("li[data-mid='" + theMid + "']");
        layerItem.addClass("active");
    }

    // 隐藏参数列表的选中参数
    Z("#paramList>li").removeClass("active");
}
function getEleClientRect($elem)
{//获取元素，距离画布四边数据
    if (!$elem){
        return null;
    }
    var $childRect = $elem.querySelector("rect");
    var svgElemData;
    if ($childRect) {
        svgElemData = $childRect.getBoundingClientRect();
    } else {
        svgElemData = $elem.getBoundingClientRect();
    }
    
    var stageRect = media.tool.$stageCanvas.getBoundingClientRect();
    var svgClientRect = {};
    svgClientRect.left = svgElemData.left - stageRect.left;               //元素左-盒子左
    svgClientRect.top = svgElemData.top - stageRect.top;                  //元素上-盒子顶
    svgClientRect.left_right = svgElemData.right - stageRect.left;        //元素右-盒子左
    svgClientRect.top_bottom = svgElemData.bottom - stageRect.top;        //元素下-盒子顶
    svgClientRect.right = stageRect.width - svgClientRect.left_right;     //元素右-盒子右
    svgClientRect.bottom = stageRect.width - svgClientRect.top_bottom;    //元素下-盒子底
    return svgClientRect;
}

/********************************************
****************** 颜色选择器 ****************
********************************************/
/** 生成颜色选择器 **/
function createColorPicker()
{
    var colorAlternatived =[
        "EB3D00","EC3A3E","F25F61","FA9D99","F67D6F","C28482","C26A74","976D6B","C16B61","955942",
        "F48000","F47E36","F99F3D","F99F61","D76F4C","F99E7E","FCC78C","FEC7AF","BF6C35","C18557",
        "FDC800","FDFA00","FDFC72","FDFE99","FEFEC6","C1A25F","C0C165","94946A","968064","71624E",
        "009049","1E8F6E","6AC334","AADC7D","8FAE6B","8FAE84","75886C","75887E","95947E","72635B",
        "AADBC7","62C2A1","90AD9F","00AEC4","218E9E","1E8F85","2B726C","567C7E","455F60","4D4A42",
        "340C70","0074C5","0089E1","60BFF3","90ABBD","758792","5C676E","5F6D84","706F61","414548",
        "EF2F72","FD9CB9","C4A0AB","C38296","C371A0","C3538B","A14875","A06186","97576D","824275",
        "653B73","774389","97679F","C18DB8","BBB0D4","9081B6","715D9D","7A6F95","977F87","73545D",
        "9B2575","9E7996","495577","6476B3","624F5D","4F495C","684B6C","7F647A","FFFFFF","000000",
    ];
    // 定义列数，计算行数
    var columns = 10;
    var lines = Math.ceil(colorAlternatived.length / columns);
    // 计算灰度色值
    var grayNum = 15 / (lines - 2);
    // 通用颜色变量
    var color = "";
    var html = '<div class="fte-colorPicker" data-columns="' + columns + '"><div class="fte-colorPicker-dropperCover"></div><div class="fte-colorPicker-content">';
    html += '<div class="fte-colorPicker-tabbar"><span onclick="switchPicker(this,event);" data-type=0 class="active">选择颜色</span><span onclick="switchPicker(this,event);" data-type=1>调色板</span></div>'
    html += '<div class="fte-colorPicker-table"><table><tr><td colspan=12 class="fte-colorPicker-title">最近使用</td></tr><tr class="fte-colorPicker-lastColors"></tr>';
    html += '<tr><td colspan=12 class="fte-colorPicker-title">预选颜色</td></tr>';
    html += '</table><table class="fte-colorPicker-colorTable">';
    // 循环，所有颜色
    for (var i = 0;i < lines;i++)
    {                             // 行 i
        html += '<tr>';
        var hexNum = Math.abs(Math.floor(15 - (i - 1) * grayNum)).toString(16);
        var grayColor = '#' + new Array(7).join(hexNum);
        if (i === 0)
            html += '<td><a class="bgNone" data-value="none" title="none"></a></td>';
        else
            html += '<td><a style="background:' + grayColor + ';" data-value="' + grayColor + '" title="' + grayColor + '"></a></td>';
        html += '<td style="border:none;"></td>';
        for (var j = 0;j < columns;j++)
        {                         // 列 j
            color = colorAlternatived[i*columns + j];
            if (!color) {
                break;
            }
            html += '<td><a style="background:#' + color + ';" data-value="#' + color + '" title="#' + color + '"></a></td>';
        }
        html += '</tr>';
    }
    html += '</tr></table></div>';
    html += '<div class="fte-colorPicker-toning"><div class="fte-colorPicker-canvas"><div class="fte-colorPicker-canvasBtn"></div></div>';
    html += '<div class="fte-colorPicker-slider"><div class="fte-colorPicker-sliderBtn"></div></div>';
    html += '</div>';
    // 结果颜色 显示，可输入，可吸取
    html += '<div class="fte-colorPicker-title">HEX 颜色值</div>';
    html += '<input type="text" id = "fte-colorPicker-input" class="z-input z-small" placeholder="#" value="#FFFFFF" spellcheck="false">';
    html += '<a class="fte-colorPicker-eyedropper" title="颜色拾取"><img src="../zres/zhiqimMediaEditor/img/eyedropper.cur"></a>';
    html += '<div class="fte-colorPicker-title">CMYK 颜色值<div class="z-float-right z-px12 z-color-999">显示百分比';
    html += '<input id="fte-colorPicker-cmykSwitch" class="z-mg-l3 z-pointer" type="checkbox" checked></div></div>';
    html += '<div class="fte-colorPicker-CMYKFlex"><div><a type="text" value="" class="fte-colorPicker-selected"></a></div>';
    html += '<div><span>C</span><input type="text" value="" class="z-input z-small"></div>';
    html += '<div><span>M</span><input type="text" value="" class="z-input z-small"></div>';
    html += '<div><span>Y</span><input type="text" value="" class="z-input z-small"></div>';
    html += '<div><span>K</span><input type="text" value="" class="z-input z-small"></div>';
    html += '</div></div>';
    html += '<div class="fte-colorPicker-arrow"></div></div>';
    
    Z(document).append(Z(html));
    // 初始化
    Z(".fte-colorPicker")[0].colorPickerData = {};
    inputBoxChanged();
    // 绑定事件
    Z(".fte-colorPicker").on("mousedown mouseup click dblclick",Z.E.stop)//.on("mouseleave",colorPickerHide);
    Z(".fte-colorPicker a,.fte-colorPicker-tabbar").on("mousedown",Z.E.forbidden);
    Z(".fte-colorPicker-colorTable").on("mouseleave",doColorLeave);
    Z(".fte-colorPicker-colorTable a").on("mouseenter",doColorHover).on("click",doColorPicker);
    Z(".fte-colorPicker-eyedropper").on("click",eyedropperShow);
    Z(".fte-colorPicker input").on("mousedown mouseup click dblclick", Z.E.stop);
    Z("#fte-colorPicker-cmykSwitch").on("change", cmykValueTypeSwitch);
    Z(".fte-colorPicker-CMYKFlex .z-input").on("input",inputCMYKInput).on("change",inputCMYKChanged);
    Z("#fte-colorPicker-input").on("input",inputBoxInput).on("change",inputBoxChanged);
    // 调色板的事件
    Z(".fte-colorPicker-canvas").on("mousedown",fCP_canvasMousedown).on("mousemove",fCP_canvasMousemove);
    Z(".fte-colorPicker-slider").on("mousedown",fCP_sliderMousedown).on("mousemove",fCP_sliderMousemove);
    Z(".fte-colorPicker-canvas,.fte-colorPicker-slider").on("mouseup mouseleave",function(){fCP_down = false;});
    
    Z("#tool_svgColor").click(function(){//点击上面选色版清除缓存
     //alert("hello")
     sessionStorage.clear();
    })
    Z("#tool_fontSpecial").click(function(){//自己添加的一些逻辑
        var sum=sessionStorage.getItem("num")
        //alert(sum)
        var ValColor=Z("#fte-colorPicker-input").val()
         if(sum==1){
         // sessionStorage.removeItem('valColor');
          Z("#fte-colorPicker-input").val('')
         }else{
           sessionStorage.setItem("valColor",ValColor)
           console.log(ValColor)
         }   
      });
    
    
    
    //Z("#tool_fontSpecial").click(function(){
       //var ValColor=Z("#fte-colorPicker-input").val()
       // sessionStorage.setItem("valColor",ValColor)
    // });
      
      
     
      
      
}
   
var fCP_rgb, fCP_hsv;
var fCP_lastX, fCP_lastY;
var fCP_down = false;
var fCP_colorArr = [];
function colorChanged(){
    var hex = rgbToHex(fCP_rgb.r, fCP_rgb.g, fCP_rgb.b);
    var hueRgb = hsvToRgb(fCP_hsv.h, 1, 1);
    var hueHex = rgbToHex(hueRgb.r, hueRgb.g, hueRgb.b);

    // 拾色器颜色、位置
    Z(".fte-colorPicker-canvas").css("backgroundColor",hueHex);
    Z(".fte-colorPicker-canvasBtn").css({
        "left": ((fCP_hsv.v*199)-7).toString() + "px",
        "top": (((1-fCP_hsv.s)*199)-7).toString() + "px",
    });
    Z(".fte-colorPicker-sliderBtn").css("top", ((fCP_hsv.h*199)-5).toString() + "px");

    // 颜色展示
    setSvgSelected(hex);
}
function rgbChanged() {
    fCP_hsv = rgbToHsv(fCP_rgb.r, fCP_rgb.g, fCP_rgb.b);
    colorChanged();
}
function hsvChanged() {
    fCP_rgb = hsvToRgb(fCP_hsv.h, fCP_hsv.s, fCP_hsv.v);
    colorChanged();
}
function satValDragged(x, y) {                //矩形色块区域
    fCP_hsv.s = 1-(y/199);
    fCP_hsv.v = (x/199);
    hsvChanged();
}
function hueDragged(x, y) {                   //条形色块区域
    fCP_hsv.h = y/199;
    hsvChanged();
}
function fixCoords(x, y, node) {              //获取相对距离
    var nodeCoords = node.getBoundingClientRect();
    x = (x - nodeCoords.left);
    y = (y - nodeCoords.top);
    if (x < 0) x = 0;
    if (y < 0) y = 0;
    if (x > node.offsetWidth - 1) x = node.offsetWidth - 1;
    if (y > node.offsetHeight - 1) y = node.offsetHeight - 1;
    return {x: x, y: y};
}
function cmykValueTypeSwitch(event)
{
    // 检测当前值是否是转换后的值
    function checkCmykDone()
    {
        for (i = 0;i < attrArr.length;i++){
            if($$input[i].value !== cmykVal[attrArr[i]] + ''){
                setArr.push(1);
            } else {
                setArr.push(0);
            }
        }
    }

    // 主方法
    var $checkbox = Z.E.target(event);
    var $$input = Z('.fte-colorPicker-CMYKFlex .z-input');
    var hexVal = Z('#fte-colorPicker-input').val();
    var cmykVal = hex2cmyk(hexVal);
    var attrArr = ['c', 'm', 'y', 'k'];
    var setArr = [], i;

    // 重设 cmykVal
    if (!$checkbox.checked) {
        for(i in cmykVal){
            cmykVal[i] = Math.round(cmykVal[i] * 255 / 100);
        }
    }
    checkCmykDone();
    setArr.forEach(function(toDo, index){
        if (toDo){
            $$input[index].value = cmykVal[attrArr[index]];
        }
    })
}
function inputCMYKChanged()
{
    var isPercentVal = Z.D.id('fte-colorPicker-cmykSwitch').checked;
    var $$input = Z('.fte-colorPicker-CMYKFlex .z-input');
    var cmykVal = [];
    var hexVal;
    $$input.each(function($input){cmykVal.push($input.value);});
    if (!isPercentVal){
        cmykVal.forEach(function(item,index){
            cmykVal[index] = Math.round(item * 100 / 255);
        });
    }
    hexVal = cmyk2hex(cmykVal[0], cmykVal[1], cmykVal[2], cmykVal[3]);
    setSvgSelected(hexVal);
}
function inputCMYKInput(event)
{
    var $input = Z(Z.E.target(event));
    var val = $input.val() || '0';
    var isPercentVal = Z.D.id('fte-colorPicker-cmykSwitch').checked;
    var maxNum = 100;
    var valReg = /^0+/;
    if (valReg.test(val)){
        if (parseFloat(val) > 0){
            val = val.replace(valReg, '');
        } else {
            val = '0';
        }
    }
    val = val.replace(/[^\d\.]/g, '');
    while (val.indexOf('.') !== val.lastIndexOf('.')){
        val = val.substring(0, val.lastIndexOf('.'));
    }
    if (!isPercentVal){
        maxNum = 255;
    }
    if (val < 0) {
        val = 0;
    }
    if (val >= maxNum) {
        val = maxNum;
    }
    $input.val(val);
}
function inputBoxChanged() {
    var val = Z("#fte-colorPicker-input").val();
    fCP_rgb = hexToRgb(val, {r: 0, g: 0, b: 0});
    rgbChanged();
}
function inputBoxInput() {
    var val = Z("#fte-colorPicker-input").val();
    val = val.replace(/[^#0-9a-fA-F]/g, '');
    if (val === "") {
        val = "#";
    }
    if (val.indexOf("#") > -1) {
        while (val.indexOf("#") !== val.lastIndexOf("#")){
            val = val.substring(0, val.lastIndexOf("#"));
        }
        if (val.indexOf("#") !== 0){
            val = val.replace(/#/g, '').substring(0, 6);
        } else if (val.length > 7) {
            val = val.substring(0, 7);
        }
    } else if (val.length > 6) {
        val = val.substring(0, 6);
    }
    Z("#fte-colorPicker-input").val(val);
}
function fCP_canvasMousedown(event) {
    Z.E.forbidden(event);
    fCP_down = true;
    var mouseLoc = getMouseLocation(event);
    var thisLoc = fixCoords(mouseLoc.x, mouseLoc.y, Z(".fte-colorPicker-canvas")[0]);
    fCP_lastX = thisLoc.x;
    fCP_lastY = thisLoc.y;
    satValDragged(fCP_lastX, fCP_lastY);
}
function fCP_canvasMousemove(event) {
    if (fCP_down == false) return;
    var mouseLoc = getMouseLocation(event);
    var thisLoc = fixCoords(mouseLoc.x, mouseLoc.y, Z(".fte-colorPicker-canvas")[0]);
    if (thisLoc.x != fCP_lastX || thisLoc.y != fCP_lastY) {
        fCP_lastX = thisLoc.x;
        fCP_lastY = thisLoc.y;
        satValDragged(fCP_lastX, fCP_lastY);
    }
}
function fCP_sliderMousedown(event) {
    Z.E.forbidden(event);
    fCP_down = true;
    var mouseLoc = getMouseLocation(event);
    var thisLoc = fixCoords(mouseLoc.x, mouseLoc.y, Z(".fte-colorPicker-slider")[0]);
    fCP_lastX = thisLoc.x;
    fCP_lastY = thisLoc.y;
    hueDragged(fCP_lastX, fCP_lastY);
}
function fCP_sliderMousemove(event) {
    if (fCP_down == false) return;
    var mouseLoc = getMouseLocation(event);
    var thisLoc = fixCoords(mouseLoc.x, mouseLoc.y, Z(".fte-colorPicker-slider")[0]);
    if (thisLoc.x !== fCP_lastX || thisLoc.y !== fCP_lastY) {
        fCP_lastX = thisLoc.x;
        fCP_lastY = thisLoc.y;
        hueDragged(fCP_lastX, fCP_lastY);
    }
}
// 设置显示选中的颜色
function setColorSelected(color)
{
    Z(".fte-colorPicker-selected").css("background",color);
    Z("#fte-colorPicker-input").val(color);

    // cmyk 显示
    var $$cmykInput = Z('.fte-colorPicker-CMYKFlex .z-input');
    var cmykVal;
    if (/^#[0-9A-F]{6}$/.test(color)) {
        cmykVal = hex2cmyk(color);
        var isPercentVal = Z.D.id('fte-colorPicker-cmykSwitch').checked;
        if (!isPercentVal) {
            for(var i in cmykVal)
                cmykVal[i] = Math.round(cmykVal[i] * 255 / 100);
        }
    } else {
        cmykVal = { c: '', m: '', y: '', k: ''}
    }
    ['c', 'm', 'y', 'k'].forEach(function (param, index){
        $$cmykInput[index].value = cmykVal[param];
    })
}
/** 切换颜色选择 **/
function switchPicker($elem,event) {
    Z($elem).addClass("active").siblings("span").removeClass("active");
    var dataType = parseInt(Z($elem).attr("data-type"));
    var $table = Z($elem).parent().parent().children(".fte-colorPicker-table");
    var $toning = Z($elem).parent().parent().children(".fte-colorPicker-toning");
    if (dataType == 0) {                                   //选择颜色
        $table.show();
        $toning.hide();        
        insertLastColor(Z("#fte-colorPicker-input").val());
    } else {                                               //调色板
        $table.hide();
        $toning.show();
        //执行颜色光标定位
        setToningCursor();
    }
}
function setToningCursor()
{// 光标定位当前颜色
    var val = Z("#fte-colorPicker-input").val();
    fCP_rgb = hexToRgb(val, {r: 0, g: 0, b: 0});
    fCP_hsv = rgbToHsv(fCP_rgb.r, fCP_rgb.g, fCP_rgb.b);
    
    var hex = rgbToHex(fCP_rgb.r, fCP_rgb.g, fCP_rgb.b);
    var hueRgb = hsvToRgb(fCP_hsv.h, 1, 1);
    var hueHex = rgbToHex(hueRgb.r, hueRgb.g, hueRgb.b);

    // 拾色器颜色、位置
    Z(".fte-colorPicker-canvas").css("backgroundColor",hueHex);
    Z(".fte-colorPicker-canvasBtn").css({
        "left": ((fCP_hsv.v*199)-7).toString() + "px",
        "top": (((1-fCP_hsv.s)*199)-7).toString() + "px",
    });
    Z(".fte-colorPicker-sliderBtn").css("top", ((fCP_hsv.h*199)-5).toString() + "px");

    // 结果颜色展示
    setColorSelected(hex);
}
/** 颜色选择器隐藏 **/
function colorPickerHide(ev)
{//颜色选择器隐藏
    Z(".fte-colorPicker").removeAttr("style").find(".fte-colorPicker-eyedropper,.fte-colorPicker-dropperCover").removeClass("fte-active");
    // 执行保存
    saveHistory();
    // 执行历史颜色保存
    var color = Z("#fte-colorPicker-input").val();
    insertLastColor(color);
}
/** 在颜色历史插入新颜色 **/
function insertLastColor(color)
{
    color = color.toLowerCase();
    if (Z.AR.contains(fCP_colorArr, color)) {
        return;
    }
    // 历史记录最大值
    var columns = parseInt(Z(".fte-colorPicker").attr("data-columns")) + 3;
    var maxLine = 2;
    var maxLength = maxLine * (columns - 1);
    fCP_colorArr.push(color);
    if (fCP_colorArr.length > maxLength)
        fCP_colorArr.shift();

    var $color;
    if (color === 'none')
        $color = Z('<td><a class="bgNone" data-value="' + color + '" title="' + color + '"></a></td>');
    else
        $color = Z('<td><a style="background:' + color + ';" data-value="' + color + '" title="' + color + '"></a></td>');
    var $$trs = Z(".fte-colorPicker-lastColors");
    var lastIndex = $$trs.length - 1;
    // 历史记录显示
    $$trs.each(function($tr,lineIndex)
    {
        // 插入第一个位置
        var $first = Z($tr).find("td:first-child");
        if ($first[0]) {
            $color.insertBefore($first);
        } else {
            Z($tr).append($color);
        }
        // 添加事件
        if (lineIndex === 0) {
            $color.find("a").on("mousedown",function (e){Z.E.forbidden(e)}).on("click",doColorPicker);
        }
        // 判断换行/新增行
        var $$childTd = Z($tr).children("td");

        $color = Z($tr).find("td:last-child");
        if (lineIndex === lastIndex) {
            if ($$childTd.length !== columns)
                return;
            if (lineIndex === maxLine - 1)
                return $color.remove();
            var $newTr = Z('<tr class="fte-colorPicker-lastColors"></tr>');
            $newTr.insertAfter($tr);
            $newTr.append($color);
        }
    });
}
/** 颜色选择器相关事件 **/
// 鼠标离开颜色区域，显示结果值
function doColorLeave()
{
    var $picker = Z('#' + Z(".fte-colorPicker")[0].colorPickerData.colorId);
    var color;
    if ($picker.hasClass('bgNone'))
        color = 'none';
    else
        color = rgb2hex($picker.css('backgroundColor'));
    setColorSelected(color);
}// 鼠标悬浮显示该颜色值
function doColorHover(event)
{
    var color = Z.E.target(event).getAttribute("data-value");
    setColorSelected(color);
}
// 点击选中事件
function doColorPicker(param)
{
    var color;
    if (param.type && param.type === "click"){
        Z.E.forbidden(param);
        color = Z.E.target(param).getAttribute("data-value");
    } else {
        color = param;
    }
    setSvgSelected(color);

    // 插入历史记录
    insertLastColor(color);
}
/*使用颜色拾色器*/
function eyedropperShow(e)
{//点击显示
    Z.E.forbidden(e);
    var $thisBtn = Z(Z.E.current(e));
    if (typeof(ColorSelect) === "undefined") {
        return Z.alert("该功能仅限在专用客户端使用!");
    }
    if ($thisBtn.hasClass("fte-active")){
        Z(".fte-colorPicker-eyedropper,.fte-colorPicker-dropperCover").removeClass("fte-active");
        //绑定离开隐藏绑定事件
        // Z(".fte-colorPicker").on("mouseleave",colorPickerHide);
        return;
    }
    Z(".fte-colorPicker-eyedropper,.fte-colorPicker-dropperCover").addClass("fte-active");
    //去除离开隐藏绑定事件
    // Z(".fte-colorPicker").off("mouseleave",colorPickerHide);
    var colorSelect = new ColorSelect("");
    colorSelect.onSelect = function (color) {
        Z(".fte-colorPicker-eyedropper,.fte-colorPicker-dropperCover").removeClass("fte-active");
        //绑定离开隐藏绑定事件
        // Z(".fte-colorPicker").on("mouseleave",colorPickerHide);
        doColorPicker(color);
        inputBoxChanged();
    };
    var timer = setTimeout(function(){
        timer = null;
        colorSelect.execute();
    },10);
}

/** 参考图操作事件 **/
// 载入参考图
function loadImgReference(fileUrl)
{
    // 1：定位参考图
    var $wrap = Z.D.id('stage_reference');
    var $img = $wrap.querySelector('.img_reference');
    Z($img).attr('src', fileUrl);
    if (!$wrap.hasAttribute('style'))
    	Z($wrap).css('left',5);

    // 2：计算参考图大小
    var $stage = Z.D.id('stage_design');
    var maxWidth = $stage.offsetWidth * 3 / 5;
    var maxHeight = $stage.offsetHeight * 3/ 5;
    $img.onload = function()
    {
        var whRatio = $img.offsetWidth / $img.offsetHeight;
        var setWidth = maxWidth;
        var setHeight = setWidth / whRatio;
        if (setHeight > maxHeight){
            setHeight = maxHeight;
            setWidth = setHeight * whRatio;
        }
        Z($img).css({
            'width': setWidth,
            'height': setHeight,
        })
    }
}
// 删除参考图
function deleteImgReference() {
    Z('#stage_reference').removeAttr('style');
}
// 编辑（拖动、缩放）参考图
function editImgReferenceStart(event)
{
    // 拖动过程
    function editImgReferenceDoing(event)
    {
        Z.E.forbidden(event);
        doingMouseLoc = getMouseLocation(event);
        mx = doingMouseLoc.x - startMouseLoc.x;
        my = doingMouseLoc.y - startMouseLoc.y;
        editTheReference();
    }
    // 拖动结束
    function editImgReferenceDone(event)
    {
        Z.E.forbidden(event);
        // 解除事件
        Z(media.tool.$designStage).off('mousemove', editImgReferenceDoing);
        Z(media.tool.$designStage).off('mouseup mouseleave', editImgReferenceDone);
    }
    // 执行拖动
    function dragTheReference()
    {
        $stageReference.css({
            'left' : startStageLeft + mx,
            'top' : startStageTop + my,
        })
    }
    // 执行缩放
    function resizeTheReference()
    {
        switch (btnType)
        {
            case 'e':
                setWidth = startImgWidth + mx;
                break;
            case 'w':
                setWidth = startImgWidth - mx;
                setLeft = startStageLeft + mx;
                break;
            case 's':
                setHeight = startImgHeight + my;
                break;
            case 'n':
                setHeight = startImgHeight - my;
                setTop = startStageTop + my;
                break;
            case 'se':
                setWidth = startImgWidth + mx;
                setHeight = startImgHeight + my;
                break;
            case 'ne':
                setWidth = startImgWidth + mx;
                setHeight = startImgHeight - my;
                setTop = startStageTop + my;
                break;
            case 'sw':
                setWidth = startImgWidth - mx;
                setHeight = startImgHeight + my;
                setLeft = startStageLeft + mx;
                break;
            case 'nw':
                setWidth = startImgWidth - mx;
                setHeight = startImgHeight - my;
                setLeft = startStageLeft + mx;
                setTop = startStageTop + my;
                break;
        }
        $imgReference.css({
            'width' : setWidth,
            'height' : setHeight,
        });
        $stageReference.css({
            'left' : setLeft,
            'top' : setTop,
        })
    }

    // 1：主方法，定义变量
    Z.E.forbidden(event);
    var $target = Z.E.target(event);
    var $stageReference = Z('#stage_reference');
    var $wrapReference = $stageReference.find('.wrap_reference');
    var $imgReference = $wrapReference.find('img');
    var btnType = ($target === $wrapReference[0]) ? 'drag' : Z($target).attr('data-type');
    var editTheReference, doingMouseLoc, mx, my, editAll;

    // 2：存储操作前的数据
    var startMouseLoc = getMouseLocation(event);
    var startStageLeft = parseFloat($stageReference.css('left'));
    var startStageTop = parseFloat($stageReference.css('top'));
    var startImgWidth = parseFloat($imgReference.css('width'));
    var startImgHeight = parseFloat($imgReference.css('height'));
    var setLeft = startStageLeft;
    var setTop = startStageTop;
    var setWidth = startImgWidth;
    var setHeight = startImgHeight;

    // 判断类型
    if (btnType === 'drag')
        editTheReference = dragTheReference;
    else
        editTheReference = resizeTheReference;

    // 绑定事件
    Z(media.tool.$designStage).on('mousemove', editImgReferenceDoing);
    Z(media.tool.$designStage).on('mouseup mouseleave', editImgReferenceDone);
}
// 右键菜单
function referenceTextMenu()
{
    createContextMenu({
        "event": event,
        "elemId": "shapeContentMenu",
        "editItem": [
            ["置顶","Z('#stage_reference').addClass('zIndexMax')"],
            ["置底","Z('#stage_reference').removeClass('zIndexMax')"],
            ["删除","Z('#stage_reference').removeAttr('style')"],
        ],
    });
}

/********************************************
****************** 常用？算法 ****************
********************************************/
/** 遍历父节点，是否存在 class **/
function hasClassParent($node,className) {
    var $pNode = $node;
    if (className.charAt(0) === ".") {
        className = className.substring(1);
    }
    while ($pNode.tagName.toLowerCase() !== "body") {
        if (Z($pNode).hasClass(className)) {
            return true;
        }
        $pNode = $pNode.parentNode;
    }
    return false;
}
/** 查找最近的匹配的class的父节点 **/
function closetParentByClass($node,className){
    var $pNode = $node;
    if (className.charAt(0) === ".") {
        className = className.substring(1);
    }
    while ($pNode.tagName.toLowerCase() !== "body") {
        if (Z($pNode).hasClass(className)) {
            return $pNode;
        }
        $pNode = $pNode.parentNode;
    }
    return null;
}

/*** 去除字符串前后的空白行 ***/
function reBlankLine(str){
    if (Z.S.trim(str) === "")
        return str;
    str =  reBlankLinePre(str);
    str =  reBlankLineLast(str);
    return str;
}
/*** 去除字符串前的空白行 ***/
function reBlankLinePre(str){
    var newLineFirst = str.indexOf("\n");
    var preHtml = "";
    for (var i = 0;i < newLineFirst;i++){
        preHtml += str[i];
    }
    while (newLineFirst === 0 || (preHtml.length && !Z.S.trim(preHtml))) {
        str = str.substring(newLineFirst + 1);
        return reBlankLinePre(str);
    }
    return str;
}
/*** 去除字符串后的空白行 ***/
function reBlankLineLast(str) {
    var newLineLast = str.lastIndexOf("\n");
    var lastHtml = "";
    for (var i = newLineLast + 1;i < str.length;i++) {
        lastHtml += str[i];
    }
    while ((newLineLast === str.length - 1) || (lastHtml.length && !Z.S.trim(lastHtml))){
        str = str.substring(0, newLineLast);
        return reBlankLineLast(str);
    }
    return str;
}

/** 定位右键菜单 **/
function createContextMenu(itemsObj)
{
    if (!itemsObj){
        return Z.alert("方法 createContextMenu 的参数不存在！");
    }
    if (!itemsObj.elemId){
        return Z.alert("方法 createContextMenu 的 elemId 为空！");
    }
    if (!itemsObj.editItem && !itemsObj.showItem){
        return Z.alert("方法 createContextMenu的editItem 参数和 showItem 参数至少要存在一个！");
    }
    if(itemsObj.event) {
        Z.E.forbidden(itemsObj.event);
    }
    Z(".newContentmenu").hide();
    var $shapeMenu = Z.D.id(itemsObj.elemId);
    if (!!$shapeMenu)
        Z($shapeMenu).remove();

    var shapeMenu = '<div id="'+itemsObj.elemId+'" class="newContentmenu">';
    if (itemsObj.editItem)
    {
        shapeMenu += '<ul>';
        var i, j, $editUl, $firstItem, $firstInside;
        for (i = 0;i < itemsObj.editItem.length;i++)
        {
            $editUl = itemsObj.editItem[i];
            $firstItem = $editUl[0];
            // 分割线
            if(!$firstItem) {
                shapeMenu += '</ul><ul>';
            }
            // 单个按钮
            else if (Z.T.isString($firstItem)) {
                shapeMenu += '<li data-fun="'+ $editUl[1] +'">'+$editUl[0]+'</li>';
            }
            // 折叠列表
            else if (typeof $firstItem === "object")
            {
                shapeMenu += '<li class="newContentMenu-more">'+ $firstItem[0] +'<i></i><ul>';
                for (j = 1;j < $editUl.length;j++)
                {
                    $firstInside = $editUl[j];
                    if (!$firstInside[0])
                        shapeMenu += '</ul><ul>';
                    else
                        shapeMenu += '<li data-fun="'+ $firstInside[1] +'">' + $firstInside[0] + '</li>';
                }
                shapeMenu += '</ul></li>';
            }
        }
        shapeMenu += '</ul>';
    }
    shapeMenu += '</ul>';
    if (itemsObj.showItem)
    {
        shapeMenu += '<ul>';
        for (i = 0;i < itemsObj.showItem.length;i++){
            shapeMenu += '<li>'+itemsObj.showItem[i]+'</li>';
        }
        shapeMenu += '</ul>';
    }
    shapeMenu += '</div>';
    Z.D.id("sidebar").insertAdjacentHTML("beforeend",shapeMenu);

    /** 菜单列表事件 **/
    $shapeMenu = Z.D.id(itemsObj.elemId);
    Z($shapeMenu).on("contextmenu mousedown click",Z.E.forbidden);
    var itemArr = [];
    itemsObj.editItem.map(function($item){
        if ($item.length > 0) itemArr.push($item);
    });
    // 事件绑定
    Z($shapeMenu).find("li[data-fun]").each(function(item)
    {
        var fun = item.getAttribute('data-fun');
        if (!fun)
            return;
        item.removeAttribute('data-fun');
        if (fun.indexOf("(") > -1)
            item.setAttribute("onclick",fun);
        else
            Z(item).on("click",eval(fun));
        Z(item).on("click",function(){Z($shapeMenu).hide();});
    });
    Z($shapeMenu).css("left",itemsObj.event.pageX).css("top",itemsObj.event.pageY).show();
}

/*** 获取鼠标位置信息 ***/
function getMouseLocation (e)
{//获取鼠标位置
    var mouseLocation = {};
    mouseLocation.x = Z.E.clientX(e);
    mouseLocation.y = Z.E.clientY(e);
    return mouseLocation;
}
/*** 计算鼠标位移，相对旋转对象的真实变化 ***/
function getElementTrueEX(nowMouseLoc, startX, starY, angle)
{
    var data = {x:0, y:0};
    var mx = nowMouseLoc.x - startX;
    var my = nowMouseLoc.y - starY;
    if (mx === 0 && my === 0) {
        return data;
    }
    var mouseAngle;
    var l = Math.sqrt(Math.pow(mx, 2) + Math.pow(my, 2));
    var absAngle = Math.atan(Math.abs(my) / Math.abs(mx));
    var rectAngle = 90 * Math.PI / 180;
    if (mx > 0 && my === 0){           //x正轴
        mouseAngle = 0;
    } else if (mx > 0 && my > 0){    //第一象限
        mouseAngle = absAngle;
    } else if (mx === 0 && my > 0){   //y正轴
        mouseAngle = rectAngle;
    } else if (mx < 0 && my > 0){    //第二象限
        mouseAngle = 2 * rectAngle - absAngle;
    } else if (mx < 0 && my === 0){   //x负轴
        mouseAngle = 2 * rectAngle;
    } else if (mx < 0 && my < 0){    //第三象限
        mouseAngle = 2 * rectAngle + absAngle;
    } else if (mx === 0 && my < 0){   //y负轴
        mouseAngle = 3 * rectAngle;
    } else if (mx > 0 && my < 0){    //第四象限
        mouseAngle = 4 * rectAngle - absAngle;
    }
    var dataAngle = angle * Math.PI/180;
    data.x = l * Math.cos(mouseAngle - dataAngle);
    data.y = l * Math.sin(mouseAngle - dataAngle);

    return data;
}

/*** 获取数组中最大值 ***/
function getMaxNum(numArray){
    return Math.max.apply(Math, numArray);
}
/*** 获取数组中最小值 ***/
function getMinNum(numArray){
    return Math.min.apply(Math, numArray);
}
/*** 颜色格式转换 ***/
function rgb2hex(value)
{
    if (/rgba?/.test(value.toLowerCase())) {
        var array = value.split(",");
        if (array.length > 3)
            return "";
        value = "#";
        for (var i = 0, color; color = array[i++];)
        {
            color = parseInt(color.replace(/[^\d]/gi, ""), 10).toString(16);
            value += color.length === 1 ? "0" + color : color;
        }
    }
    return  value.toLowerCase();
}
function hexToRgb(hex_string, default_)
{//颜色格式转换：16进制转换rgb
    if (default_ === undefined){
        default_ = null;
    }

    if (hex_string.substr(0, 1) === '#'){
        hex_string = hex_string.substr(1);
    }
    
    var r;
    var g;
    var b;
    if (hex_string.length === 3){
        r = hex_string.substr(0, 1);
        r += r;
        g = hex_string.substr(1, 1);
        g += g;
        b = hex_string.substr(2, 1);
        b += b;
    } else if (hex_string.length === 6) {
        r = hex_string.substr(0, 2);
        g = hex_string.substr(2, 2);
        b = hex_string.substr(4, 2);
    } else {
        return default_;
    }
    
    r = parseInt(r, 16);
    g = parseInt(g, 16);
    b = parseInt(b, 16);
    if (isNaN(r) || isNaN(g) || isNaN(b)) {
        return default_;
    } else {
        return {r: r / 255, g: g / 255, b: b / 255};
    }
}
function rgbToHex(r, g, b, includeHash)
{//颜色格式转换：rgb转换16进制
    r = Math.round(r * 255);
    g = Math.round(g * 255);
    b = Math.round(b * 255);
    if (includeHash === undefined) {
        includeHash = true;
    }
    
    r = r.toString(16);
    if (r.length === 1){
        r = '0' + r;
    }
    g = g.toString(16);
    if (g.length === 1){
        g = '0' + g;
    }
    b = b.toString(16);
    if (b.length === 1){
        b = '0' + b;
    }
    return ((includeHash ? '#' : '') + r + g + b).toLowerCase();
}
function hsvToRgb(hue, saturation, value)
{//HSV颜色模型转rgb
    var red;
    var green;
    var blue;
    if (value == 0.0) {
        red = 0;
        green = 0;
        blue = 0;
    } else {
        var i = Math.floor(hue * 6);
        var f = (hue * 6) - i;
        var p = value * (1 - saturation);
        var q = value * (1 - (saturation * f));
        var t = value * (1 - (saturation * (1 - f)));
        switch (i) {
            case 1: red = q; green = value; blue = p; break;
            case 2: red = p; green = value; blue = t; break;
            case 3: red = p; green = q; blue = value; break;
            case 4: red = t; green = p; blue = value; break;
            case 5: red = value; green = p; blue = q; break;
            case 6: // fall through
            case 0: red = value; green = t; blue = p; break;
        }
    }
    return {r: red, g: green, b: blue};
}
function rgbToHsv(red, green, blue)
{//rgb转换为hsv颜色模式
    var max = Math.max(Math.max(red, green), blue);
    var min = Math.min(Math.min(red, green), blue);
    var hue;
    var saturation;
    var value = max;
    if (min === max) {
        hue = 0;
        saturation = 0;
    } else {
        var delta = (max - min);
        saturation = delta / max;
        if (red == max) {
            hue = (green - blue) / delta;
        } else if (green == max) {
            hue = 2 + ((blue - red) / delta);
        } else {
            hue = 4 + ((red - green) / delta);
        }
        hue /= 6;
        if (hue < 0) {
            hue += 1;
        }
        if (hue > 1) {
            hue -= 1;
        }
    }
    return {
        h: hue,
        s: saturation,
        v: value
    };
}
// hex 转化为 cmyk
function hex2cmyk (hex, normalized){
    var rgb = hexToRgb(hex);

    var c = 1 - rgb.r;
    var m = 1 - rgb.g;
    var y = 1 - rgb.b;
    var k = Math.min(c, Math.min(m, y));

    c = (c - k) / (1 - k);
    m = (m - k) / (1 - k);
    y = (y - k) / (1 - k);

    if(!normalized){
        c = Math.round(c * 10000) / 100;
        m = Math.round(m * 10000) / 100;
        y = Math.round(y * 10000) / 100;
        k = Math.round(k * 10000) / 100;
    }

    c = isNaN(c) ? 0 : c;
    m = isNaN(m) ? 0 : m;
    y = isNaN(y) ? 0 : y;
    k = isNaN(k) ? 0 : k;

    return {
        c: c,
        m: m,
        y: y,
        k: k
    }
}
// cmyk 转化为 hex
function cmyk2hex (c, m, y, k){
    c = (c / 100);
    m = (m / 100);
    y = (y / 100);
    k = (k / 100);

    c = c * (1 - k) + k;
    m = m * (1 - k) + k;
    y = y * (1 - k) + k;

    var r = 1 - c;
    var g = 1 - m;
    var b = 1 - y;

    r = Math.round(255 * r);
    g = Math.round(255 * g);
    b = Math.round(255 * b);

    r = r > 0 ? r : 0;
    g = g > 0 ? g : 0;
    b = b > 0 ? b : 0;
    return rgb2hex('rgb('+ r + ',' + g + ',' + b + ')');
}

/*** 设置字体大小/类型，不触发change ***/
// 获取 midArr、bidArr
function setIdArr(idObjArr)
{
    midArr.length = 0;
    bidArr.length = 0;
    if (!idObjArr){
        midArr = Z.clone(media.selectedList);
        bidArr.length = midArr.length + 1;
        bidArr = bidArr.join(media.curPage + ',').split(',');
        bidArr.pop();
        bidArr = bidArr.map(parseFloat);
        return;
    }
    var objLength = idObjArr.length;
    var idObj, i;
    for (i = 0;i < objLength;i++) {
        idObj = idObjArr[i];
        midArr.push(parseInt(idObj.mid));
        bidArr.push(parseInt(idObj.bid));
    }
}
// 依素材封装 idObjArr
function getIdObjArrFromMaterial()
{
    var materials = (arguments.length === 1 ? [arguments[0]] : Array.apply(null, arguments));
    var idObjArr = [];
    var listLength = materials.length;
    var i = 0, material;
    for (i;i < listLength;i++) {
        material = materials[i];
        idObjArr.push({
            'mid': material.mid,
            'bid': material.bid
        });
    }
    return idObjArr;
}

/*** 设置字体大小/类型，不触发change ***/
function setFontSelectVal(value, wrapId)
{
    var $wrap = wrapId.charAt(0) === '#' ? Z(wrapId) : Z('#' + wrapId);
    var isFamily = /fontFamily$/.test(wrapId);
    value = (value + "").replace(/'|"/g,"");
    if (!isFamily) value = Math.round(value);

    // 辅助输入框
    var $input = $wrap.find('.fontSet_inputWrap > .z-input');
    $input.val(isFamily ? "" : value);
    $input.attr("placeholder", subStr(value, 14));

    // 取得下拉列表 dropDown
    var $dropDown = $wrap.find(".z-dropdown");
    var $default = $dropDown.children(".z-default");
    var $list = $dropDown.children(".z-list>span");
    var $$span = $dropDown.find(".z-list > span");
    var $selectedSpan = $dropDown.find('.z-list > span.z-selected');
    var $shouldSpan = $dropDown.find('.z-list > span[value="' + value + '"]');
    if (isFamily) {
        $default.attr("value", value).text(value);
    } else {
        value = parseFloat(value);
        if (Math.round(value) !== value)
            value = 0;
        $wrap.find('select').val(value);
    }

    // 赋值 dropDown
    $default.html(value);
    $default.attr("value",value);
    $list.removeAttr("selected");
    $selectedSpan.removeClass('z-selected');
    $shouldSpan.addClass('z-selected');
}

/*** 实现网络图片上传，再插入画布 ***/
function uploadFileRequest(source, mid, isLocal)
{//
    var className = !!isLocal?("saveLocalImage"):("downloadImage");
    var ajax = new Z.Ajax();
    ajax.setClassName("MediaPresenter");
    ajax.setMethodName(className);
    ajax.addParam(source);
    ajax.addParam(media.canvas.mediaId);
    ajax.setCallback(function()
    {
        if (this.responseStatus == 701 || this.responseStatus == 703){
            media.tool.ajaxLoadedLength--;
            Z.alert(this.responseText, function(){ajaxLoadedDone();});
            return;
        }
        var obj = Z.J.toObject(this.responseText);
        newImage({fileId:obj.fileId, source: obj.fileUrl ,mid: mid}, true, function(material, svgElement){
            updateMaterialSource(material, svgElement);
            material.doMutliSelected();
            ajaxLoadedDone();
        });
    });
    ajax.execute();
}

/** 获取素材的位置信息*/
function getXY($curElem)
{
    $curElem = $curElem || media.tool.tempElement || media.tool.getCurSvgElement();
    var x = $curElem.transform.baseVal[0].matrix.e;
    var y = $curElem.transform.baseVal[0].matrix.f;
    x = parseFloat(x.toFixed(4));
    y = parseFloat(y.toFixed(4));
    
    if(media.canvas.createMode == 0)
    {//毫米
        x = px2mm(x, media.canvas.dpi);
        y = px2mm(y, media.canvas.dpi);
    }
    
    return [x,y];
}

/** 获取素材的大小信息*/
function getWH($curElem)
{
    $curElem = $curElem || media.tool.tempElement || media.tool.getCurSvgElement();
    var $gWrap = $curElem.querySelector('g');
    var $svg = [...$gWrap.children].pop();
    var width = $svg.getAttribute("width");
    var height = $svg.getAttribute("height");
    if(media.canvas.createMode === 0)
    {//像素转毫米
        width = px2mm(width, media.canvas.dpi);
        height = px2mm(height, media.canvas.dpi);
    }
    return [width,height];
}
// 定时器判断是否已加载完成，完成后保存刷新
function ajaxLoadedDone()
{
    var sl = media.tool.ajaxLoadedLength;
    var nl = media.getBgMaterialList(media.curPage).length;
    if (sl === nl)
    {//所有数据已载入，进行保存
        selectTheElement_group();
        saveHistory();
        setTimeout(function(){Z.Dialog.close()},500);
    }
}
// 毫米转像素
function mm2px(m, dpi, radio)
{
    if(isNaN(m))
        return 0;

    dpi = dpi || media.canvas.dpi;
    var ret = parseFloat(m*dpi*10/254);
    if(radio === undefined || radio <= 0)
        radio = 4;
    radio = Math.pow(10,radio);
    return Math.floor(ret*radio)/radio;
}
// 像素转毫米
function px2mm(p, dpi, radio)
{
    if(isNaN(p))
        return 0;

    dpi = dpi || media.canvas.dpi;
    var ret = parseFloat(p*254/(dpi*10));
    if(radio === undefined || radio <= 0)
        radio = 4;
    radio = Math.pow(10,radio);
    return Math.floor(ret*radio)/radio;
}
// 像素转磅
function px2pt(px, radio)
{
    if(isNaN(px))
        return 0;
    radio = radio || 2;
    var ret = parseFloat(px*72 / media.canvas.dpi);
    
    radio = Math.pow(10,radio);
    return Math.floor(ret*radio)/radio;
}
// 磅转像素
function pt2px(pt, radio)
{
    if(isNaN(pt))
        return 0;
    radio = radio || 2;
    var ret = parseFloat(pt * media.canvas.dpi / 72);
    
    radio = Math.pow(10,radio);
    return Math.floor(ret*radio)/radio;
}

/*** 判断当前激活标签是否是可编辑节点 ***/
// 是否当前焦点对象是输入类型
function isActiveInput ()
{
    var activeEle = document.activeElement;
    if (activeEle.hasAttribute("contenteditable")){
        if (activeEle.getAttribute("contenteditable") === "true") {
            return true;
        }
    }
    if (activeEle.tagName.toLowerCase() === "textarea"){
            return true;
    }
    if (activeEle.tagName.toLowerCase() === "input"){
        if (Z.AR.contains(["text", "email", "url", "number", "search"], activeEle.type)){
            return true;
        }
        return false;
    }
    return false;
}

/*** 素材的显示和隐藏 ***/
// 隐藏正常素材
function hideHiddenElement($curElem)
{
    var className = $curElem.getAttribute("class") || "";
    className = (className + " hiddenDoing").trim();
    className = className.replace(/\s\s/g," ");
    $curElem.setAttribute("class", className);
}
// 显示正常素材
function showHiddenElement($curElem)
{
    var className = $curElem.getAttribute("class") || "";
    className = (className.replace(/hiddenDoing/g, "")).trim();
    className = className.replace(/\s\s/g," ");
    $curElem.setAttribute("class", className);
}

/*** 选区相关计算，文字编辑 ***/
// 隐藏文本编辑器
function hideTextEditor()
{
    // 移除“不可编辑”样式
    Z("#textEditorWrap").removeClass('z-event-none');
    // 隐藏富文本容器
    Z("#textEditorWrap,#textEditorInner,#textEditor").removeAttr("style");
}
// 显示正常素材--文字素材
function showTextElement($curElem)
{
    hideTextEditor();
    showHiddenElement($curElem)
}
// 设置选区的相关参数
function setSlIndex(material)
{
    //设置字符串内容
    var sl = window.getSelection();
    var slText = sl + "";
    var lineStart = media.tool.tempSelLineStart;
    //设置行属性
    var startLine = getTitemLineIndex(sl.anchorNode);
    var endLine = getTitemLineIndex(sl.focusNode);
    if (startLine < endLine) {
        lineStart = {"lineIndex": startLine,"wordIndex": getDataInLine(sl.anchorNode,sl.anchorOffset).index}
    } else if (startLine > endLine){
        lineStart = {"lineIndex": endLine,"wordIndex": getDataInLine(sl.focusNode,sl.focusOffset).index}
    } else if (startLine === endLine){
        lineStart.lineIndex = startLine;
        if (sl.anchorOffset < sl.focusOffset) {
            lineStart.wordIndex = getDataInLine(sl.anchorNode,sl.anchorOffset).index;
        } else {
            lineStart.wordIndex = getDataInLine(sl.focusNode,sl.focusOffset).index;
        }
    }
    //设置字索引
    media.tool.tempSelStart = getTextStartIndex(material);
    media.tool.tempSelEnd = getTextEndIndex(material);
}
// 获取行内索引值
function getDataInLine(node, index)
{
    var pNode = node;
    while (pNode.nodeName.toLowerCase() !== "titem") {
        pNode = pNode.parentNode;
        var children = pNode.childNodes;
        for (var i = 0;i < children.length;i++) {
            if (node === children[i]) {
                node = pNode;
                break;
            }
            index += children[i].textContent.length;
        }
    }
    return {"node":node,"index":index}
}
// 获取“起始位置”在字符串中的索引，（索引值较小的）
function getTextStartIndex(material)
{
    var lineStart = media.tool.tempSelLineStart;
    var textArr = material.text.split("\n");
    var num = 0;
    //前面行的文字总数
    for (var i = 0;i < textArr.length;i++) {
        if (i < lineStart.lineIndex) {
            num += textArr[i].length;
        }
    }
    return num + lineStart.wordIndex;
}
// 获取“结束位置”在字符串中的索引，（索引值较大的）
function getTextEndIndex(material)
{
    var sl = window.getSelection();
    var slText = sl + "";
    var textArr = slText.split("\n");
    var num = media.tool.tempSelStart;
    //前面行的文字总数
    for (var i = 0;i < textArr.length;i++) {
        num += textArr[i].length;
    }
    return num;
}
// 获取节点所在第几行
function getTitemLineIndex(node)
{
    while (node.nodeName.toLowerCase() !== "titem") {
        node = node.parentNode;
    }
    var pNode = node.parentNode;
    var children = pNode.querySelectorAll("titem");
    for (var i = 0;i < children.length;i++) {
        if (children[i] === node) {
            return i;
        }
    }
}

/** 获取字符串长度，中文算2个字符，英文1个 **/
function getLength(str)
{
    var realLength = 0,len = str.length,charCode = -1;  
    for(var i=0;i<len;i++)
    {  
        charCode = str.charCodeAt(i);  
        if(charCode > 0 && charCode <= 128) 
            realLength +=1;    
        else 
            realLength += 2;    
    }  
    
    return realLength;   
}

/** 获取字符串长度，包含中英文字符，中文字符算俩个，英文字符算一个 **/
function subStr(str, len, suffix)
{
    //var suffix = suffix || "..."
    if(!str)
        return "";
        
    if (typeof(suffix) === "undefined")
        suffix = "...";
        
    var char_length = 0;  
    for (var i = 0; i < str.length; i++)
    {  
        var son_str = str.charCodeAt(i);  
        (son_str>0 && son_str<=128)? char_length += 1: char_length += 2;  
        if (char_length >= len)
        {  
            return str.substr(0, i+1) + suffix;
        }  
    }
    
    return str;
}

/** 转换空格符 为 &nbsp; 的文本方式 **/
function getHtmlText (text)
{
    var randId = Z.Ids.uuid();
    var htmlDiv = '<div id="'+randId+'">';
    // 遍历每个文字
    var i, word;
    for (i = 0;i < text.length;i++) {
        word = text[i];
        if (word.match(/\n/)){
            word = "<br>";
        } else if (word === " ") {
            word = "&nbsp;"
        }
        htmlDiv += word;
    }
    htmlDiv += "</div>";
    document.body.insertAdjacentHTML("beforeend",htmlDiv);
    
    var $div = Z.D.id(randId);
    var newText = $div.innerText;
    Z($div).remove();
    return newText;
}

/** 去除字符串的多空格结尾，仅保留一个空格 **/
function cutDoubleSpaceEnd (str)
{
    while(/\s\s$/.test(str)){
        str = str.substring(0, str.length -1);
    }
    return str;
}

/**  文字字符属性列表，格式化 **/
function formatWordsList(wordsList)
{
    var list = [];
    var l = wordsList && wordsList.length || 0;
    var i, item, word;
    for (i = 0;i < l;i++)
    {
        item = {};
        word = wordsList[i];
        item.fontWeight = word.fontWeight;
        item.fontFamily = word.fontFamily;
        list.push(item);
    }
    return list.length > 0 ? Z.J.toString(list) : "";
}

/**  查找指定的父级 **/
function getClosestParent ($node, target, limit)
{
    limit = limit || "body";
    while ($node.tagName.toLowerCase() !== limit.toLowerCase()) {
        if ($node.tagName.toLowerCase() === target.toLowerCase()) {
            return $node;
        }
        $node = $node.parentNode;
    }
    return null;
}

/** 获取当前浏览器DPI **/
function getScreenDPI()
{
    var arrDPI = new Array();
    var tmpNode = document.createElement("DIV");
    tmpNode.style.cssText = "width:1in;height:1in;position:absolute;left:0px;top:0px;z-index:99;visibility:hidden";
    document.body.appendChild(tmpNode);
    arrDPI[0] = parseInt(tmpNode.offsetWidth);
    arrDPI[1] = parseInt(tmpNode.offsetHeight);
    tmpNode.parentNode.removeChild(tmpNode);
    return arrDPI;
}
