/*
 * Decompiled with CFR 0.152.
 */
package com.zhiqim.media.service.util;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.stream.ImageInputStream;
import org.apache.sanselan.ImageInfo;
import org.apache.sanselan.Sanselan;
import org.apache.xmlgraphics.image.loader.ImageException;
import org.apache.xmlgraphics.image.loader.util.ImageUtil;
import org.zhiqim.kernel.util.Bytes;
import org.zhiqim.kernel.util.Files;

public class SanselanUtil {
    public static void checkImageInfo(String filePath) throws Exception {
        byte[] bytes = Files.read((String)filePath);
        SanselanUtil.checkImageInfo(bytes);
    }

    public static void checkImageInfo(byte[] bytes) throws Exception {
        ImageInfo info = null;
        if (!Bytes.isPNG((byte[])bytes) && !Bytes.isJPG((byte[])bytes)) {
            throw new Exception("\u4ec5\u652f\u6301png\u3001jpg\u683c\u5f0f\u7684\u56fe\u7247");
        }
        try {
            info = Sanselan.getImageInfo((byte[])bytes);
        }
        catch (Exception e) {
            throw new Exception("\u8bfb\u53d6\u56fe\u7247\u5f02\u5e38\uff1a" + e.getMessage());
        }
        if (info.getWidth() > 1920 || info.getHeight() > 1920) {
            throw new Exception("\u56fe\u7247\u6700\u5927\u652f\u63011920x1920\u50cf\u7d20\u7684");
        }
        int widthDpi = info.getPhysicalHeightDpi();
        int heightDpi = info.getPhysicalHeightDpi();
        if (!(heightDpi < 0 || SanselanUtil.checkDpi(widthDpi) && SanselanUtil.checkDpi(heightDpi))) {
            throw new Exception("\u4ec5\u652f\u6301\u5206\u8fa8\u7387\u572872-600dpi\u4e4b\u95f4\u7684\u56fe\u7247");
        }
        if ("CMYK".equalsIgnoreCase(info.getColorTypeDescription())) {
            throw new Exception("\u4e0d\u652f\u6301CMYK\u6a21\u5f0f\u7684\u56fe\u7247");
        }
        if ("PNG".equalsIgnoreCase(info.getFormat().name)) {
            try {
                Sanselan.getBufferedImage((byte[])bytes);
            }
            catch (Exception exception) {
                throw new Exception("\u8bfb\u53d6\u56fe\u7247\u5f02\u5e38\uff0c\u8bf7\u5728ps\u4e2d\u5c06\u56fe\u7247\u53e6\u5b58\u4e3aWeb\u548c\u8bbe\u5907\u4f7f\u7528\u683c\u5f0f");
            }
            try {
                SanselanUtil.checkPng(bytes);
            }
            catch (Exception exception) {
                throw new Exception("\u8bfb\u53d6\u56fe\u7247\u5f02\u5e38\uff0c\u8bf7\u5728ps\u4e2d\u5904\u7406");
            }
        }
    }

    private static boolean checkDpi(int dpi) {
        return dpi <= 600 && dpi >= 72;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void checkPng(byte[] bytes) throws Exception {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try {
                ImageInputStream in;
                BufferedInputStream source = new BufferedInputStream(new ByteArrayInputStream(bytes));
                try {
                    Iterator<ImageReader> iter;
                    block25: {
                        block26: {
                            in = ImageIO.createImageInputStream(source);
                            iter = ImageIO.getImageReaders(in);
                            if (iter.hasNext()) break block25;
                            if (in == null) break block26;
                            in.close();
                        }
                        if (source == null) return;
                        source.close();
                        return;
                    }
                    Throwable firstIOException = null;
                    IIOMetadata iiometa = null;
                    while (iter.hasNext()) {
                        in.mark();
                        ImageReader reader = iter.next();
                        try {
                            reader.setInput(ImageUtil.ignoreFlushing((ImageInputStream)in), true, false);
                            iiometa = reader.getImageMetadata(0);
                            break;
                        }
                        catch (IOException ioe) {
                            if (firstIOException != null) continue;
                            firstIOException = ioe;
                        }
                        finally {
                            reader.dispose();
                            in.reset();
                        }
                    }
                    if (iiometa == null) {
                        String string;
                        if (firstIOException == null) {
                            throw new ImageException("Could not extract image metadata");
                        }
                        StringBuilder stringBuilder = new StringBuilder("I/O error while extracting image metadata");
                        if (firstIOException.getMessage() != null) {
                            string = ": " + firstIOException.getMessage();
                            throw new ImageException(stringBuilder.append(string).toString(), firstIOException);
                        }
                        string = "";
                        throw new ImageException(stringBuilder.append(string).toString(), firstIOException);
                    }
                    break block27;
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                    } else if (throwable != throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    if (source == null) throw throwable;
                    source.close();
                    throw throwable;
                }
                {
                    block27: {
                        finally {
                            if (in != null) {
                                in.close();
                            }
                        }
                    }
                    if (source == null) return;
                }
                source.close();
                return;
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                    throw throwable;
                }
                if (throwable == throwable4) throw throwable;
                throwable.addSuppressed(throwable4);
                throw throwable;
            }
        }
        catch (Exception e) {
            throw new Exception("\u56fe\u7247\u5f02\u5e38", e);
        }
    }

    public static void main(String[] args) throws Exception {
        File file1 = new File("D:\\hehe.jpg");
        File file2 = new File("D:\\CMYK3.png");
        System.out.println("------1-------");
        ImageInfo info1 = Sanselan.getImageInfo((File)file1);
        System.out.println(info1);
        System.out.println(info1.getColorTypeDescription());
        System.out.println("------2-------");
        ImageInfo info2 = Sanselan.getImageInfo((File)file2);
        System.out.println(info2);
        System.out.println(info2.getColorTypeDescription());
        SanselanUtil.checkImageInfo("D:\\CMYK3.png");
    }
}

