/*
 * Decompiled with CFR 0.152.
 */
package com.zhiqim.media.service.util;

import com.itextpdf.text.Document;
import com.itextpdf.text.Element;
import com.itextpdf.text.Image;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.PdfCopy;
import com.itextpdf.text.pdf.PdfDictionary;
import com.itextpdf.text.pdf.PdfImportedPage;
import com.itextpdf.text.pdf.PdfName;
import com.itextpdf.text.pdf.PdfNumber;
import com.itextpdf.text.pdf.PdfObject;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.PdfSmartCopy;
import com.itextpdf.text.pdf.PdfWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.zhiqim.kernel.logging.Log;
import org.zhiqim.kernel.logging.LogFactory;
import org.zhiqim.kernel.util.Validates;

public class ItextPdfUtil {
    private static final Log log = LogFactory.getLog(ItextPdfUtil.class);

    public static void megerPdf(List<String> pdfList, String savePath) {
        if (Validates.isEmpty(pdfList) || pdfList.size() == 0) {
            return;
        }
        try (PdfReader reader = null;){
            try {
                Document document = new Document(new PdfReader(pdfList.get(0)).getPageSize(1));
                PdfCopy copy = new PdfCopy(document, (OutputStream)new FileOutputStream(savePath));
                document.open();
                int i = 0;
                while (i < pdfList.size()) {
                    reader = new PdfReader(pdfList.get(i));
                    int n = reader.getNumberOfPages();
                    int j = 1;
                    while (j <= n) {
                        document.newPage();
                        PdfImportedPage page = copy.getImportedPage(reader, j);
                        copy.addPage(page);
                        ++j;
                    }
                    ++i;
                }
                document.close();
            }
            catch (Exception e) {
                log.error((Object)"pdf\u5408\u6210\u5931\u8d25", (Throwable)e, new Object[0]);
                if (reader != null) {
                    reader.close();
                }
            }
        }
    }

    public static void rotatePdf(String srcPdf, String destPdf, float degrees) throws Exception {
        PdfReader reader = new PdfReader(srcPdf);
        Document document = new Document();
        PdfSmartCopy p = new PdfSmartCopy(document, (OutputStream)new FileOutputStream(destPdf));
        document.open();
        int n = reader.getNumberOfPages();
        int j = 1;
        while (j <= n) {
            PdfDictionary pd = reader.getPageN(j);
            pd.put(PdfName.ROTATE, (PdfObject)new PdfNumber(degrees));
            ++j;
        }
        int page = 0;
        while (page < n) {
            p.addPage(p.getImportedPage(reader, ++page));
        }
        document.close();
    }

    public static void image2Pdf(List<String> imageList, String target) {
        Document document = new Document();
        document.setMargins(0.0f, 0.0f, 0.0f, 0.0f);
        FileOutputStream fos = null;
        try {
            try {
                fos = new FileOutputStream(target);
                PdfWriter.getInstance((Document)document, (OutputStream)fos);
                document.open();
                for (String imagePath : imageList) {
                    Image image = Image.getInstance((String)imagePath);
                    float imageHeight = image.getScaledHeight();
                    float imageWidth = image.getScaledWidth();
                    Rectangle rectangle = new Rectangle(imageWidth, imageHeight);
                    document.setPageSize(rectangle);
                    image.setAlignment(1);
                    document.newPage();
                    document.add((Element)image);
                }
            }
            catch (Exception ioe) {
                System.out.println(ioe.getMessage());
                document.close();
                try {
                    fos.flush();
                    fos.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        finally {
            document.close();
            try {
                fos.flush();
                fos.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void main(String[] args) throws Exception {
        ArrayList<String> imageList = new ArrayList<String>();
        imageList.add("D:\\1.jpg");
        imageList.add("D:\\2.jpg");
        ItextPdfUtil.image2Pdf(imageList, "D:\\test.pdf");
    }
}

