/*
 * Decompiled with CFR 0.152.
 */
package com.zhiqim.media.service.util;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import org.zhiqim.kernel.util.Files;

public class ImagesUtil {
    public static void main(String[] args) throws Exception {
        ImagesUtil.resizeImage("D:/_yangcai/images/rgb_image.jpg", "D:/_temp/2_0.jpg");
    }

    public static BufferedImage drawTransparentImage(int width, int height) {
        BufferedImage image = new BufferedImage(width, height, 1);
        Graphics2D g2d = image.createGraphics();
        image = g2d.getDeviceConfiguration().createCompatibleImage(width, height, 3);
        g2d.dispose();
        g2d = image.createGraphics();
        g2d.setColor(new Color(255, 0, 0));
        g2d.setStroke(new BasicStroke(1.0f));
        g2d.dispose();
        return image;
    }

    public static BufferedImage drawTransparentTextImage(int width, int height, String text, String fontFamily, int fontSize, String color) {
        if (width == 0 || height == 0) {
            BufferedImage buffImage = new BufferedImage(100, 100, 1);
            Graphics2D graphics = buffImage.createGraphics();
            FontMetrics fontMetrics = graphics.getFontMetrics(new Font("\u6c49\u4eea\u83f1\u5fc3\u4f53\u7b80", 0, 25));
            width = fontMetrics.stringWidth(text) == 0 ? fontSize : fontMetrics.stringWidth(text);
            height = fontMetrics.getHeight() + 4;
        }
        BufferedImage image = new BufferedImage(width, height, 1);
        Graphics2D gd = image.createGraphics();
        image = gd.getDeviceConfiguration().createCompatibleImage(width, height, 3);
        gd.dispose();
        gd = image.createGraphics();
        gd.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        gd.setFont(new Font(fontFamily, 0, fontSize));
        gd.setColor(ImagesUtil.string2Color(color));
        gd.drawString(text, 0, fontSize);
        return image;
    }

    public static Color string2Color(String str) {
        int i = Integer.parseInt(str.substring(1), 16);
        return new Color(i);
    }

    public static boolean resizeImage(String imgSrc, String imgDest) throws Exception {
        BufferedImage buffImg = ImagesUtil.readImage(imgSrc);
        int srcWidth = buffImg.getWidth(null);
        int srcHeight = buffImg.getHeight(null);
        int destWidth = srcWidth;
        int destHeight = srcHeight;
        if (srcWidth > 1500) {
            double scale = 1500.0 / (double)srcWidth;
            destWidth = (int)(scale * (double)srcWidth);
            destHeight = (int)(scale * (double)srcHeight);
        }
        String suffix = Files.getFileExt((String)imgSrc);
        BufferedImage result = null;
        result = "png".equals(suffix) ? new BufferedImage(destWidth, destHeight, 2) : new BufferedImage(destWidth, destHeight, 1);
        result.getGraphics().drawImage(buffImg.getScaledInstance(destWidth, destHeight, 4), 0, 0, null);
        return ImageIO.write((RenderedImage)result, suffix, new File(imgDest));
    }

    public static BufferedImage readImage(String imgPath) throws Exception {
        File file = new File(imgPath);
        ImageInputStream in = ImageIO.createImageInputStream(file);
        Iterator<ImageReader> readers = ImageIO.getImageReaders(in);
        if (readers == null || !readers.hasNext()) {
            throw new Exception("\u56fe\u7247\u4e0d\u53ef\u8bfb\u53d6!");
        }
        ImageReader reader = readers.next();
        reader.setInput(in, true);
        String format = reader.getFormatName();
        BufferedImage image = null;
        if ("JPEG".equalsIgnoreCase(format) || "JPG".equalsIgnoreCase(format)) {
            try {
                image = reader.read(0);
            }
            catch (IOException iOException) {
                Raster raster = reader.readRaster(0, null);
                image = ImagesUtil.createJPEG4(raster);
            }
            image.getGraphics().drawImage(image, 0, 0, null);
        }
        return image;
    }

    private static BufferedImage createJPEG4(Raster raster) {
        int w = raster.getWidth();
        int h = raster.getHeight();
        byte[] rgb = new byte[w * h * 3];
        float[] Y = raster.getSamples(0, 0, w, h, 0, (float[])null);
        float[] Cb = raster.getSamples(0, 0, w, h, 1, (float[])null);
        float[] Cr = raster.getSamples(0, 0, w, h, 2, (float[])null);
        int i = 0;
        int imax = Y.length;
        int base = 0;
        while (i < imax) {
            float y = 255.0f - Y[i];
            float cb = 255.0f - Cb[i];
            float cr = 255.0f - Cr[i];
            double val = (double)y + 1.402 * (double)(cr - 128.0f);
            rgb[base] = (byte)(val < 0.0 ? 0 : (byte)(val > 255.0 ? -1 : (byte)(val + 0.5)));
            val = (double)y - 0.34414 * (double)(cb - 128.0f) - 0.71414 * (double)(cr - 128.0f);
            rgb[base + 1] = (byte)(val < 0.0 ? 0 : (byte)(val > 255.0 ? -1 : (byte)(val + 0.5)));
            val = (double)y + 1.772 * (double)(cb - 128.0f);
            rgb[base + 2] = (byte)(val < 0.0 ? 0 : (byte)(val > 255.0 ? -1 : (byte)(val + 0.5)));
            ++i;
            base += 3;
        }
        int[] nArray = new int[3];
        nArray[1] = 1;
        nArray[2] = 2;
        raster = Raster.createInterleavedRaster(new DataBufferByte(rgb, rgb.length), w, h, w * 3, 3, nArray, null);
        ColorSpace cs = ColorSpace.getInstance(1000);
        ComponentColorModel cm = new ComponentColorModel(cs, false, true, 1, 0);
        return new BufferedImage(cm, (WritableRaster)raster, true, null);
    }
}

