/*
 * Decompiled with CFR 0.152.
 */
package com.zhiqim.media.service.util;

import java.util.ArrayList;
import java.util.List;
import org.im4java.core.CompositeCmd;
import org.im4java.core.ConvertCmd;
import org.im4java.core.IMOperation;
import org.im4java.core.IdentifyCmd;
import org.im4java.core.Operation;
import org.im4java.process.ArrayListOutputConsumer;
import org.im4java.process.OutputConsumer;
import org.zhiqim.kernel.Global;
import org.zhiqim.kernel.json.Jsons;
import org.zhiqim.kernel.util.Arrays;
import org.zhiqim.kernel.util.Files;
import org.zhiqim.kernel.util.Ids;
import org.zhiqim.kernel.util.Strings;
import org.zhiqim.kernel.util.Validates;

public class GraphicsMagickUtil {
    private static String imageMagickPath = Global.getString((String)"tools", (String)"graphicsMagickPath", (String)"C:\\Program Files\\GraphicsMagick-1.3.26-Q16");
    private static String gmProfilesPath = Global.getString((String)"tools", (String)"gmProfilesPath", (String)"C:\\Program Files\\GraphicsMagick-1.3.26-Q16\\profiles");

    public static void crop(String srcPath, String destPath, int x, int y, int x1, int y1, String quality) throws Exception {
        int width = x1 - x;
        int height = y1 - y;
        IMOperation op = new IMOperation();
        op.addImage(new String[]{srcPath});
        op.addRawArgs(new String[]{"-quality", quality});
        op.crop(Integer.valueOf(width), Integer.valueOf(height), Integer.valueOf(x), Integer.valueOf(y));
        op.addImage(new String[]{destPath});
        ConvertCmd convert = new ConvertCmd(true);
        String osName = System.getProperty("os.name").toLowerCase();
        if (osName.indexOf("win") >= 0) {
            convert.setSearchPath(imageMagickPath);
        }
        convert.run((Operation)op, new Object[0]);
    }

    public static void compressionQuality(String srcPath, String destPath, String quality) throws Exception {
        IMOperation op = new IMOperation();
        op.addImage(new String[]{srcPath});
        op.addRawArgs(new String[]{"-quality", quality});
        op.addImage(new String[]{destPath});
        ConvertCmd convert = new ConvertCmd(true);
        String osName = System.getProperty("os.name").toLowerCase();
        if (osName.indexOf("win") >= 0) {
            convert.setSearchPath(imageMagickPath);
        }
        convert.run((Operation)op, new Object[0]);
    }

    public static void resize(int width, int height, String srcPath, String destPath, String quality) throws Exception {
        IMOperation op = new IMOperation();
        op.addImage(new String[]{srcPath});
        op.resize(Integer.valueOf(width), Integer.valueOf(height));
        op.addRawArgs(new String[]{"-quality", quality});
        op.addImage(new String[]{destPath});
        ConvertCmd convert = new ConvertCmd(true);
        String osName = System.getProperty("os.name").toLowerCase();
        if (osName.indexOf("win") >= 0) {
            convert.setSearchPath(imageMagickPath);
        }
        convert.run((Operation)op, new Object[0]);
    }

    public static void resizeByWidth(int width, String srcPath, String destPath, String quality) throws Exception {
        IMOperation op = new IMOperation();
        op.addImage(new String[]{srcPath});
        op.resize(Integer.valueOf(width), null);
        op.addRawArgs(new String[]{"-quality", quality});
        op.addImage(new String[]{destPath});
        ConvertCmd convert = new ConvertCmd(true);
        String osName = System.getProperty("os.name").toLowerCase();
        if (osName.indexOf("win") >= 0) {
            convert.setSearchPath(imageMagickPath);
        }
        convert.run((Operation)op, new Object[0]);
    }

    public static void resizeByHeight(int height, String srcPath, String destPath, String quality) throws Exception {
        IMOperation op = new IMOperation();
        op.addImage(new String[]{srcPath});
        op.resize(null, Integer.valueOf(height));
        op.addRawArgs(new String[]{"-quality", quality});
        op.addImage(new String[]{destPath});
        ConvertCmd convert = new ConvertCmd(true);
        String osName = System.getProperty("os.name").toLowerCase();
        if (osName.indexOf("win") >= 0) {
            convert.setSearchPath(imageMagickPath);
        }
        convert.run((Operation)op, new Object[0]);
    }

    public static void convertCmykToRgb(String srcPath, String destPath, String quality) throws Exception {
        String json = GraphicsMagickUtil.showImageInfo(srcPath);
        String colorspace = Jsons.getString((String)json, (String)"colorspace");
        if (Validates.isEmpty((String)quality)) {
            quality = "95";
        }
        IMOperation op = new IMOperation();
        op.addImage(new String[]{srcPath});
        if ("cmyk".equals(colorspace)) {
            op.profile(Strings.addEndsWith((String)gmProfilesPath, (String)"/RGB.icc"));
            op.addRawArgs(new String[]{"-colorspace", "rgb"});
        }
        op.addRawArgs(new String[]{"-quality", quality});
        op.addImage(new String[]{destPath});
        ConvertCmd convert = new ConvertCmd(true);
        String osName = System.getProperty("os.name").toLowerCase();
        if (osName.indexOf("win") >= 0) {
            convert.setSearchPath(imageMagickPath);
        }
        convert.run((Operation)op, new Object[0]);
    }

    public static void pdfToPic(String pdfPath, String destPath, int width, int height, String quality) throws Exception {
        IMOperation op = new IMOperation();
        op.addRawArgs(new String[]{"-density", "300"});
        op.addRawArgs(new String[]{"-quality", quality});
        op.resize(Integer.valueOf(width), Integer.valueOf(height));
        op.addImage(new String[]{pdfPath});
        op.addImage(new String[]{destPath});
        ConvertCmd convert = new ConvertCmd(true);
        String osName = System.getProperty("os.name").toLowerCase();
        if (osName.indexOf("win") >= 0) {
            convert.setSearchPath(imageMagickPath);
        }
        convert.run((Operation)op, new Object[0]);
    }

    public static void addImgText(String srcPath, String destPath, String[] param, String gravity, int[] geometry, int[] position) throws Exception {
        if (param == null || param.length != 4) {
            throw new Exception("\u53c2\u6570\u4f20\u9012\u4e0d\u6b63\u786e");
        }
        int x = 0;
        int y = 0;
        if (position != null && position.length == 2) {
            x = position[0];
            y = position[1];
        }
        String content = param[0];
        String fontFamily = param[1];
        String fontColor = param[2];
        int fontSize = Integer.parseInt(param[3]);
        IMOperation op = new IMOperation();
        op.font(fontFamily);
        op.pointsize(Integer.valueOf(fontSize));
        if (geometry != null && geometry.length == 2) {
            op.geometry(Integer.valueOf(geometry[0]), Integer.valueOf(geometry[1]));
        }
        if (gravity != null && !"".equals(gravity)) {
            op.gravity(gravity);
        }
        String text = "text " + x + "," + y + " " + content;
        op.fill(fontColor).draw(text);
        op.addImage(new String[]{srcPath});
        op.addImage(new String[]{destPath});
        ConvertCmd convert = new ConvertCmd(true);
        String osName = System.getProperty("os.name").toLowerCase();
        if (osName.indexOf("win") >= 0) {
            convert.setSearchPath(imageMagickPath);
        }
        convert.run((Operation)op, new Object[0]);
    }

    public static void addImgWater(String srcPath, String destPath, String waterPath, String gravity, int dissolve, int[] geometry, int[] position) throws Exception {
        IMOperation op = new IMOperation();
        if (gravity != null) {
            op.gravity(gravity);
        }
        if (geometry != null && geometry.length == 2) {
            if (position != null && position.length == 2) {
                op.geometry(Integer.valueOf(geometry[0]), Integer.valueOf(geometry[1]), Integer.valueOf(position[0]), Integer.valueOf(position[1]));
            } else {
                op.geometry(Integer.valueOf(geometry[0]), Integer.valueOf(geometry[1]));
            }
        }
        op.dissolve(Integer.valueOf(dissolve));
        op.addImage(new String[]{waterPath.replace("https://", "http://")});
        op.addImage(new String[]{srcPath.replace("https://", "http://")});
        op.addRawArgs(new String[]{"-quality", "100"});
        op.addImage(new String[]{destPath});
        CompositeCmd cmd = new CompositeCmd(true);
        String osName = System.getProperty("os.name").toLowerCase();
        if (osName.indexOf("win") >= 0) {
            cmd.setSearchPath(imageMagickPath);
        }
        cmd.run((Operation)op, new Object[0]);
    }

    public static byte[] addImgWater(String srcPath, String waterPath, String savePath, String suffix, String gravity, int dissolve, int[] geometry, int[] position) throws Exception {
        long longId = Ids.longId();
        String destPath = String.valueOf(savePath) + longId + "." + suffix;
        IMOperation op = new IMOperation();
        if (gravity != null) {
            op.gravity(gravity);
        }
        if (geometry != null && geometry.length == 2) {
            if (position != null && position.length == 2) {
                op.geometry(Integer.valueOf(geometry[0]), Integer.valueOf(geometry[1]), Integer.valueOf(position[0]), Integer.valueOf(position[1]));
            } else {
                op.geometry(Integer.valueOf(geometry[0]), Integer.valueOf(geometry[1]));
            }
        }
        op.dissolve(Integer.valueOf(dissolve));
        op.addImage(new String[]{waterPath.replace("https://", "http://")});
        op.addImage(new String[]{srcPath.replace("https://", "http://")});
        op.addRawArgs(new String[]{"-quality", "100"});
        op.addImage(new String[]{destPath});
        CompositeCmd cmd = new CompositeCmd(true);
        String osName = System.getProperty("os.name").toLowerCase();
        if (osName.indexOf("win") >= 0) {
            cmd.setSearchPath(imageMagickPath);
        }
        cmd.run((Operation)op, new Object[0]);
        return Files.read((String)destPath);
    }

    public static String showImageInfo(String srcPath) throws Exception {
        IMOperation op = new IMOperation();
        op.format("width:%w,height:%h,path:%d,file:%f,colorspace:%r,size:%b");
        op.addImage(1);
        IdentifyCmd cmd = new IdentifyCmd(true);
        String osName = System.getProperty("os.name").toLowerCase();
        if (osName.indexOf("win") >= 0) {
            cmd.setSearchPath(imageMagickPath);
        }
        ArrayListOutputConsumer output = new ArrayListOutputConsumer();
        cmd.setOutputConsumer((OutputConsumer)output);
        cmd.run((Operation)op, new Object[]{srcPath});
        ArrayList cmdOutput = output.getOutput();
        assert (cmdOutput.size() == 1);
        String json = (String)cmdOutput.get(0);
        String colorspance = Jsons.getString((String)json, (String)"colorspace");
        if ("ColorSeparation".equals(colorspance)) {
            json = json.replace(colorspance, "cmyk");
        } else if ("TrueColor".equals(colorspance)) {
            json = json.replace(colorspance, "rgb");
        }
        return json;
    }

    public static int[] getImageInfo(String srcPath) throws Exception {
        IMOperation op = new IMOperation();
        op.format("%w,%h");
        op.addImage(1);
        IdentifyCmd cmd = new IdentifyCmd(true);
        String osName = System.getProperty("os.name").toLowerCase();
        if (osName.indexOf("win") >= 0) {
            cmd.setSearchPath(imageMagickPath);
        }
        ArrayListOutputConsumer output = new ArrayListOutputConsumer();
        cmd.setOutputConsumer((OutputConsumer)output);
        cmd.run((Operation)op, new Object[]{srcPath});
        ArrayList cmdOutput = output.getOutput();
        assert (cmdOutput.size() == 1);
        String strs = (String)cmdOutput.get(0);
        return Arrays.toIntArray((String)strs, (String)",");
    }

    public static void rotate(String srcPath, String destPath, double angle) throws Exception {
        IMOperation op = new IMOperation();
        op.rotate(Double.valueOf(angle));
        op.addImage(new String[]{srcPath});
        op.addImage(new String[]{destPath});
        ConvertCmd cmd = new ConvertCmd(true);
        String osName = System.getProperty("os.name").toLowerCase();
        if (osName.indexOf("win") >= 0) {
            cmd.setSearchPath(imageMagickPath);
        }
        cmd.run((Operation)op, new Object[0]);
    }

    public static void merge(List<String> imageList, int maxWidth, int maxHeight, String destPath, int border, String type) throws Exception {
        IMOperation op = new IMOperation();
        ConvertCmd cmd = new ConvertCmd(true);
        String osName = System.getProperty("os.name").toLowerCase();
        if (osName.indexOf("win") >= 0) {
            cmd.setSearchPath(imageMagickPath);
        }
        String thumb_size = String.valueOf(maxWidth) + "x" + maxHeight + "^";
        String extent = String.valueOf(maxWidth) + "x" + maxHeight;
        if ("1".equals(type)) {
            op.addRawArgs(new String[]{"+append"});
        } else if ("2".equals(type)) {
            op.addRawArgs(new String[]{"-append"});
        }
        op.addRawArgs(new String[]{"-gravity", "center"});
        op.addRawArgs(new String[]{"-extent", extent});
        op.addRawArgs(new String[]{"-border", String.valueOf(border) + "x" + border});
        op.addRawArgs(new String[]{"-bordercolor", "#ccc"});
        op.addRawArgs(new String[]{"-border", "1x1"});
        op.addRawArgs(new String[]{"-bordercolor", "#fff"});
        for (String img : imageList) {
            op.addImage(new String[]{img});
        }
        op.addRawArgs(new String[]{"-thumbnail", thumb_size});
        op.addImage(new String[]{destPath});
        cmd.run((Operation)op, new Object[0]);
    }

    public static void main(String[] args) throws Exception {
    }
}

