/*
 * Decompiled with CFR 0.152.
 */
package com.zhiqim.media.service.util;

import com.zhiqim.media.service.svg.MediaSvgText;
import java.awt.Font;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.LineMetrics;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.io.FileInputStream;
import java.io.InputStream;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.zhiqim.kernel.json.Jsons;
import org.zhiqim.kernel.util.Streams;
import org.zhiqim.kernel.util.Validates;

public class FontUtil {
    public static final String SPACE = " ";
    public static FontRenderContext frc = new FontRenderContext(null, false, false);

    public static void main(String[] args) throws Exception {
        String filepath = "d:\\data\\temp\\text.svg";
        String svgCode = Streams.getStringUTF8((InputStream)new FileInputStream(filepath));
        MediaSvgText svgText = new MediaSvgText(svgCode);
        svgText.init();
        String xml = svgText.toXml();
        System.out.println(xml);
    }

    public static Rectangle2D getRectangle2D(Font font, String str) {
        Rectangle2D rect = font.getStringBounds(str, frc);
        return rect;
    }

    public static LineMetrics getLineMetrics(Font font, String str) {
        LineMetrics lm = font.getLineMetrics(str, frc);
        return lm;
    }

    public static List<String> toPathData(Font font, String str) {
        if (Validates.isEmpty((String)str)) {
            return new ArrayList<String>();
        }
        str = str.trim();
        ArrayList<String> list = new ArrayList<String>();
        GlyphVector gv = font.createGlyphVector(frc, str);
        Rectangle2D rect = gv.getLogicalBounds();
        String d = "";
        double width = 0.0;
        double whitespaceWidth = 0.0;
        double preEndX = 0.0;
        int i = 0;
        while (i < str.length()) {
            Shape shape = FontUtil.getShape(font, str, i);
            d = FontUtil.toPathData(shape);
            double curX = gv.getGlyphOutline(i).getBounds().getX() - shape.getBounds().getX();
            if (d.length() == 0) {
                width = whitespaceWidth;
                curX = preEndX;
            } else if (i < str.length() - 1) {
                double nextX;
                if (gv.getGlyphOutline(i + 1).getBounds().getX() == 0.0) {
                    width = 2.0 * shape.getBounds().getX() + shape.getBounds().getWidth();
                    if (whitespaceWidth == 0.0) {
                        int count = 0;
                        nextX = 0.0;
                        int j = i + 1;
                        while (j < str.length()) {
                            if (gv.getGlyphOutline(j).getBounds().getX() == 0.0) {
                                ++count;
                            } else {
                                Shape nextShape = FontUtil.getShape(font, str, j);
                                nextX = gv.getGlyphOutline(j).getBounds().getX() - nextShape.getBounds().getX();
                                break;
                            }
                            ++j;
                        }
                        whitespaceWidth = (nextX - curX - width) / (double)count;
                    }
                } else {
                    Shape nextShape = FontUtil.getShape(font, str, i + 1);
                    nextX = gv.getGlyphOutline(i + 1).getBounds().getX() - nextShape.getBounds().getX();
                    width = nextX - curX;
                }
            } else {
                width = rect.getWidth() - curX;
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("x", curX);
            map.put("y", gv.getGlyphOutline(i).getBounds().getY());
            map.put("width", width);
            map.put("height", gv.getGlyphOutline(i).getBounds().getHeight());
            map.put("d", d);
            list.add(Jsons.toString(map));
            preEndX = curX + width;
            ++i;
        }
        return list;
    }

    public static Shape getShape(Font font, String str, int index) {
        char c = str.charAt(index);
        String s = String.valueOf(c);
        GlyphVector gv = font.createGlyphVector(frc, s);
        Shape shape = gv.getGlyphOutline(0);
        return shape;
    }

    public static List<String> toEachPathData(Font font, String str) {
        ArrayList<String> list = new ArrayList<String>();
        int i = 0;
        while (i < str.length()) {
            char c = str.charAt(i);
            list.add(Jsons.toString(FontUtil.toEachPathByChar(font, c)));
            ++i;
        }
        return list;
    }

    public static Map<String, Object> toEachPathByChar(Font font, char c) {
        String s = String.valueOf(c);
        GlyphVector gv = font.createGlyphVector(frc, s);
        Shape glyphShape = gv.getGlyphOutline(0);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("x", glyphShape.getBounds().getX());
        map.put("y", glyphShape.getBounds().getY());
        map.put("width", glyphShape.getBounds().getWidth());
        map.put("height", glyphShape.getBounds().getHeight());
        String d = FontUtil.toPathData(glyphShape);
        map.put("d", d);
        return map;
    }

    public static List<Map<String, Object>> toEachPathList(Font font, String str) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        int i = 0;
        while (i < str.length()) {
            char c = str.charAt(i);
            list.add(FontUtil.toEachPathByChar(font, c));
            ++i;
        }
        return list;
    }

    public static String toPathData(Shape shape) {
        DecimalFormat format = new DecimalFormat("#.####");
        StringBuffer d = new StringBuffer(40);
        PathIterator pi = shape.getPathIterator(null);
        float[] seg = new float[6];
        int segType = 0;
        while (!pi.isDone()) {
            segType = pi.currentSegment(seg);
            switch (segType) {
                case 0: {
                    d.append("M");
                    FontUtil.appendPoint(d, seg[0], seg[1], format);
                    break;
                }
                case 1: {
                    d.append("L");
                    FontUtil.appendPoint(d, seg[0], seg[1], format);
                    break;
                }
                case 4: {
                    d.append("Z");
                    break;
                }
                case 2: {
                    d.append("Q");
                    FontUtil.appendPoint(d, seg[0], seg[1], format);
                    FontUtil.appendPoint(d, seg[2], seg[3], format);
                    break;
                }
                case 3: {
                    d.append("C");
                    FontUtil.appendPoint(d, seg[0], seg[1], format);
                    FontUtil.appendPoint(d, seg[2], seg[3], format);
                    FontUtil.appendPoint(d, seg[4], seg[5], format);
                    break;
                }
                default: {
                    throw new Error("\u65e0\u6548\u7684\u7247\u6bb5\u7c7b\u578b:" + segType);
                }
            }
            pi.next();
        }
        if (d.length() > 0) {
            return d.toString().trim();
        }
        return "";
    }

    private static void appendPoint(StringBuffer d, float x, float y, DecimalFormat format) {
        d.append(FontUtil.doubleString(format, x));
        d.append(SPACE);
        d.append(FontUtil.doubleString(format, y));
        d.append(SPACE);
    }

    private static String doubleString(DecimalFormat decimalFormat, float value) {
        double absvalue = Math.abs(value);
        if (absvalue >= 1.0E8 || (float)((int)value) == value) {
            return Integer.toString((int)value);
        }
        return decimalFormat.format(value);
    }

    public static String font2Svg(String fontName, int fontStyle, int fontSize, String content) {
        Font font = new Font(fontName, fontStyle, fontSize);
        List<Map<String, Object>> list = FontUtil.toEachPathList(font, content);
        Rectangle2D rect = FontUtil.getRectangle2D(font, content);
        double w = rect.getWidth();
        if (w <= 0.0) {
            w = 22 * content.length();
        }
        double width = w + 20.0;
        double height = rect.getHeight() + 10.0;
        StringBuffer strb = new StringBuffer();
        strb.append("<svg width=\"").append(width).append("\" height=\"").append(height).append("\" viewBox=\"0 0 ").append(width).append(SPACE).append(height).append("\" preserveAspectRatio=\"none\" version=\"1.1\" xmlns=\"http://www.w3.org/2000/svg\" xmlns:xlink= \"http://www.w3.org/1999/xlink\">").append("\r\n");
        strb.append("<g transform=\"translate(0," + fontSize + ")\">");
        double transX = 0.0;
        for (Map<String, Object> data : list) {
            String svg = "<g class=\"font-path\" transform=\"translate(" + (transX += ((Double)data.get("x")).doubleValue()) + ", 0) skewX(0)\" >";
            svg = String.valueOf(svg) + "<path fill=\"#000000\" d=\"" + data.get("d") + "\"></path>";
            svg = String.valueOf(svg) + "</g>";
            strb.append(svg);
            transX = transX + (Double)data.get("x") + (Double)data.get("width");
        }
        strb.append("</g>");
        strb.append("</svg>");
        return strb.toString();
    }
}

