/*
 * Decompiled with CFR 0.152.
 */
package com.zhiqim.media.service.util;

public class Colors {
    public static float[] rgb2hsb(int r, int g, int b) {
        float minRGB;
        if (r < 0 || r > 255) {
            return null;
        }
        if (g < 0 || g > 255) {
            return null;
        }
        if (b < 0 || b > 255) {
            return null;
        }
        float red = (float)r / 255.0f;
        float green = (float)g / 255.0f;
        float blue = (float)b / 255.0f;
        float maxRGB = Math.max(red, Math.max(green, blue));
        if (maxRGB == (minRGB = Math.min(red, Math.min(green, blue)))) {
            return new float[]{0.0f, 0.0f, minRGB};
        }
        float hue = 0.0f;
        if (maxRGB == red && green >= blue) {
            hue = 60.0f * (green - blue) / (maxRGB - minRGB);
        } else if (maxRGB == red && green < blue) {
            hue = 60.0f * (green - blue) / (maxRGB - minRGB) + 360.0f;
        } else if (maxRGB == green) {
            hue = (blue - red) * 60.0f / (maxRGB - minRGB) + 120.0f;
        } else if (maxRGB == blue) {
            hue = (red - green) * 60.0f / (maxRGB - minRGB) + 240.0f;
        }
        float sat = (maxRGB - minRGB) / maxRGB;
        float bri = maxRGB;
        return new float[]{hue, sat, bri};
    }

    public static String rgb2hex(int r, int g, int b) {
        String blue;
        String green;
        String red = Integer.toHexString(r);
        if (red.length() < 2) {
            red = "0" + red;
        }
        if ((green = Integer.toHexString(g)).length() < 2) {
            green = "0" + green;
        }
        if ((blue = Integer.toHexString(b)).length() < 2) {
            blue = "0" + blue;
        }
        return "#" + red + green + blue;
    }

    public static float[] rgb2cmyk(int r, int g, int b) {
        float c = (float)(255 - r) / 255.0f;
        float m = (float)(255 - g) / 255.0f;
        float y = (float)(255 - b) / 255.0f;
        float k = Math.min(c, Math.min(m, y));
        c = (c - k) / (1.0f - k);
        m = (m - k) / (1.0f - k);
        y = (y - k) / (1.0f - k);
        if ((double)k == 1.0) {
            return new float[]{0.0f, 0.0f, 0.0f, 1.0f};
        }
        return new float[]{c, m, y, k};
    }

    public static int[] cmyk2rgb(float c, float m, float y, float k) {
        int r = Math.round((1.0f - c) * (1.0f - k) * 255.0f);
        int g = Math.round((1.0f - m) * (1.0f - k) * 255.0f);
        int b = Math.round((1.0f - y) * (1.0f - k) * 255.0f);
        return new int[]{r, g, b};
    }

    public static int[] cmyk2rgb(int c, int m, int y, int k) {
        int r = (100 - c) * (100 - k) * 255 / 10000;
        int g = (100 - m) * (100 - k) * 255 / 10000;
        int b = (100 - y) * (100 - k) * 255 / 10000;
        return new int[]{r, g, b};
    }
}

