/*
 * Decompiled with CFR 0.152.
 */
package com.zhiqim.media.service.task;

import com.zhiqim.media.dbo.MediaCanvas;
import com.zhiqim.media.service.dao.MediaPathDao;
import java.io.File;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.zhiqim.kernel.logging.Log;
import org.zhiqim.kernel.logging.LogFactory;
import org.zhiqim.kernel.schedule.Task;
import org.zhiqim.kernel.util.DateTimes;
import org.zhiqim.kernel.util.Files;
import org.zhiqim.kernel.util.Lists;
import org.zhiqim.kernel.util.Maths;
import org.zhiqim.kernel.util.Strings;
import org.zhiqim.kernel.util.Validates;

public class AutoClearMaterialTimer
implements Task {
    private static final Log log = LogFactory.getLog(AutoClearMaterialTimer.class);

    public void execute() {
        log.info((Object)"\u6e05\u7406\u4e34\u65f6\u7d20\u6750\u6587\u4ef6\u4efb\u52a1\u5f00\u59cb...");
        long beginTime = System.currentTimeMillis();
        String curDate = DateTimes.getDateTime8String();
        File file = new File(MediaPathDao.getTempLocalPre(curDate));
        String fileDir = file.getParent();
        this.delFileDir(fileDir, 10);
        long endTime = System.currentTimeMillis();
        log.info((Object)"\u6e05\u7406\u4e34\u65f6\u7d20\u6750\u6587\u4ef6\u4efb\u52a1\u7ed3\u675f\uff0c\u5171\u8017\u65f6[%s]\u79d2", new Object[]{Maths.division((long)(endTime - beginTime), (long)1000L, (int)3)});
    }

    private void delFileDir(String fileDir, int num) {
        Object[] dirArr = Files.getDirectoryList((String)fileDir);
        if (dirArr == null || dirArr.length <= num) {
            return;
        }
        List dirList = Lists.toList((Object[])dirArr);
        Collections.sort(dirList, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.compareTo(o2);
            }
        });
        dirList = dirList.subList(0, dirList.size() - num);
        for (String dir : dirList) {
            try {
                String path = String.valueOf(Strings.addEndsWith((String)fileDir, (String)"/")) + dir;
                if (Files.deleteDirectory((String)path)) {
                    log.info((Object)("\u7d20\u6750\u6587\u4ef6\u6e05\u7406\u4efb\u52a1\uff0c\u5220\u9664\u4e34\u65f6\u6587\u4ef6\u76ee\u5f55" + path + "\u6210\u529f"));
                    continue;
                }
                log.info((Object)("\u7d20\u6750\u6587\u4ef6\u6e05\u7406\u4efb\u52a1\uff0c\u5220\u9664\u4e34\u65f6\u6587\u4ef6\u76ee\u5f55" + path + "\u5931\u8d25"));
            }
            catch (Exception exception) {}
        }
    }

    private void delImpImages(MediaCanvas canvas) {
        long mediaId = canvas.getMediaId();
        String imgUrl = canvas.getMediaUrl();
        if (Validates.isEmptyBlank((String)imgUrl)) {
            return;
        }
        String fileName = Files.getFileName((String)imgUrl);
        if (!fileName.startsWith("imp_")) {
            return;
        }
        String fileDir = MediaPathDao.getCanvasLocalPre(mediaId);
        String[] files = Files.getDirectoryList((String)fileDir);
        if (files == null || files.length == 0) {
            return;
        }
        String[] stringArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            String f = stringArray[n2];
            if (f.startsWith("imp_") && !fileName.equals(f)) {
                Files.deleteFile((String)(String.valueOf(fileDir) + f));
            }
            ++n2;
        }
        log.info((Object)("\u7d20\u6750\u6587\u4ef6\u6e05\u7406\u4efb\u52a1\uff0c\u5220\u9664\u591a\u4f59\u6548\u679c\u56fe" + canvas.getMediaId() + "\u6210\u529f"));
    }
}

