/*
 * Decompiled with CFR 0.152.
 */
package com.zhiqim.media.service.svg;

import com.zhiqim.media.service.svg.MediaSvgDocument;
import com.zhiqim.media.service.svg.MediaSvgElement;
import com.zhiqim.media.service.util.MetrixUtil;
import com.zhiqim.media.service.util.UnitUtil;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.zhiqim.kernel.util.Arrays;
import org.zhiqim.kernel.util.Validates;

public class MediaSvgText
extends MediaSvgElement {
    private MediaSvgDocument mediaSvgDoc;
    private Element node = null;
    private Map<String, String> attributeMap = new HashMap<String, String>();
    private String textContent;
    private float dy = 0.0f;
    private float skewXDeg = 0.0f;
    private int lineHeight = 0;

    public MediaSvgText(String svgCode) {
        super(svgCode);
    }

    public MediaSvgText(MediaSvgDocument mediaSvgDoc, Element node) {
        super(null);
        this.mediaSvgDoc = mediaSvgDoc;
        this.document = mediaSvgDoc.getDocument();
        this.node = node;
    }

    @Override
    public void parse() {
        String strokeWidth;
        Element g = this.node;
        if (g == null) {
            g = this.getChildNode(this.document, "g");
        }
        this.dealFontFamily(g.getAttribute("data-fontfamily"));
        String fontsize = g.getAttribute("data-fontsize");
        this.attributeMap.put("font-size", String.valueOf(UnitUtil.convert(fontsize)));
        String bold = Integer.parseInt(g.getAttribute("data-fontweight")) == 1 ? "bold" : "normal";
        this.attributeMap.put("font-weight", bold);
        this.attributeMap.put("letter-spacing", g.getAttribute("data-letterspacing"));
        this.lineHeight = Integer.parseInt(g.getAttribute("data-lineheight"));
        this.obtainText(g);
        this.attributeMap.put("opacity", g.getAttribute("opacity"));
        String transform = g.getAttribute("transform");
        this.analysis(transform);
        Element svg = this.getChildNode(g, "svg");
        String stroke = svg.getAttribute("stroke");
        if (Validates.isNotEmpty((String)stroke)) {
            this.attributeMap.put("stroke", stroke);
        }
        if (Validates.isNotEmpty((String)(strokeWidth = svg.getAttribute("stroke-width")))) {
            this.attributeMap.put("stroke-width", strokeWidth);
        }
        Element group = this.getChildNode(svg, "g");
        String nextTransform = group.getAttribute("transform");
        int ind = nextTransform.indexOf(44);
        int ind1 = nextTransform.indexOf(41, ind);
        this.dy = Float.parseFloat(nextTransform.substring(ind + 1, ind1).trim());
        Element gpath = this.getChildNode(group, "g");
        NamedNodeMap gpathAttrs = gpath.getAttributes();
        int i = 0;
        while (i < gpathAttrs.getLength()) {
            Node attr = gpathAttrs.item(i);
            if (attr.getNodeName().equals("transform") && attr.getNodeValue().indexOf("skewX(-15)") != -1) {
                this.skewXDeg = -15.0f;
            }
            ++i;
        }
        String fill = "#FFFFFF";
        Element path = this.getChildNode(gpath, "path");
        NamedNodeMap pathAttrs = path.getAttributes();
        int i2 = 0;
        while (i2 < pathAttrs.getLength()) {
            Node attr = pathAttrs.item(i2);
            if (attr.getNodeName().equals("fill")) {
                fill = attr.getNodeValue();
            }
            ++i2;
        }
        this.attributeMap.put("fill", fill);
        Element line = this.getChildNode(gpath, "line");
        if (line != null) {
            this.attributeMap.put("text-decoration", "underline");
        }
        this.matrixOperation();
    }

    private void dealFontFamily(String fontFamily) {
        GraphicsEnvironment e = GraphicsEnvironment.getLocalGraphicsEnvironment();
        Font[] fonts = e.getAllFonts();
        int i = 0;
        while (i < fonts.length) {
            Font font = fonts[i];
            String fontName = font.getFontName();
            if (fontFamily.equals(fontName)) {
                this.attributeMap.put("font-family", "'" + font.getPSName() + "'");
            }
            ++i;
        }
    }

    private void obtainText(Element g) {
        if (this.svgCode != null) {
            String before = "data-text=\"";
            String end = "\"";
            int ind = this.svgCode.indexOf(before);
            int ind1 = this.svgCode.indexOf(end, ind + before.length());
            this.textContent = this.svgCode.substring(ind + before.length(), ind1);
            return;
        }
        String id = g.getAttribute("id");
        String starts = "id=\"" + id + "\"";
        String xml = this.svgCode == null ? this.mediaSvgDoc.svgCode : this.svgCode;
        int fromIndex = xml.indexOf(starts);
        String before = "data-text=\"";
        String end = "\"";
        int ind = xml.indexOf(before, fromIndex);
        int ind1 = xml.indexOf(end, ind + before.length());
        this.textContent = xml.substring(ind + before.length(), ind1);
    }

    protected void matrixOperation() {
        float[] m1 = new float[]{1.0f, 0.0f, 0.0f, 1.0f, this.tx, this.ty};
        double theta = (double)(this.deg * 2.0f) * Math.PI / 360.0;
        float[] m2 = new float[]{(float)Math.cos(theta), (float)Math.sin(theta), (float)(-Math.sin(theta)), (float)Math.cos(theta), this.rx, this.ry};
        float[] m3 = new float[]{1.0f, 0.0f, 0.0f, 1.0f, -this.rx, -this.ry};
        float[] m4 = new float[]{1.0f, 0.0f, 0.0f, 1.0f, 0.0f, this.dy};
        double theta2 = (double)(this.skewXDeg * 2.0f) * Math.PI / 360.0;
        float[] m5 = new float[]{1.0f, 0.0f, (float)Math.tan(theta2), 1.0f, 0.0f, 0.0f};
        float[] flatmatrix = MetrixUtil.metrixMultiply(m1, m2, m3, m4, m5);
        String transform = "matrix(" + Arrays.toString((float[])flatmatrix, (String)" ") + ")";
        this.attributeMap.put("transform", transform);
    }

    @Override
    public Element toElement() {
        Element text = this.document.createElement("text");
        String[] lines = this.textContent.split("\n");
        text.setAttribute("transform", this.attributeMap.get("transform"));
        text.setAttribute("xml:space", "preserve");
        if (this.attributeMap.containsKey("stroke")) {
            text.setAttribute("stroke", this.attributeMap.get("stroke"));
        }
        if (this.attributeMap.containsKey("stroke")) {
            text.setAttribute("stroke-width", this.attributeMap.get("stroke-width"));
        }
        int i = 0;
        while (i < lines.length) {
            Element tspan = this.document.createElement("tspan");
            for (String key : this.attributeMap.keySet()) {
                if ("transform".equals(key)) continue;
                tspan.setAttribute(key, this.attributeMap.get(key));
            }
            tspan.setAttribute("x", "0");
            tspan.setAttribute("y", String.valueOf(i * this.lineHeight));
            tspan.setTextContent(lines[i]);
            text.appendChild(tspan);
            ++i;
        }
        return text;
    }

    public String toXml() {
        Element text = this.toElement();
        return super.toXml(text);
    }
}

