/*
 * Decompiled with CFR 0.152.
 */
package com.zhiqim.media.service.svg;

import com.zhiqim.media.service.svg.MediaSvgDocument;
import com.zhiqim.media.service.svg.MediaSvgElement;
import com.zhiqim.media.service.util.MetrixUtil;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Element;
import org.zhiqim.kernel.util.Arrays;
import org.zhiqim.kernel.util.Strings;

public class MediaSvgImage
extends MediaSvgElement {
    private MediaSvgDocument mediaSvgDoc;
    private Element node = null;
    private float width;
    private float height;
    private float sx = 1.0f;
    private float sy = 1.0f;
    private Map<String, String> attributeMap = new HashMap<String, String>();

    public MediaSvgImage(String svgCode) {
        super(svgCode);
    }

    public MediaSvgImage(MediaSvgDocument mediaSvgDoc, Element node) {
        super(null);
        this.mediaSvgDoc = mediaSvgDoc;
        this.document = mediaSvgDoc.getDocument();
        this.node = node;
    }

    public MediaSvgDocument getMediaSvgDoc() {
        return this.mediaSvgDoc;
    }

    @Override
    public void parse() {
        Element g = this.node;
        if (g == null) {
            g = this.getChildNode(this.document, "g");
        }
        this.attributeMap.put("opacity", g.getAttribute("opacity"));
        String transform = g.getAttribute("transform");
        this.analysis(transform);
        Element svg = this.getChildNode(g, "svg");
        float w = Float.parseFloat(svg.getAttribute("width"));
        float h = Float.parseFloat(svg.getAttribute("height"));
        String viewBox = svg.getAttribute("viewBox");
        String[] vbs = Strings.split((String)viewBox, (String)" ");
        this.attributeMap.put("width", vbs[2]);
        this.attributeMap.put("height", vbs[3]);
        this.width = Float.parseFloat(vbs[2]);
        this.height = Float.parseFloat(vbs[3]);
        this.sx = w / this.width;
        this.sy = h / this.height;
        this.matrixOperation();
        Element subg = this.getChildNode(svg, "g");
        Element image = this.getChildNode(subg, "image");
        this.attributeMap.put("xlink:href", image.getAttribute("xlink:href"));
    }

    protected void matrixOperation() {
        float[] m1 = new float[]{1.0f, 0.0f, 0.0f, 1.0f, this.tx, this.ty};
        double theta = (double)(this.deg * 2.0f) * Math.PI / 360.0;
        float[] m2 = new float[]{(float)Math.cos(theta), (float)Math.sin(theta), (float)(-Math.sin(theta)), (float)Math.cos(theta), this.rx, this.ry};
        float[] m3 = new float[]{1.0f, 0.0f, 0.0f, 1.0f, -this.rx, -this.ry};
        float[] m4 = new float[]{this.sx, 0.0f, 0.0f, this.sy, 0.0f, 0.0f};
        float[] flatmatrix = MetrixUtil.metrixMultiply(m1, m2, m3, m4);
        String transform = "matrix(" + Arrays.toString((float[])flatmatrix, (String)" ") + ")";
        this.attributeMap.put("transform", transform);
    }

    @Override
    public Element toElement() {
        Element image = this.document.createElement("image");
        for (String key : this.attributeMap.keySet()) {
            image.setAttribute(key, this.attributeMap.get(key));
        }
        image.setAttribute("overflow", "visible");
        return image;
    }

    public String toXml() {
        Element image = this.toElement();
        return super.toXml(image);
    }
}

