/*
 * Decompiled with CFR 0.152.
 */
package com.zhiqim.media.service.svg;

import com.zhiqim.media.service.svg.MediaSvgBg;
import com.zhiqim.media.service.svg.MediaSvgElement;
import com.zhiqim.media.service.svg.MediaSvgGroup;
import com.zhiqim.media.service.svg.MediaSvgImage;
import com.zhiqim.media.service.svg.MediaSvgText;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MediaSvgDocument
extends MediaSvgElement {
    private final List<Element> itemList = new ArrayList<Element>();
    private Element svgElement;

    public MediaSvgDocument(String svgCode) {
        super(svgCode);
    }

    @Override
    public void parse() {
        NodeList nodelist = this.document.getChildNodes();
        Node parent = null;
        int i = 0;
        while (i < nodelist.getLength()) {
            Node node = nodelist.item(i);
            if (node.getNodeType() == 1 && node.getNodeName().equals("svg")) {
                parent = node;
                this.svgElement = (Element)node.cloneNode(false);
                break;
            }
            ++i;
        }
        if (parent != null) {
            NodeList nodes = parent.getChildNodes();
            int j = 0;
            while (j < nodes.getLength()) {
                Node node = nodes.item(j);
                if (node.getNodeType() == 1) {
                    MediaSvgElement msele = null;
                    Element ele = (Element)node;
                    int type = Integer.parseInt(ele.getAttribute("data-type"));
                    switch (type) {
                        case 1: {
                            msele = new MediaSvgBg(this, ele);
                            break;
                        }
                        case 2: {
                            msele = new MediaSvgImage(this, ele);
                            break;
                        }
                        case 3: {
                            msele = new MediaSvgText(this, ele);
                            break;
                        }
                        case 4: {
                            msele = new MediaSvgGroup(this, ele);
                            break;
                        }
                    }
                    if (msele != null) {
                        msele.parse();
                        this.itemList.add(msele.toElement());
                    }
                }
                ++j;
            }
        }
    }

    @Override
    public Element toElement() {
        if (this.svgElement == null) {
            return null;
        }
        this.svgElement.setAttribute("xmlns", "http://www.w3.org/2000/svg");
        this.svgElement.setAttribute("xmlns:xlink", "http://www.w3.org/1999/xlink");
        this.svgElement.setAttribute("xml:space", "preserve");
        this.svgElement.setAttribute("x", "0px");
        this.svgElement.setAttribute("y", "0px");
        for (Element ele : this.itemList) {
            this.svgElement.appendChild(ele);
        }
        return this.svgElement;
    }

    public String toXml() {
        Element ele = this.toElement();
        return super.toXml(ele);
    }
}

