/*
 * Decompiled with CFR 0.152.
 */
package com.zhiqim.media.service.handler;

import com.zhiqim.media.dbo.MediaCanvas;
import com.zhiqim.media.service.dao.PdfDao;
import com.zhiqim.media.service.handler.MediaHandlePdfModel;
import com.zhiqim.media.service.util.ItextPdfUtil;
import java.util.List;
import org.zhiqim.kernel.control.Handler;
import org.zhiqim.kernel.logging.Log;
import org.zhiqim.kernel.logging.LogFactory;
import org.zhiqim.kernel.util.Maths;
import org.zhiqim.kernel.util.Validates;
import org.zhiqim.orm.ORM;
import org.zhiqim.orm.ZTable;
import org.zhiqim.orm.dbo.Updater;

public class MediaCanvasToPdfHandler
implements Handler<MediaHandlePdfModel> {
    private Log log = LogFactory.getLog(MediaCanvasToPdfHandler.class);

    public void process(MediaHandlePdfModel module) {
        long mediaId = module.getMediaId();
        long startTime = System.currentTimeMillis();
        MediaCanvas canvas = module.getCanvas();
        int isEdit = canvas.getIsEdit();
        try {
            try {
                this.log.info((Object)("PDF\u5904\u7406\u5668\u5904\u7406[" + mediaId + "]\u5904\u7406\u4e2d"));
                module.setHandleStatus(1);
                canvas.setIsEdit(3);
                List<String> pdfList = PdfDao.getPdfList(canvas, module.getMegerPdfPage(), module.isEditable(), null, null, null, "PDF");
                ItextPdfUtil.megerPdf(pdfList, module.getPdfSavePath());
                if (module.getProgressType() == 1 && Validates.isNotEmptyBlank((String)module.getPdfImgDir())) {
                    pdfList = PdfDao.getPdfList(canvas, module.getMegerPdfPage(), module.isEditable(), null, null, null, "IMAGE");
                    String imgDir = module.getPdfImgDir();
                    List<String> imageList = PdfDao.pdfToImage(pdfList, imgDir, "png", (int)canvas.getWidth(), (int)canvas.getHeight(), 1);
                    module.setImgPathList(imageList);
                }
                module.setHandleStatus(2);
                module.setFinishTime();
                long fihishTime = module.getFinishTime();
                this.log.info((Object)("PDF\u5904\u7406\u5668\u5904\u7406[" + mediaId + "]\u5b8c\u6210, \u5171\u8017\u65f6[%s]\u79d2"), new Object[]{Maths.division((long)(fihishTime - startTime), (long)1000L, (int)3)});
            }
            catch (Exception e) {
                module.setHandleStatus(3);
                module.setErrorMsg("\u5904\u7406[" + mediaId + "]\u5f02\u5e38\uff1a" + e.getMessage());
                this.log.error((Object)("PDF\u5904\u7406\u5668\u5904\u7406[" + mediaId + "]\u5f02\u5e38\uff1a"), (Throwable)e, new Object[0]);
                canvas.setIsEdit(isEdit);
                Updater update = new Updater();
                update.addMust("mediaId", (Object)mediaId);
                update.addMustNotEqual("isEdit", (Object)1);
                update.addField("isEdit", (Object)0);
                try {
                    ((ZTable)ORM.get(ZTable.class)).update(MediaCanvas.class, update);
                }
                catch (Exception e2) {
                    this.log.error((Object)"PDF\u5904\u7406\u5668\u6807\u8bb0\u5904\u7406\u5b8c\u6210\u5f02\u5e38", (Throwable)e2, new Object[0]);
                }
            }
        }
        finally {
            canvas.setIsEdit(isEdit);
            Updater update = new Updater();
            update.addMust("mediaId", (Object)mediaId);
            update.addMustNotEqual("isEdit", (Object)1);
            update.addField("isEdit", (Object)0);
            try {
                ((ZTable)ORM.get(ZTable.class)).update(MediaCanvas.class, update);
            }
            catch (Exception e) {
                this.log.error((Object)"PDF\u5904\u7406\u5668\u6807\u8bb0\u5904\u7406\u5b8c\u6210\u5f02\u5e38", (Throwable)e, new Object[0]);
            }
        }
    }
}

