/*
 * Decompiled with CFR 0.152.
 */
package com.zhiqim.media.service.handler;

import com.zhiqim.media.dbo.MediaCanvas;
import com.zhiqim.media.service.handler.MediaCanvasToPdfHandler;
import com.zhiqim.media.service.handler.MediaHandleModel;
import com.zhiqim.media.service.handler.MediaHandlePdfModel;
import com.zhiqim.media.service.handler.SaveMediaCanvasHandler;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.zhiqim.kernel.Global;
import org.zhiqim.kernel.Servicer;
import org.zhiqim.kernel.control.Handler;
import org.zhiqim.kernel.control.HandlerController;
import org.zhiqim.kernel.control.Threader;
import org.zhiqim.kernel.logging.Log;
import org.zhiqim.kernel.logging.LogFactory;
import org.zhiqim.kernel.schedule.Interval;
import org.zhiqim.kernel.schedule.Scheduler;
import org.zhiqim.kernel.schedule.Task;
import org.zhiqim.kernel.util.Ids;
import org.zhiqim.kernel.util.Validates;
import org.zhiqim.orm.ORM;
import org.zhiqim.orm.ZTable;
import org.zhiqim.orm.dbo.Updater;

public class MediaCanvasController
extends Servicer
implements Task {
    private static final Log log = LogFactory.getLog(MediaCanvasController.class);
    private HandlerController savecontroller;
    private HandlerController topdfcontroller;
    private Map<Long, MediaHandleModel> savingModelMap;
    private Map<Long, MediaHandlePdfModel> toPdfModelMap;
    private final Map<Long, MediaHandlePdfModel> pdfSuccMap = new LinkedHashMap<Long, MediaHandlePdfModel>();

    public boolean create() throws Exception {
        this.init();
        return true;
    }

    private void init() {
        this.savingModelMap = new LinkedHashMap<Long, MediaHandleModel>();
        this.toPdfModelMap = new LinkedHashMap<Long, MediaHandlePdfModel>();
        int defaultMaxPoolSize = 2;
        int minPoolSize = 1;
        int maxPoolSize = Global.getInt((String)"media", (String)"handleThread", (int)defaultMaxPoolSize);
        maxPoolSize = maxPoolSize <= defaultMaxPoolSize ? defaultMaxPoolSize : maxPoolSize;
        this.savecontroller = new HandlerController();
        this.savecontroller.set(minPoolSize, maxPoolSize, 1800, 999999);
        this.savecontroller.create();
        this.savecontroller.addHandler(MediaHandleModel.class, (Handler)new SaveMediaCanvasHandler());
        this.topdfcontroller = new HandlerController();
        this.topdfcontroller.set(minPoolSize, maxPoolSize, 1800, 999999);
        this.topdfcontroller.create();
        this.topdfcontroller.addHandler(MediaHandlePdfModel.class, (Handler)new MediaCanvasToPdfHandler());
        ((Scheduler)Global.getWithoutNew(Scheduler.class)).addIntervalTask(Interval.shedule((Task)this, (int)60000));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long postMediaHandleModelRequest(MediaHandleModel obj) {
        Map<Long, MediaHandleModel> map = this.savingModelMap;
        synchronized (map) {
            boolean posted;
            if (obj.getHandleId() <= 0L) {
                obj.setHandleId(Ids.longId());
            }
            try {
                MediaCanvas canvas = (MediaCanvas)((ZTable)ORM.get(ZTable.class)).item(MediaCanvas.class, new Object[]{obj.getMediaId()});
                if (canvas != null) {
                    obj.setDefaultIsEdit(canvas.getIsEdit());
                }
            }
            catch (Exception e1) {
                log.error((Object)e1.getMessage(), (Throwable)e1, new Object[0]);
            }
            if (posted = this.savecontroller.execute((Object)obj)) {
                this.savingModelMap.put(obj.getHandleId(), obj);
                obj.setHandleStatus(0);
                Updater updater = new Updater();
                updater.addMust("mediaId", (Object)obj.getMediaId());
                updater.addMustNotEqual("isEdit", (Object)1);
                updater.addField("isEdit", (Object)2);
                try {
                    ((ZTable)ORM.get(ZTable.class)).update(MediaCanvas.class, updater);
                }
                catch (Exception e) {
                    log.error((Object)"\u6a21\u7248[%s]\u6210\u529f\u6295\u9012\u5230\u4fdd\u5b58\u961f\u5217\u5355\u6807\u8bb0\u4fdd\u5b58\u4e2d\u5f02\u5e38", (Throwable)e, new Object[]{obj.getMediaId()});
                }
            }
            return posted ? obj.getHandleId() : 0L;
        }
    }

    public long postMediaHandleModelRequest(long mediaId, String mediaJson, String paramJson) {
        if (mediaId <= 0L) {
            return 0L;
        }
        if (Validates.isEmptyBlank((String)mediaJson)) {
            return 0L;
        }
        MediaHandleModel obj = new MediaHandleModel(mediaJson, mediaId, paramJson);
        return this.postMediaHandleModelRequest(obj);
    }

    public long postMediaHandleModelRequest(long mediaId, String mediaJson, String paramJson, boolean isCreateMediaImage, boolean isDoImgCallback) {
        if (mediaId <= 0L) {
            return 0L;
        }
        if (Validates.isEmptyBlank((String)mediaJson)) {
            return 0L;
        }
        MediaHandleModel obj = new MediaHandleModel(mediaJson, mediaId, paramJson, isCreateMediaImage, isDoImgCallback);
        return this.postMediaHandleModelRequest(obj);
    }

    public MediaHandleModel getMediaHandleModel(long handleId) {
        return this.savingModelMap.containsKey(handleId) ? this.savingModelMap.get(handleId) : null;
    }

    public boolean removeMediaHandleModel(long handleId) {
        if (this.savingModelMap.containsKey(handleId)) {
            this.savingModelMap.remove(handleId);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long postMediaHandlePdfModelRequest(MediaHandlePdfModel obj) {
        Map<Long, MediaHandlePdfModel> map = this.toPdfModelMap;
        synchronized (map) {
            MediaHandlePdfModel m;
            if (this.toPdfModelMap.containsKey(obj.getMediaId()) && ((m = this.toPdfModelMap.get(obj.getMediaId())).getHandleStatus() == 0 || m.getHandleStatus() == 1)) {
                return m.getHandleId();
            }
            boolean falg = this.topdfcontroller.execute((Object)obj);
            if (falg) {
                if (obj.getHandleId() <= 0L) {
                    obj.setHandleId(Ids.longId());
                }
                obj.setHandleId(obj.getMediaId());
                this.toPdfModelMap.put(obj.getHandleId(), obj);
                obj.setHandleStatus(0);
                Updater updater = new Updater();
                updater.addMust("mediaId", (Object)obj.getMediaId());
                updater.addMustNotEqual("isEdit", (Object)1);
                updater.addField("isEdit", (Object)3);
                try {
                    ((ZTable)ORM.get(ZTable.class)).update(MediaCanvas.class, updater);
                }
                catch (Exception e) {
                    log.error((Object)"\u6a21\u7248[%s]\u6210\u529f\u6295\u9012\u5230\u4fdd\u5b58\u961f\u5217\u5355\u6807\u8bb0\u4fdd\u5b58\u4e2d\u5f02\u5e38", (Throwable)e, new Object[]{obj.getMediaId()});
                }
            }
            return obj.getHandleId();
        }
    }

    public MediaHandlePdfModel getMediaHandlePdfModel(long pdfHandleId) {
        return this.toPdfModelMap.containsKey(pdfHandleId) ? this.toPdfModelMap.get(pdfHandleId) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeMediaHandlePdfModel(long pdfHandleId) {
        Map<Long, MediaHandlePdfModel> map = this.toPdfModelMap;
        synchronized (map) {
            MediaHandlePdfModel m;
            if (this.toPdfModelMap.containsKey(pdfHandleId) && (m = this.toPdfModelMap.remove(pdfHandleId)) != null && m.getHandleStatus() == 2) {
                this.pdfSuccMap.put(pdfHandleId, m);
            }
            return true;
        }
    }

    public MediaHandlePdfModel getHandlePdfFinish(long pdfHandleId) {
        return this.pdfSuccMap.get(pdfHandleId);
    }

    public void execute() {
        int sleepNum = 0;
        int runNum = 0;
        for (Threader threader : this.topdfcontroller.getThreaderList()) {
            if (threader.isActive()) {
                ++runNum;
                continue;
            }
            ++sleepNum;
        }
        log.info((Object)"\u5f53\u524dpdf\u751f\u6210\u7ebf\u7a0b\u6c60:\u8fd0\u884c\u4e2d[%s],\u4f11\u7720[%s],\u7b49\u5f85\u961f\u5217[%s]", new Object[]{runNum, sleepNum, this.topdfcontroller.getQueue().size()});
        int second = 300;
        long currTime = System.currentTimeMillis();
        ArrayList<Long> elemIds = new ArrayList<Long>();
        for (MediaHandlePdfModel elem : this.pdfSuccMap.values()) {
            long finishTime = elem.getFinishTime();
            if (currTime - finishTime <= (long)(second * 1000)) continue;
            elemIds.add(elem.getHandleId());
        }
        Iterator iterator = elemIds.iterator();
        while (iterator.hasNext()) {
            long elemId = (Long)iterator.next();
            MediaHandlePdfModel elem = this.pdfSuccMap.remove(elemId);
            log.info((Object)"\u5df2\u751f\u6210PDF \u7684 media mediaId[%s] pdfHandleId[%s],\u8d85\u51fa\u7cfb\u7edf\u4fdd\u7559\u65f6\u957f[%s]\u79d2\uff0c\u7cfb\u7edf\u81ea\u52a8\u5220\u9664", new Object[]{elem.getMediaId(), elem.getHandleId(), second});
        }
    }
}

