/*
 * Decompiled with CFR 0.152.
 */
package com.zhiqim.media.service.cdr;

import com.jacob.com.Dispatch;
import com.jacob.com.Variant;
import com.zhiqim.media.service.cdr.Application;
import com.zhiqim.media.service.cdr.CdrDispatch;
import com.zhiqim.media.service.cdr.Segment;
import com.zhiqim.media.service.cdr.Shape;
import java.util.ArrayList;
import java.util.List;

public class SubPath
extends CdrDispatch {
    private double positionX;
    private double positionY;
    private boolean Closed;
    private List<Segment> segmentList = new ArrayList<Segment>();
    private Shape shape;

    public SubPath(Application application, Dispatch dispatch, Shape shape) {
        super(application, dispatch);
        this.shape = shape;
        this.parse();
    }

    @Override
    protected void parseComposite() {
        Dispatch segments = Dispatch.get((Dispatch)this.dispatch, (String)"Segments").toDispatch();
        int count = Dispatch.get((Dispatch)segments, (String)"Count").getInt();
        int i = 1;
        while (i <= count) {
            Dispatch dispatchSegment = Dispatch.invoke((Dispatch)segments, (String)"Item", (int)2, (Object[])new Object[]{new Variant(i)}, (int[])new int[1]).toDispatch();
            Segment segment = new Segment(this.application, dispatchSegment, this.shape);
            this.segmentList.add(segment);
            ++i;
        }
    }

    public double getPositionX() {
        return this.positionX;
    }

    public void setPositionX(double positionX) {
        this.positionX = positionX;
    }

    public double getPositionY() {
        return this.positionY;
    }

    public void setPositionY(double positionY) {
        this.positionY = positionY;
    }

    public boolean isClosed() {
        return this.Closed;
    }

    public void setClosed(boolean closed) {
        this.Closed = closed;
    }

    public List<Segment> getSegmentList() {
        return this.segmentList;
    }

    public void setSegmentList(List<Segment> segmentList) {
        this.segmentList = segmentList;
    }

    public String toSvg() {
        StringBuffer strb = new StringBuffer();
        int i = 0;
        while (i < this.segmentList.size()) {
            Segment segment = this.segmentList.get(i);
            if (i == 0) {
                double px = this.application.getDocument().getRealX(this.shape, segment.getStartNode().getPositionX()) - this.application.getDocument().getRealX(this.shape, this.shape.getLeftX());
                double py = this.application.getDocument().getRealY(this.shape, -segment.getStartNode().getPositionY()) - this.application.getDocument().getRealY(this.shape, -this.shape.getTopY());
                strb.append("M").append(px).append(",").append(py).append(" ");
            }
            strb.append(segment.toSvg());
            ++i;
        }
        if (this.isClosed()) {
            strb.append("Z ");
        }
        return strb.toString();
    }
}

