/*
 * Decompiled with CFR 0.152.
 */
package com.zhiqim.media.service.cdr;

import com.jacob.com.Dispatch;
import com.jacob.com.Variant;
import com.zhiqim.media.service.cdr.Application;
import java.lang.reflect.Field;

public abstract class CdrDispatch {
    protected Application application;
    protected Dispatch dispatch;

    public CdrDispatch(Application application, Dispatch dispatch) {
        this.application = application;
        this.dispatch = dispatch;
    }

    public void parse() {
        Field[] fields;
        Class<?> cls = this.getClass();
        Field[] fieldArray = fields = cls.getDeclaredFields();
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            String name = field.getName();
            String cname = this.upperCaseFirstWord(name);
            Class<?> type = field.getType();
            field.setAccessible(true);
            try {
                if (type == Boolean.TYPE || type == Boolean.class) {
                    field.setBoolean(this, Dispatch.get((Dispatch)this.dispatch, (String)cname).getBoolean());
                } else if (type == Short.TYPE || type == Short.class) {
                    field.setShort(this, Dispatch.get((Dispatch)this.dispatch, (String)cname).getShort());
                } else if (type == Integer.TYPE || type == Integer.class) {
                    field.setInt(this, Dispatch.get((Dispatch)this.dispatch, (String)cname).getInt());
                } else if (type == Long.TYPE || type == Long.class) {
                    field.setLong(this, Dispatch.get((Dispatch)this.dispatch, (String)cname).getLong());
                } else if (type == Float.TYPE || type == Float.class) {
                    field.setFloat(this, Dispatch.get((Dispatch)this.dispatch, (String)cname).getFloat());
                } else if (type == Double.TYPE || type == Double.class) {
                    field.setDouble(this, Dispatch.get((Dispatch)this.dispatch, (String)cname).getDouble());
                } else if (type == String.class) {
                    field.set(this, Dispatch.get((Dispatch)this.dispatch, (String)cname).getString());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++n2;
        }
        this.parseComposite();
    }

    protected abstract void parseComposite();

    private String upperCaseFirstWord(String name) {
        String first = name.substring(0, 1);
        first = first.toUpperCase();
        return String.valueOf(first) + name.substring(1);
    }

    public Application getApplication() {
        return this.application;
    }

    public void safeRelease() {
        this.dispatch.safeRelease();
    }

    public Dispatch getDispatch() {
        return this.dispatch;
    }

    public boolean getBoolean(String fieldName) {
        return Dispatch.get((Dispatch)this.dispatch, (String)fieldName).getBoolean();
    }

    public short getShort(String fieldName) {
        return Dispatch.get((Dispatch)this.dispatch, (String)fieldName).getShort();
    }

    public int getInt(String fieldName) {
        return Dispatch.get((Dispatch)this.dispatch, (String)fieldName).getInt();
    }

    public long getLong(String fieldName) {
        return Dispatch.get((Dispatch)this.dispatch, (String)fieldName).getLong();
    }

    public float getFloat(String fieldName) {
        return Dispatch.get((Dispatch)this.dispatch, (String)fieldName).getFloat();
    }

    public double getDouble(String fieldName) {
        return Dispatch.get((Dispatch)this.dispatch, (String)fieldName).getDouble();
    }

    public String getString(String fieldName) {
        return Dispatch.get((Dispatch)this.dispatch, (String)fieldName).getString();
    }

    public Variant getNothingVariant() {
        Variant nothing = new Variant();
        nothing.putNothing();
        return nothing;
    }

    public void setField(String field, Object val) {
        Dispatch.put((Dispatch)this.dispatch, (String)field, (Object)val);
    }
}

