/*
 * Decompiled with CFR 0.152.
 */
package com.zhiqim.media.service.cdr;

import com.jacob.activeX.ActiveXComponent;
import com.jacob.com.Dispatch;
import com.jacob.com.Variant;
import com.zhiqim.media.service.cdr.Document;
import org.zhiqim.kernel.util.Files;
import org.zhiqim.kernel.util.Strings;

public class Application {
    public static final String ID = "CorelDRAW.Application.14";
    private ActiveXComponent activeXcom;
    private Document document = null;
    private String filePath = null;
    private String destDir = null;

    public void start() {
        if (this.activeXcom == null) {
            this.activeXcom = ActiveXComponent.connectToActiveInstance((String)ID);
        }
        if (this.activeXcom == null) {
            this.activeXcom = ActiveXComponent.createNewInstance((String)ID);
        }
        this.activeXcom.setProperty("Visible", new Variant(false));
    }

    public Document openDocument(String filePath) {
        this.filePath = filePath;
        if (this.activeXcom == null) {
            this.start();
        }
        Dispatch dispatchDoc = Dispatch.invoke((Dispatch)this.activeXcom, (String)"OpenDocument", (int)1, (Object[])new Object[]{filePath, new Variant(0)}, (int[])new int[1]).toDispatch();
        this.document = new Document(this, dispatchDoc);
        return this.document;
    }

    public Document getDocument() {
        return this.document;
    }

    public Dispatch createJpgExportOptions() {
        Dispatch exportOptions = Dispatch.call((Dispatch)this.activeXcom.getObject(), (String)"CreateStructExportOptions").getDispatch();
        Dispatch.put((Dispatch)exportOptions, (String)"ResolutionX", (Object)300);
        Dispatch.put((Dispatch)exportOptions, (String)"ResolutionY", (Object)300);
        Dispatch.put((Dispatch)exportOptions, (String)"ImageType", (Object)4);
        Dispatch.put((Dispatch)exportOptions, (String)"Transparent", (Object)false);
        Dispatch.put((Dispatch)exportOptions, (String)"UseColorProfile", (Object)true);
        Dispatch.put((Dispatch)exportOptions, (String)"Dithered", (Object)false);
        Dispatch.put((Dispatch)exportOptions, (String)"MaintainLayers", (Object)false);
        Dispatch.put((Dispatch)exportOptions, (String)"AntiAliasingType", (Object)1);
        Dispatch.put((Dispatch)exportOptions, (String)"Compression", (Object)0);
        return exportOptions;
    }

    public Dispatch createPngExportOptions() {
        Dispatch exportOptions = Dispatch.call((Dispatch)this.activeXcom.getObject(), (String)"CreateStructExportOptions").getDispatch();
        Dispatch.put((Dispatch)exportOptions, (String)"ResolutionX", (Object)300);
        Dispatch.put((Dispatch)exportOptions, (String)"ResolutionY", (Object)300);
        Dispatch.put((Dispatch)exportOptions, (String)"ImageType", (Object)4);
        Dispatch.put((Dispatch)exportOptions, (String)"Transparent", (Object)true);
        Dispatch.put((Dispatch)exportOptions, (String)"UseColorProfile", (Object)true);
        Dispatch.put((Dispatch)exportOptions, (String)"Dithered", (Object)false);
        Dispatch.put((Dispatch)exportOptions, (String)"MaintainLayers", (Object)false);
        Dispatch.put((Dispatch)exportOptions, (String)"AntiAliasingType", (Object)1);
        Dispatch.put((Dispatch)exportOptions, (String)"Compression", (Object)0);
        return exportOptions;
    }

    public void quit() {
        this.activeXcom.invoke("Quit", new Variant[0]);
        this.activeXcom.safeRelease();
        this.activeXcom = null;
    }

    public ActiveXComponent getActiveXcom() {
        return this.activeXcom;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public String getFileName() {
        String name = Files.getFileName((String)this.filePath);
        int ind = name.indexOf(".");
        if (ind != -1) {
            return name.substring(0, ind);
        }
        return name;
    }

    public String getFileDestDir() {
        String dir = String.valueOf(Strings.addEndsWith((String)this.getDestDir(), (String)"/")) + Strings.addEndsWith((String)this.getFileName(), (String)"/");
        if (!Files.exists((String)dir)) {
            Files.mkDirectory((String)dir);
        }
        return dir;
    }

    public String getDestDir() {
        return this.destDir;
    }

    public void setDestDir(String destDir) {
        this.destDir = destDir;
    }
}

