/*
 * Decompiled with CFR 0.152.
 */
package com.zhiqim.media.manage.presenter;

import com.zhiqim.media.dbo.MediaBg;
import com.zhiqim.media.dbo.MediaCanvas;
import com.zhiqim.media.dbo.MediaMaterial;
import com.zhiqim.media.service.model.MediaCdrSvgModel;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.zhiqim.kernel.Global;
import org.zhiqim.kernel.annotation.AnAlias;
import org.zhiqim.kernel.util.Files;
import org.zhiqim.kernel.util.Ids;
import org.zhiqim.kernel.util.Streams;
import org.zhiqim.kernel.util.Strings;
import org.zhiqim.kernel.util.Zips;
import org.zhiqim.kernel.util.codes.Base64Decoder;
import org.zhiqim.orm.ORM;
import org.zhiqim.orm.ZTable;

@AnAlias(value={"MediaRmiPresenter"})
public class MediaRmiPresenter {
    public static void doImportSvg(String name, String bytes) throws Exception {
        String svgDir = Global.getString((String)"cdr", (String)"svgDir");
        File toDir = new File(svgDir);
        String filePath = String.valueOf(svgDir) + "/" + name + ".zip";
        byte[] tmp = Base64Decoder.decode((byte[])bytes.getBytes());
        Files.write((String)filePath, (byte[])tmp);
        File zip = new File(filePath);
        List fileList = Zips.unzip((File)zip, (File)toDir);
        File dir = new File(String.valueOf(Strings.addEndsWith((String)svgDir, (String)"/")) + name);
        long mediaId = Ids.longId();
        MediaCanvas canvas = null;
        ArrayList<MediaBg> bgList = new ArrayList<MediaBg>();
        ArrayList<MediaMaterial> mList = new ArrayList<MediaMaterial>();
        for (File file : fileList) {
            if (!Strings.endsWith((String)file.getName(), (String)".svg")) continue;
            String fileName = file.getName();
            int beginIndex = fileName.lastIndexOf("_") + 1;
            int endIndex = fileName.lastIndexOf(".");
            int bid = Integer.parseInt(fileName.substring(beginIndex, endIndex));
            String svgCode = Streams.getStringUTF8((InputStream)new FileInputStream(file));
            MediaCdrSvgModel cdrSvg = new MediaCdrSvgModel(dir.getCanonicalPath(), mediaId, bid, svgCode);
            cdrSvg.parse();
            canvas = cdrSvg.getCanvas();
            MediaBg bg = cdrSvg.createMediaBg(canvas.getWidth(), canvas.getHeight());
            bgList.add(bg);
            mList.addAll(cdrSvg.getMaterialList());
        }
        canvas.setMediaName(name);
        ((ZTable)ORM.get(ZTable.class)).insert((Object)canvas);
        ((ZTable)ORM.get(ZTable.class)).insertBatch(bgList);
        ((ZTable)ORM.get(ZTable.class)).insertBatch(mList);
        Files.deleteDirectory((File)dir);
        Files.deleteFile((String)filePath);
    }
}

