/*
 * Decompiled with CFR 0.152.
 */
package com.zhiqim.media.manage.action;

import com.zhiqim.media.dbo.MaterialCat;
import com.zhiqim.media.dbo.MaterialSvg;
import com.zhiqim.media.service.cache.MaterialCatCache;
import java.util.List;
import org.zhiqim.httpd.HttpRequest;
import org.zhiqim.httpd.context.extend.StdSwitchAction;
import org.zhiqim.httpd.validate.Validate;
import org.zhiqim.httpd.validate.ones.IsLen;
import org.zhiqim.httpd.validate.ones.IsNotEmpty;
import org.zhiqim.kernel.Global;
import org.zhiqim.kernel.util.Validates;
import org.zhiqim.orm.ORM;
import org.zhiqim.orm.ZTable;
import org.zhiqim.orm.dbo.Selector;

public class MaterialCatAction
extends StdSwitchAction {
    protected void validateId(HttpRequest request) {
        request.addValidate((Validate)new IsLen("catCode", "\u5b57\u7b26\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u4e14\u4e0d\u8d85\u8fc716\u4e2a\u5b57\u6bcd", 1, 16));
    }

    protected void validateForm(HttpRequest request) {
        request.addValidate((Validate)new IsNotEmpty("typeCode", "\u8bf7\u9009\u62e9\u7d20\u6750\u5206\u7c7b"));
        request.addValidate((Validate)new IsNotEmpty("catName", "\u8bf7\u8f93\u5165\u5206\u7c7b\u540d\u79f0"));
        request.addValidate((Validate)new IsNotEmpty("catSeq", "\u8bf7\u9009\u5206\u7c7b\u5e8f\u53f7"));
    }

    protected void list(HttpRequest request) throws Exception {
        List result = ((ZTable)ORM.get(ZTable.class)).list(MaterialCat.class, new Selector().addOrderbyAsc("catSeq"));
        request.setAttribute("result", (Object)result);
    }

    protected void add(HttpRequest request) throws Exception {
    }

    protected void modify(HttpRequest request) throws Exception {
        String catCode = request.getParameter("catCode");
        MaterialCat cat = (MaterialCat)((ZTable)ORM.get(ZTable.class)).item(MaterialCat.class, new Object[]{catCode});
        request.setAttribute("item", (Object)cat);
    }

    protected void insert(HttpRequest request) throws Exception {
        MaterialCat cat = (MaterialCat)request.getParameter(MaterialCat.class);
        if (((ZTable)ORM.get(ZTable.class)).count(MaterialCat.class, new Object[]{cat.getCatCode()}) > 0) {
            request.returnHistory("\u5206\u7c7b\u7f16\u7801\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165");
            return;
        }
        if (Validates.isNotEmpty((String)cat.getCatLabel())) {
            String catLabel = cat.getCatLabel().replace("\uff0c", ",");
            cat.setCatLabel(catLabel);
        }
        ((ZTable)ORM.get(ZTable.class)).insert((Object)cat);
        ((MaterialCatCache)Global.get(MaterialCatCache.class)).doRefresh();
    }

    protected void update(HttpRequest request) throws Exception {
        MaterialCat cat = (MaterialCat)request.getParameter(MaterialCat.class);
        if (Validates.isNotEmpty((String)cat.getCatLabel())) {
            String catLabel = cat.getCatLabel().replace("\uff0c", ",");
            cat.setCatLabel(catLabel);
        }
        ((ZTable)ORM.get(ZTable.class)).replace((Object)cat);
        ((MaterialCatCache)Global.get(MaterialCatCache.class)).doRefresh();
    }

    protected void delete(HttpRequest request) throws Exception {
        String catCode = request.getParameter("catCode");
        if (((ZTable)ORM.get(ZTable.class)).count(MaterialSvg.class, new Selector("catCode", (Object)catCode)) > 0) {
            request.returnHistory("\u8be5\u5206\u7c7b\u5df2\u88ab\u4f7f\u7528\uff0c\u4e0d\u5141\u8bb8\u5220\u9664");
            return;
        }
        ((ZTable)ORM.get(ZTable.class)).delete(MaterialCat.class, new Object[]{catCode});
        ((MaterialCatCache)Global.get(MaterialCatCache.class)).doRefresh();
    }
}

