/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.manager.presenter;

import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.regex.Pattern;
import org.zhiqim.httpd.HttpRequest;
import org.zhiqim.httpd.context.annotation.AnIntercept;
import org.zhiqim.httpd.validate.Validate;
import org.zhiqim.httpd.validate.ones.IsNotEmpty;
import org.zhiqim.httpd.validate.onex.IsUserCode;
import org.zhiqim.kernel.annotation.AnAlias;
import org.zhiqim.kernel.annotation.AnTransaction;
import org.zhiqim.kernel.logging.Log;
import org.zhiqim.kernel.logging.LogFactory;
import org.zhiqim.kernel.paging.PageResult;
import org.zhiqim.kernel.util.Arrays;
import org.zhiqim.kernel.util.DateTimes;
import org.zhiqim.kernel.util.Lists;
import org.zhiqim.kernel.util.Randoms;
import org.zhiqim.kernel.util.Validates;
import org.zhiqim.manager.ZmrBootstrap;
import org.zhiqim.manager.ZmrPassworder;
import org.zhiqim.manager.ZmrSessionUser;
import org.zhiqim.manager.dao.ZmrOperatorDao;
import org.zhiqim.manager.dbo.ZmrAvatar;
import org.zhiqim.manager.dbo.ZmrDept;
import org.zhiqim.manager.dbo.ZmrOperator;
import org.zhiqim.manager.dbo.ZmrRole;
import org.zhiqim.manager.presenter.WorkWechatPresenter;
import org.zhiqim.orm.dbo.Selector;
import org.zhiqim.orm.dbo.Updater;

@AnAlias(value={"ZmrOperatorPresenter"})
@AnIntercept(value={"chkZmrLogin"})
public class ZmrOperatorPresenter {
    private static final Log log = LogFactory.getLog(ZmrOperatorPresenter.class);

    protected static void validateForm(HttpRequest request) {
        request.addValidate((Validate)new IsUserCode("operatorCode", "\u64cd\u4f5c\u5458\u7f16\u7801\u75312-16\u4f4d\u5b57\u6bcd\u6570\u5b57\u6c49\u5b57\u5f00\u5934\uff0c\u5b57\u6bcd\u6c49\u5b57\u6570\u5b57\u7279\u6b8a\u7b26\u53f7\u7ec4\u6210"));
        request.addValidate((Validate)new IsNotEmpty("operatorName", "\u64cd\u4f5c\u5458\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a"));
        request.addValidate((Validate)new IsNotEmpty("operatorStatus", "\u64cd\u4f5c\u5458\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a"));
        request.addValidate((Validate)new IsNotEmpty("operatorMobile", "\u64cd\u4f5c\u5458\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a"));
    }

    public static void doValidatePassword(HttpRequest request, String operatorPass) {
        if (Validates.isEmptyBlank((String)operatorPass)) {
            request.setResponseError("\u5bc6\u7801\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u767d");
            return;
        }
        ZmrSessionUser sessionUser = (ZmrSessionUser)request.getSessionUser(ZmrSessionUser.class);
        if (!ZmrOperatorDao.validatePassword(request, sessionUser.getOperator(), operatorPass)) {
            request.setResponseError("\u5bc6\u7801\u4e0d\u6b63\u786e");
        }
    }

    public static void doAddOperatorDepts(HttpRequest request) throws Exception {
        long[] deptIdArr;
        request.addValidate((Validate)new IsNotEmpty("operatorCode", "\u8bf7\u9009\u62e9\u64cd\u4f5c\u5458"));
        request.addValidate((Validate)new IsNotEmpty("deptIds", "\u8bf7\u9009\u62e9\u4e00\u4e2a\u90e8\u95e8"));
        if (!request.chkValidate()) {
            request.setResponseError(request.getAlertMsg());
            return;
        }
        String operatorCode = request.getParameter("operatorCode");
        ZmrOperator operator = (ZmrOperator)ZmrBootstrap.tableOpr(request).item(ZmrOperator.class, new Object[]{operatorCode});
        if (operator == null) {
            request.returnHistory("\u60a8\u9009\u62e9\u7684\u64cd\u4f5c\u5458\u4e0d\u5b58\u5728\uff0c\u8bf7\u9009\u62e9\u4e00\u4e2a\u6709\u6548\u7684\u64cd\u4f5c\u5458");
            return;
        }
        long[] lArray = deptIdArr = Arrays.toLongArray((String)request.getParameter("deptIds"));
        int n = deptIdArr.length;
        int n2 = 0;
        while (n2 < n) {
            long deptId = lArray[n2];
            ZmrDept dept = (ZmrDept)ZmrBootstrap.table(request).item(ZmrDept.class, new Object[]{deptId});
            if (operator != null) {
                if (Validates.isEmpty((String)operator.getOperatorDept())) {
                    operator.setOperatorDept("" + deptId);
                } else {
                    operator.setOperatorDept(String.valueOf(operator.getOperatorDept()) + "," + deptId);
                }
                String operatorDeptAll = operator.getOperatorDeptAll();
                operatorDeptAll = Validates.isEmpty((String)operatorDeptAll) ? dept.getDeptParentAll() : String.valueOf(operatorDeptAll) + "," + dept.getDeptParentAll();
                operatorDeptAll = String.valueOf(operatorDeptAll) + "," + operator.getOperatorDept();
                operator.setOperatorDeptAll(operatorDeptAll);
            }
            ++n2;
        }
        Updater updater = new Updater();
        updater.addField("operatorDept", (Object)operator.getOperatorDept());
        updater.addField("operatorDeptAll", (Object)Arrays.toFilterSameStr((String)operator.getOperatorDeptAll()));
        updater.addMust("operatorCode", (Object)operatorCode);
        ZmrBootstrap.tableOpr(request).update(ZmrOperator.class, updater);
    }

    public static void doDeleteOperatorDept(HttpRequest request) throws Exception {
        request.addValidate((Validate)new IsNotEmpty("operatorCode", "\u8bf7\u9009\u62e9\u4e00\u4e2a\u64cd\u4f5c\u5458"));
        request.addValidate((Validate)new IsNotEmpty("deptId", "\u8bf7\u9009\u62e9\u4e00\u4e2a\u90e8\u95e8"));
        if (!request.chkValidate()) {
            request.setResponseError(request.getAlertMsg());
            return;
        }
        String operatorCode = request.getParameter("operatorCode");
        ZmrOperator operator = (ZmrOperator)ZmrBootstrap.tableOpr(request).item(ZmrOperator.class, new Object[]{operatorCode});
        if (operator == null) {
            request.setResponseError("\u8bf7\u9009\u62e9\u4e00\u4e2a\u6709\u6548\u7684\u64cd\u4f5c\u5458");
            return;
        }
        long deptId = request.getParameterLong("deptId");
        String operatorDept = operator.getOperatorDept();
        List operatorDeptList = Lists.toLongList((String)operatorDept);
        operatorDeptList.remove(deptId);
        operatorDept = Lists.toString((List)operatorDeptList);
        String operatorDeptAll = null;
        Iterator iterator = operatorDeptList.iterator();
        while (iterator.hasNext()) {
            long oprDeptId = (Long)iterator.next();
            ZmrDept dept = (ZmrDept)ZmrBootstrap.table(request).item(ZmrDept.class, new Object[]{oprDeptId});
            if (dept == null) continue;
            operatorDeptAll = operatorDeptAll == null ? dept.getDeptParentAll() : String.valueOf(operatorDeptAll) + "," + dept.getDeptParentAll();
            operatorDeptAll = String.valueOf(operatorDeptAll) + "," + oprDeptId;
        }
        operatorDeptAll = Arrays.toFilterSameStr(operatorDeptAll);
        Updater updater = new Updater();
        updater.addField("operatorDept", (Object)operatorDept);
        updater.addField("operatorDeptAll", (Object)operatorDeptAll);
        updater.addMust("operatorCode", (Object)operatorCode);
        ZmrBootstrap.tableOpr(request).update(ZmrOperator.class, updater);
    }

    public static void doAddOperatorRoles(HttpRequest request) throws Exception {
        String[] roleIdArr;
        request.addValidate((Validate)new IsNotEmpty("operatorCode", "\u8bf7\u9009\u62e9\u64cd\u4f5c\u5458"));
        request.addValidate((Validate)new IsNotEmpty("roleIds", "\u8bf7\u9009\u62e9\u4e00\u4e2a\u89d2\u8272"));
        if (!request.chkValidate()) {
            request.setResponseError(request.getAlertMsg());
            return;
        }
        String operatorCode = request.getParameter("operatorCode");
        ZmrOperator operator = (ZmrOperator)ZmrBootstrap.tableOpr(request).item(ZmrOperator.class, new Object[]{operatorCode});
        if (operator == null) {
            request.returnHistory("\u60a8\u9009\u62e9\u7684\u64cd\u4f5c\u5458\u4e0d\u5b58\u5728\uff0c\u8bf7\u9009\u62e9\u4e00\u4e2a\u6709\u6548\u7684\u64cd\u4f5c\u5458");
            return;
        }
        String[] stringArray = roleIdArr = Arrays.toStringArray((String)request.getParameter("roleIds"));
        int n = roleIdArr.length;
        int n2 = 0;
        while (n2 < n) {
            String roleId = stringArray[n2];
            if (Validates.isEmpty((String)operator.getOperatorRole())) {
                operator.setOperatorRole(roleId);
            } else if (!operator.getOperatorRole().contains(roleId)) {
                operator.setOperatorRole(String.valueOf(operator.getOperatorRole()) + "," + roleId);
            }
            ++n2;
        }
        Updater updater = new Updater();
        updater.addField("operatorRole", (Object)operator.getOperatorRole());
        updater.addMust("operatorCode", (Object)operatorCode);
        ZmrBootstrap.tableOpr(request).update(ZmrOperator.class, updater);
    }

    public static void doDeleteOperatorRole(HttpRequest request) throws Exception {
        request.addValidate((Validate)new IsNotEmpty("operatorCode", "\u8bf7\u9009\u62e9\u4e00\u4e2a\u64cd\u4f5c\u5458"));
        request.addValidate((Validate)new IsNotEmpty("roleId", "\u8bf7\u9009\u62e9\u4e00\u4e2a\u89d2\u8272"));
        if (!request.chkValidate()) {
            request.setResponseError(request.getAlertMsg());
            return;
        }
        String operatorCode = request.getParameter("operatorCode");
        ZmrOperator operator = (ZmrOperator)ZmrBootstrap.tableOpr(request).item(ZmrOperator.class, new Object[]{operatorCode});
        if (operator == null) {
            request.setResponseError("\u8bf7\u9009\u62e9\u4e00\u4e2a\u6709\u6548\u7684\u64cd\u4f5c\u5458");
            return;
        }
        long roleId = request.getParameterLong("roleId");
        String operatorRole = operator.getOperatorRole();
        List operatorRoleList = Lists.toLongList((String)operatorRole);
        operatorRoleList.remove(roleId);
        operatorRole = Lists.toString((List)operatorRoleList);
        Updater updater = new Updater();
        updater.addField("operatorRole", (Object)operatorRole);
        updater.addMust("operatorCode", (Object)operatorCode);
        ZmrBootstrap.tableOpr(request).update(ZmrOperator.class, updater);
    }

    public static void doAddRoleOperator(HttpRequest request) throws Exception {
        String[] operatorCodeArr;
        request.addValidate((Validate)new IsNotEmpty("roleId", "\u8bf7\u9009\u62e9\u4e00\u4e2a\u89d2\u8272"));
        request.addValidate((Validate)new IsNotEmpty("operatorCodes", "\u8bf7\u9009\u62e9\u64cd\u4f5c\u5458"));
        if (!request.chkValidate()) {
            request.setResponseError(request.getAlertMsg());
            return;
        }
        long roleId = request.getParameterLong("roleId");
        ZmrRole role = (ZmrRole)ZmrBootstrap.table(request).item(ZmrRole.class, new Object[]{roleId});
        if (role == null) {
            request.returnHistory("\u60a8\u9009\u62e9\u7684\u89d2\u8272\u4e0d\u5b58\u5728\uff0c\u8bf7\u9009\u62e9\u4e00\u4e2a\u6709\u6548\u7684\u89d2\u8272");
            return;
        }
        String[] stringArray = operatorCodeArr = Arrays.toStringArray((String)request.getParameter("operatorCodes"));
        int n = operatorCodeArr.length;
        int n2 = 0;
        while (n2 < n) {
            String operatorCode = stringArray[n2];
            ZmrOperator operator = (ZmrOperator)ZmrBootstrap.tableOpr(request).item(ZmrOperator.class, new Object[]{operatorCode});
            if (operator != null) {
                String operatorRole = operator.getOperatorRole();
                operatorRole = Validates.isEmpty((String)operatorRole) ? "" + roleId : String.valueOf(operatorRole) + "," + roleId;
                Updater updater = new Updater();
                updater.addField("operatorRole", (Object)operatorRole);
                updater.addMust("operatorCode", (Object)operatorCode);
                ZmrBootstrap.tableOpr(request).update(ZmrOperator.class, updater);
            }
            ++n2;
        }
    }

    public static void RemoveOnlineOperator(HttpRequest request, String sessionId) throws Exception {
        request.getContext().getSessionManager().invalidateSession(sessionId);
    }

    public static void setOrgId(HttpRequest request, long orgId) throws Exception {
        ZmrSessionUser sessionUser = (ZmrSessionUser)request.getSessionUser(ZmrSessionUser.class);
        sessionUser.setValue("orgId", orgId);
    }

    @AnTransaction
    public static void insert(HttpRequest request) throws Exception {
        try {
            boolean isMatch;
            ZmrOperatorPresenter.validateForm(request);
            if (!request.chkValidate()) {
                request.setResponseError(request.getAlertMsg());
                return;
            }
            String dateTime = DateTimes.getDateTimeString();
            long orgId = ((ZmrSessionUser)request.getSessionUser(ZmrSessionUser.class)).getSelectedOrgId();
            String operatorCode = request.getParameter("operatorCode");
            String operatorPass = request.getParameter("operatorPass");
            int operatorStatus = request.getParameterInt("operatorStatus");
            int operatorType = request.getParameterInt("operatorType", 2);
            String operatorName = request.getParameter("operatorName");
            String operatorIp = request.getParameter("operatorIp");
            String operatorMobile = request.getParameter("operatorMobile");
            String operatorWangwang = request.getParameter("operatorWangwang", "");
            String operatorWxcode = request.getParameter("operatorWxcode");
            if (Validates.isNotEmpty((String)operatorMobile) && !(isMatch = Pattern.matches("^0?(13|14|15|16|17|18|19)[0-9]{9}$", operatorMobile))) {
                request.setResponseError("\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u624b\u673a\u53f7");
                return;
            }
            if (ZmrBootstrap.tableOpr(request).count(ZmrOperator.class, new Object[]{operatorCode}) > 0) {
                request.setResponseError("\u8be5\u64cd\u4f5c\u5458\u7f16\u7801\u5df2\u7ecf\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165");
                return;
            }
            if (!Validates.isUserPass((String)operatorPass)) {
                request.setResponseError("\u8bf7\u8f93\u51656-16\u4f4d\u64cd\u4f5c\u5458\u5bc6\u7801\uff08\u5927\u5c0f\u5199\u5b57\u6bcd\u6570\u5b57\u548c\u7279\u6b8a\u5b57\u7b26\u5fc5\u987b\u56db\u9009\u4e09\uff09");
                return;
            }
            if (operatorPass.toLowerCase().contains("yangcai")) {
                request.setResponseError("\u5bc6\u7801\u4e2d\u4e0d\u5141\u8bb8\u5305\u542byangcai");
                return;
            }
            if (Validates.isEmpty((String)operatorWxcode)) {
                request.setResponseError("\u8bf7\u8f93\u5165\u4e2a\u4eba\u5fae\u4fe1\u8d26\u53f7");
                return;
            }
            String accessToken = WorkWechatPresenter.doGetWorkWechatAccessToken();
            String wkwechatAccount = WorkWechatPresenter.getUserIdByPhoneNumber(accessToken, operatorMobile);
            long operatorAvatar = 0L;
            PageResult result = ZmrBootstrap.table(request).page(ZmrAvatar.class, 1, 10, new Selector("avatarId", "avatarType", (Object)0));
            if (result.size() > 0) {
                int ind = new Random().nextInt(result.size());
                operatorAvatar = ((ZmrAvatar)result.list().get(ind)).getAvatarId();
            }
            ZmrPassworder passworder = ((ZmrBootstrap)request.getContextAttribute(ZmrBootstrap.class)).getPassworder();
            String operatorPassSalt = Randoms.lettersDigitsSecure((int)64);
            operatorPass = passworder.encode(operatorCode, operatorPass, operatorPassSalt);
            ZmrOperator operator = new ZmrOperator();
            operator.setOrgId(orgId);
            operator.setOperatorCode(operatorCode);
            operator.setOperatorPass(operatorPass);
            operator.setOperatorPassSalt(operatorPassSalt);
            operator.setOperatorStatus(operatorStatus);
            operator.setOperatorType(operatorType);
            operator.setOperatorName(operatorName);
            operator.setOperatorIp(operatorIp);
            operator.setOperatorAvatar(operatorAvatar);
            operator.setOperatorMobile(operatorMobile);
            operator.setOperatorCreated(dateTime);
            operator.setOperatorModified(dateTime);
            operator.setOperatorWangwang(operatorWangwang);
            operator.setWkwechatAccount(wkwechatAccount);
            operator.setOperatorWxcode(operatorWxcode);
            operator.setInitialPassword(operatorPass);
            ZmrBootstrap.table(request).insert((Object)operator);
            request.setAttribute("operator", (Object)operator);
        }
        catch (Exception e) {
            log.error((Object)("\u6dfb\u52a0\u64cd\u4f5c\u5458\u5f02\u5e38\uff1a" + e.getMessage()), (Throwable)e, new Object[0]);
            request.setResponseError("\u6dfb\u52a0\u64cd\u4f5c\u5458\u5f02\u5e38\uff1a" + e.getMessage());
            return;
        }
    }
}

