/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.manager.dao;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.zhiqim.httpd.HttpRequest;
import org.zhiqim.httpd.HttpSessionUser;
import org.zhiqim.kernel.annotation.AnAlias;
import org.zhiqim.kernel.json.Jsons;
import org.zhiqim.kernel.util.Asserts;
import org.zhiqim.kernel.util.Lists;
import org.zhiqim.kernel.util.Validates;
import org.zhiqim.manager.ZmrBootstrap;
import org.zhiqim.manager.ZmrPassworder;
import org.zhiqim.manager.ZmrSessionUser;
import org.zhiqim.manager.dao.ZmrOrgDao;
import org.zhiqim.manager.dao.ZmrParamDao;
import org.zhiqim.manager.dbo.ZmrDeptRule;
import org.zhiqim.manager.dbo.ZmrMenu;
import org.zhiqim.manager.dbo.ZmrOperator;
import org.zhiqim.manager.dbo.ZmrOperatorRule;
import org.zhiqim.manager.dbo.ZmrOrgRule;
import org.zhiqim.manager.dbo.ZmrRoleRule;
import org.zhiqim.orm.dbo.Selector;
import org.zhiqim.orm.dbo.Updater;

@AnAlias(value={"ZmrOperatorDao"})
public class ZmrOperatorDao {
    public static boolean validateSecret(HttpRequest request, ZmrOperator operator, String operatorPass) {
        Asserts.as((String)(operator != null ? null : "\u64cd\u4f5c\u5458\u5bf9\u8c61\u4e0d\u80fd\u4e3anull"));
        Asserts.as((String)(!Validates.isEmptyBlank((String)operatorPass) ? null : "\u64cd\u4f5c\u5458\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a\u767d"));
        ZmrPassworder passworder = ((ZmrBootstrap)request.getContextAttribute(ZmrBootstrap.class)).getPassworder();
        String encodePass = passworder.encode(operator.getOperatorCode(), operatorPass, operator.getOperatorPassSalt());
        return encodePass.equals(operator.getOperatorPass());
    }

    public static boolean validatePassword(HttpRequest request, ZmrOperator operator, String operatorPass) {
        Asserts.as((String)(operator != null ? null : "\u64cd\u4f5c\u5458\u5bf9\u8c61\u4e0d\u80fd\u4e3anull"));
        Asserts.as((String)(!Validates.isEmptyBlank((String)operatorPass) ? null : "\u64cd\u4f5c\u5458\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a\u767d"));
        ZmrPassworder passworder = ((ZmrBootstrap)request.getContextAttribute(ZmrBootstrap.class)).getPassworder();
        String encodePass = passworder.encode(operator.getOperatorCode(), operatorPass, operator.getOperatorPassSalt());
        return encodePass.equalsIgnoreCase(operator.getOperatorPass());
    }

    public static boolean validatePassword(HttpRequest request, String operatorCode, String operatorPass) throws Exception {
        Asserts.as((String)(!Validates.isEmptyBlank((String)operatorCode) ? null : "\u64cd\u4f5c\u5458\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u767d"));
        Asserts.as((String)(!Validates.isEmptyBlank((String)operatorPass) ? null : "\u64cd\u4f5c\u5458\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a\u767d"));
        ZmrOperator operator = (ZmrOperator)ZmrBootstrap.tableOpr(request).item(ZmrOperator.class, new Object[]{operatorCode});
        if (operator == null) {
            return false;
        }
        return ZmrOperatorDao.validatePassword(request, operator, operatorPass);
    }

    public static boolean hasMenuRule(HttpRequest request, String operatorCode, String menuUrl) throws Exception {
        Asserts.as((String)(!Validates.isEmptyBlank((String)operatorCode) ? null : "\u64cd\u4f5c\u5458\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u767d"));
        Asserts.as((String)(!Validates.isEmptyBlank((String)menuUrl) ? null : "\u83dc\u5355URL\u4e0d\u80fd\u4e3a\u7a7a\u767d"));
        List<ZmrMenu> menuList = ZmrOperatorDao.getOperatorMenuList(request, operatorCode);
        for (ZmrMenu menu : menuList) {
            if (!menuUrl.equals(menu.getMenuUrl())) continue;
            return true;
        }
        return false;
    }

    public static boolean hasMenuRule(HttpRequest request, ZmrOperator operator, String menuUrl) throws Exception {
        Asserts.as((String)(operator != null ? null : "\u64cd\u4f5c\u5458\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u767d"));
        Asserts.as((String)(!Validates.isEmptyBlank((String)menuUrl) ? null : "\u83dc\u5355URL\u4e0d\u80fd\u4e3a\u7a7a\u767d"));
        List<ZmrMenu> menuList = ZmrOperatorDao.getOperatorMenuList(request, operator);
        for (ZmrMenu menu : menuList) {
            if (!menuUrl.equals(menu.getMenuUrl())) continue;
            return true;
        }
        return false;
    }

    public static String getOperatorParam(HttpRequest request, String operatorCode, String key) throws Exception {
        Asserts.as((String)(!Validates.isEmptyBlank((String)operatorCode) ? null : "\u64cd\u4f5c\u5458\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u767d"));
        ZmrOperator operator = (ZmrOperator)ZmrBootstrap.tableOpr(request).item(ZmrOperator.class, new Object[]{operatorCode});
        if (operator == null) {
            return null;
        }
        return Jsons.getString((String)operator.getOperatorParam(), (String)key);
    }

    public static String getOperatorParam(ZmrOperator operator, String key) throws Exception {
        Asserts.as((String)(operator != null ? null : "\u64cd\u4f5c\u5458\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u767d"));
        return Jsons.getString((String)operator.getOperatorParam(), (String)key);
    }

    public static void addOrUpdateOperatorParam(HttpRequest request, String operatorCode, String key, Object value) throws Exception {
        ZmrOperator operator = (ZmrOperator)ZmrBootstrap.tableOpr(request).item(ZmrOperator.class, new Object[]{operatorCode});
        if (operator == null) {
            return;
        }
        String operatorParam = operator.getOperatorParam();
        if (Validates.isEmptyBlank((String)operatorParam)) {
            operatorParam = "{}";
        }
        operatorParam = Jsons.toStringAddOrUpdate((String)operatorParam, (String)key, (Object)value);
        Updater updater = new Updater();
        updater.addField("operatorParam", (Object)operatorParam);
        updater.addMust("operatorCode", (Object)operatorCode);
        ZmrBootstrap.tableOpr(request).update(ZmrOperator.class, updater);
    }

    public static void deleteOperatorParam(HttpRequest request, String operatorCode, String key) throws Exception {
        ZmrOperator operator = (ZmrOperator)ZmrBootstrap.tableOpr(request).item(ZmrOperator.class, new Object[]{operatorCode});
        if (operator == null) {
            return;
        }
        String operatorParam = operator.getOperatorParam();
        if (Validates.isEmptyBlank((String)operatorParam)) {
            operatorParam = "{}";
        }
        operatorParam = Jsons.toStringRemove((String)operatorParam, (String)key);
        Updater updater = new Updater();
        updater.addField("operatorParam", (Object)operatorParam);
        updater.addMust("operatorCode", (Object)operatorCode);
        ZmrBootstrap.tableOpr(request).update(ZmrOperator.class, updater);
    }

    public static List<ZmrMenu> getAllMenuList(HttpRequest request) throws Exception {
        Selector selector = new Selector();
        selector.addOrderbyAsc("menuLevel");
        selector.addOrderbyAsc("menuCode");
        return ZmrBootstrap.table(request).list(ZmrMenu.class, selector);
    }

    public static List<ZmrMenu> getOperatorMenuList(HttpRequest request, String operatorCode) throws Exception {
        Asserts.assertNotEmpty((String)operatorCode, (String)"\u64cd\u4f5c\u5458\u7f16\u7801\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        ZmrOperator operator = (ZmrOperator)ZmrBootstrap.tableOpr(request).item(ZmrOperator.class, new Object[]{operatorCode});
        if (operator == null) {
            return new ArrayList<ZmrMenu>();
        }
        return ZmrOperatorDao.getOperatorMenuList(request, operator);
    }

    public static List<ZmrMenu> getOperatorMenuList(HttpRequest request, ZmrOperator operator) throws Exception {
        List<ZmrMenu> menuList = ZmrOperatorDao.getAllMenuList(request);
        if (operator.getOperatorType() == 0) {
            return menuList;
        }
        Iterator<ZmrMenu> it = menuList.iterator();
        while (it.hasNext()) {
            ZmrMenu menu = it.next();
            if (menu.getMenuStatus() == 0) continue;
            it.remove();
        }
        List operatorRuleList = ZmrBootstrap.table(request).list(ZmrOperatorRule.class, new Selector("operatorCode", (Object)operator.getOperatorCode()));
        ArrayList<ZmrOrgRule> orgRuleList = new ArrayList<ZmrOrgRule>();
        if (ZmrOrgDao.isOrgManager(request, operator.getOperatorCode())) {
            List list = ZmrBootstrap.table(request).list(ZmrOrgRule.class, new Selector("orgId", (Object)operator.getOrgId()));
            orgRuleList.addAll(list);
        }
        ArrayList<ZmrDeptRule> deptRuleList = new ArrayList<ZmrDeptRule>();
        String deptIds = ZmrParamDao.isOperatorDeptAllRule(request.getContext()) ? operator.getOperatorDeptAll() : operator.getOperatorDept();
        List deptIdList = Lists.toLongList((String)deptIds);
        Iterator iterator = deptIdList.iterator();
        while (iterator.hasNext()) {
            long deptId = (Long)iterator.next();
            List ruleList = ZmrBootstrap.table(request).list(ZmrDeptRule.class, new Selector("deptId", (Object)deptId));
            deptRuleList.addAll(ruleList);
        }
        ArrayList<ZmrRoleRule> roleRuleList = new ArrayList<ZmrRoleRule>();
        List roleIdList = Lists.toLongList((String)operator.getOperatorRole());
        Iterator iterator2 = roleIdList.iterator();
        while (iterator2.hasNext()) {
            long roleId = (Long)iterator2.next();
            List ruleList = ZmrBootstrap.table(request).list(ZmrRoleRule.class, new Selector("roleId", (Object)roleId));
            roleRuleList.addAll(ruleList);
        }
        Iterator<ZmrMenu> it2 = menuList.iterator();
        while (it2.hasNext()) {
            String menuCode = it2.next().getMenuCode();
            if (ZmrOperatorDao.isOrgRule(orgRuleList, menuCode) || ZmrOperatorDao.isOperatorRule(operatorRuleList, menuCode) || ZmrOperatorDao.isDeptRule(deptRuleList, menuCode) || ZmrOperatorDao.isRoleRule(roleRuleList, menuCode)) continue;
            it2.remove();
        }
        return menuList;
    }

    public static List<ZmrOperator> getOperator(HttpRequest request, long orgId) throws Exception {
        return ZmrBootstrap.tableOpr(request).list(ZmrOperator.class, new Selector("orgId", (Object)orgId));
    }

    public static List<ZmrOperator> getOperatorAll(HttpRequest request) throws Exception {
        return ZmrBootstrap.tableOpr(request).list(ZmrOperator.class);
    }

    public static ZmrOperator getOperator(HttpRequest request, String operatorCode) throws Exception {
        return (ZmrOperator)ZmrBootstrap.tableOpr(request).item(ZmrOperator.class, new Object[]{operatorCode});
    }

    public static boolean isOperator(List<ZmrOperator> list, String operatorCode) {
        for (ZmrOperator opr : list) {
            if (!operatorCode.equals(opr.getOperatorCode())) continue;
            return true;
        }
        return false;
    }

    public static boolean isOperatorRule(List<ZmrOperatorRule> ruleList, String menuCode) {
        for (ZmrOperatorRule rule : ruleList) {
            if (!menuCode.equals(rule.getMenuCode())) continue;
            return true;
        }
        return false;
    }

    public static boolean isDeptRule(List<ZmrDeptRule> ruleList, String menuCode) {
        for (ZmrDeptRule rule : ruleList) {
            if (!menuCode.equals(rule.getMenuCode())) continue;
            return true;
        }
        return false;
    }

    public static boolean isOrgRule(List<ZmrOrgRule> ruleList, String menuCode) {
        for (ZmrOrgRule rule : ruleList) {
            if (!menuCode.equals(rule.getMenuCode())) continue;
            return true;
        }
        return false;
    }

    public static boolean isRoleRule(List<ZmrRoleRule> ruleList, String menuCode) {
        for (ZmrRoleRule rule : ruleList) {
            if (!menuCode.equals(rule.getMenuCode())) continue;
            return true;
        }
        return false;
    }

    public static void refresh(HttpRequest request) throws Exception {
        List sessionUserList = request.getContext().getSessionManager().getSessionUserList();
        for (HttpSessionUser sessionUser : sessionUserList) {
            if (!(sessionUser instanceof ZmrSessionUser)) continue;
            ZmrSessionUser sUser = (ZmrSessionUser)sessionUser;
            List<ZmrMenu> menuList = ZmrOperatorDao.getOperatorMenuList(request, sUser.getOperator());
            sUser.setMenuList(request.getContext(), menuList);
        }
    }
}

