/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.manager;

import java.util.ArrayList;
import java.util.List;
import org.zhiqim.httpd.HttpContext;
import org.zhiqim.httpd.HttpRequest;
import org.zhiqim.httpd.HttpSessionUser;
import org.zhiqim.httpd.context.ZmlContexts;
import org.zhiqim.kernel.annotation.AnAlias;
import org.zhiqim.kernel.annotation.AnGenerics;
import org.zhiqim.kernel.json.Jsons;
import org.zhiqim.kernel.util.Validates;
import org.zhiqim.manager.ZmrConstants;
import org.zhiqim.manager.dbo.ZmrMenu;
import org.zhiqim.manager.dbo.ZmrOperator;

@AnAlias(value={"ZmrSessionUser"})
public class ZmrSessionUser
extends HttpSessionUser
implements ZmrConstants {
    private ZmrOperator operator;
    @AnGenerics(value=ZmrMenu.class)
    private List<ZmrMenu> menuList = new ArrayList<ZmrMenu>();
    private String topFirstMenuCode;
    private String menuUrlRules;
    private String mainUrl;
    private String welcomeUrl;
    private long selectedOrgId;
    private boolean sidebar = true;

    public String getSessionName() {
        return this.operator.getOperatorCode();
    }

    public ZmrOperator getOperator() {
        return this.operator;
    }

    public String getRootPath(String path) {
        return this.getContext().getRootPath(path);
    }

    public int getOperatorTypeThenG() {
        return this.isSuperAdmin() ? 0 : 1;
    }

    public ZmrSessionUser setOperator(ZmrOperator operator) {
        this.operator = operator;
        return this;
    }

    public long getOperatorOrgId() {
        return this.operator.getOrgId();
    }

    public String getOperatorCode() {
        return this.operator.getOperatorCode();
    }

    public String getOperatorName() {
        return this.operator.getOperatorName();
    }

    public String getOperatorPassSalt() {
        return this.operator.getOperatorPassSalt();
    }

    public int getOperatorType() {
        return this.operator.getOperatorType();
    }

    public boolean isSuperAdmin() {
        return this.getOperatorType() == 0;
    }

    public boolean isAdmin() {
        return this.operator.getOperatorType() == 0 || this.operator.getOperatorType() == 1;
    }

    public String getOperatorMobile() {
        return this.operator.getOperatorMobile();
    }

    public String getOperatorEmail() {
        return this.operator.getOperatorEmail();
    }

    public String getOperatorWangwang() {
        return this.operator.getOperatorWangwang();
    }

    public String getOpenId() {
        return this.operator.getOpenId();
    }

    public String getWkwechatAccount() {
        return this.operator.getWkwechatAccount();
    }

    public String getOperatorWxcode() {
        return this.operator.getOperatorWxcode();
    }

    public boolean hasOperatorParam(String key) {
        if (Validates.isEmptyBlank((String)this.operator.getOperatorParam())) {
            return false;
        }
        return Jsons.getString((String)this.operator.getOperatorParam(), (String)key) != null;
    }

    public String getOperatorParam(String key) {
        if (Validates.isEmptyBlank((String)this.operator.getOperatorParam())) {
            return null;
        }
        return Jsons.getString((String)this.operator.getOperatorParam(), (String)key);
    }

    public int getOperatorParamInt(String key) {
        if (Validates.isEmptyBlank((String)this.operator.getOperatorParam())) {
            return -1;
        }
        return Jsons.getInt((String)this.operator.getOperatorParam(), (String)key);
    }

    public long getOperatorParamLong(String key) {
        if (Validates.isEmptyBlank((String)this.operator.getOperatorParam())) {
            return -1L;
        }
        return Jsons.getLong((String)this.operator.getOperatorParam(), (String)key);
    }

    public ZmrSessionUser setMenuList(HttpContext context, List<ZmrMenu> menuList) throws Exception {
        if (menuList == null || menuList.isEmpty()) {
            return this;
        }
        this.menuList = menuList;
        StringBuffer strb = new StringBuffer();
        for (ZmrMenu menu : menuList) {
            menu.setMenuUrl(ZmlContexts.parseZmlContent((HttpContext)context, (String)menu.getMenuUrl()));
            if (menu.getMenuStatus() != 0 || menu.getMenuUrl() == null) continue;
            strb.append(menu.getMenuUrl()).append(",");
        }
        this.menuUrlRules = strb.toString();
        for (ZmrMenu menu : menuList) {
            if (menu.getMenuStatus() != 0 || menu.getMenuType() != 1 || menu.getMenuLevel() != 1) continue;
            this.topFirstMenuCode = menu.getMenuCode();
            break;
        }
        return this;
    }

    public List<ZmrMenu> getMenuList() {
        return this.menuList;
    }

    public boolean hasMenuRule(String path) {
        if (path == null) {
            return false;
        }
        return this.menuUrlRules.indexOf(path) != -1;
    }

    public List<ZmrMenu> getTopMenuList() {
        ArrayList<ZmrMenu> list = new ArrayList<ZmrMenu>();
        for (ZmrMenu menu : this.menuList) {
            if (menu.getMenuStatus() != 0 || menu.getMenuLevel() != 1 || menu.getMenuType() != 1) continue;
            list.add(menu);
        }
        return list;
    }

    public ZmrMenu getTopMenuFirst() {
        for (ZmrMenu menu : this.menuList) {
            if (menu.getMenuStatus() != 0 || menu.getMenuLevel() != 1 || menu.getMenuType() != 1) continue;
            return menu;
        }
        return null;
    }

    public boolean hasChildMenu(String menuCode) {
        for (ZmrMenu menu : this.menuList) {
            if (menu.getMenuStatus() != 0 || !menu.getParentCode().equals(menuCode) || menu.getMenuType() != 1) continue;
            return true;
        }
        return false;
    }

    public ZmrMenu getChildMenuFirst(String menuCode) {
        for (ZmrMenu menu : this.menuList) {
            if (menu.getMenuStatus() != 0 || !menu.getParentCode().equals(menuCode) || menu.getMenuType() != 1) continue;
            return menu;
        }
        return null;
    }

    public List<ZmrMenu> getChildMenuList(String menuCode) {
        ArrayList<ZmrMenu> list = new ArrayList<ZmrMenu>();
        for (ZmrMenu menu : this.menuList) {
            if (menu.getMenuStatus() != 0 || !menu.getParentCode().equals(menuCode) || menu.getMenuType() != 1) continue;
            list.add(menu);
        }
        return list;
    }

    public ZmrMenu getTopMenuByChild(String childMenuCode) {
        if (childMenuCode == null) {
            return null;
        }
        ZmrMenu child = null;
        for (ZmrMenu menu : this.menuList) {
            if (menu.getMenuStatus() != 0 || !menu.getMenuCode().equals(childMenuCode)) continue;
            if (menu.getMenuType() != 1 && menu.getMenuLevel() != 1) {
                return null;
            }
            child = menu;
            break;
        }
        return child == null ? null : this.getMenu(child.getParentCode());
    }

    public String getSelectedTopMenuCodeByMainUrl(String designatedPath) {
        return this.getSelectedTopMenuCode(this.mainUrl, designatedPath, null);
    }

    public String getSelectedTopMenuCodeOrFirstMenuCode(HttpRequest request, String designatedPath) {
        return this.getSelectedTopMenuCode(request.getPathInContext(), designatedPath, this.topFirstMenuCode);
    }

    public String getSelectedTopMenuCode(HttpRequest request, String designatedPath) {
        return this.getSelectedTopMenuCode(request.getPathInContext(), designatedPath, null);
    }

    public String getSelectedTopMenuCode(String requestPath, String designatedPath, String defaultMenuCode) {
        String path = designatedPath == null ? requestPath : designatedPath;
        ZmrMenu menu = this.getMenuByPath(path);
        if (menu == null || menu.getMenuLevel() == 0) {
            return defaultMenuCode;
        }
        if (menu.getMenuLevel() == 1) {
            return menu.getMenuType() == 1 ? menu.getMenuCode() : defaultMenuCode;
        }
        do {
            if ((menu = this.getMenu(menu.getParentCode())) != null) continue;
            return null;
        } while (menu.getMenuLevel() > 1);
        return menu.getMenuType() == 1 ? menu.getMenuCode() : defaultMenuCode;
    }

    public String getSelectedSecondMenuCode(HttpRequest request, String designatedPath) {
        String path = designatedPath == null ? request.getPathInContext() : designatedPath;
        ZmrMenu menu = this.getMenuByPath(path);
        if (menu == null || menu.getMenuLevel() <= 1) {
            return null;
        }
        if (menu.getMenuLevel() == 2) {
            return menu.getMenuType() == 1 ? menu.getMenuCode() : null;
        }
        do {
            if ((menu = this.getMenu(menu.getParentCode())) != null) continue;
            return null;
        } while (menu.getMenuLevel() > 2);
        return menu.getMenuType() == 1 ? menu.getMenuCode() : null;
    }

    public ZmrMenu getMenu(String menuCode) {
        for (ZmrMenu menu : this.menuList) {
            if (menu.getMenuStatus() != 0 || !menuCode.equals(menu.getMenuCode())) continue;
            return menu;
        }
        return null;
    }

    public ZmrMenu getMenuByPath(String path) {
        int ind = path.indexOf("?");
        if (ind != -1) {
            path = path.substring(0, ind);
        }
        ZmrMenu selected = null;
        for (ZmrMenu menu : this.menuList) {
            if (menu.getMenuStatus() != 0 || !Validates.isNotEmpty((String)menu.getMenuUrl()) || !menu.getMenuUrl().contains(path) || selected != null && selected.getMenuLevel() >= menu.getMenuLevel()) continue;
            selected = menu;
        }
        return selected;
    }

    public String getMainUrl() {
        return this.mainUrl;
    }

    public void setMainUrl(String mainUrl) {
        this.mainUrl = mainUrl;
    }

    public void setWelcomeUrl(String welcomeUrl) {
        this.welcomeUrl = welcomeUrl;
    }

    public boolean isWelcomeUrl() {
        return Validates.isEqual((Object)this.welcomeUrl, (Object)this.mainUrl);
    }

    public void setSidebar(boolean sidebar) {
        this.sidebar = sidebar;
    }

    public boolean hasSidebar() {
        return this.sidebar;
    }

    public String getSidebarClass() {
        return this.sidebar ? "" : "z-hide";
    }

    public String getAvatar50() {
        return this.operator.getOperatorAvatar() == 0L ? this.getRootPath("/service/res/image/pic_avatar.jpg") : this.getAvatarUrl(this.getOperatorAvatar(), 50);
    }

    public String getAvatar100() {
        return this.operator.getOperatorAvatar() == 0L ? this.getRootPath("/service/res/image/pic_avatar.jpg") : this.getAvatarUrl(this.getOperatorAvatar(), 100);
    }

    public String getAvatar150() {
        return this.operator.getOperatorAvatar() == 0L ? this.getRootPath("/service/res/image/pic_avatar.jpg") : this.getAvatarUrl(this.getOperatorAvatar(), 150);
    }

    public long getOperatorAvatar() {
        return this.operator.getOperatorAvatar();
    }

    public String getAvatarUrl(long avatarId, int avatarSize) {
        return this.getRootPath(new StringBuffer("/").append(this.getContext().getAttribute("zhiqim_manager")).append("/avatar/").append(avatarId).append("/").append(avatarSize).append(".png").toString());
    }

    public long getSelectedDeptId(long defaultValue) {
        return this.getValueLong("zmr_session_user_dept_id", defaultValue);
    }

    public long getSelectedRoleId(long defaultValue) {
        return this.getValueLong("zmr_session_user_role_id", defaultValue);
    }

    public long getSelectedOrgId() {
        return this.selectedOrgId;
    }

    public void setSelectedOrgId(long orgId) {
        this.selectedOrgId = orgId;
    }

    public boolean isPresaleRole() {
        String presaleRole = this.operator.getOperatorRole();
        if (Validates.isEmpty((String)presaleRole)) {
            return false;
        }
        return presaleRole.contains("1806211542344560");
    }
}

