/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.httpd.util;

import org.zhiqim.httpd.HttpRequest;
import org.zhiqim.httpd.HttpSession;
import org.zhiqim.httpd.HttpSessionUser;
import org.zhiqim.kernel.annotation.AnAlias;
import org.zhiqim.kernel.paging.PageResult;

@AnAlias(value={"Sessions"})
public class Sessions {
    public static String getSessionVerificationCode(HttpRequest request) {
        return request.getSessionAttributeString("_vcode_");
    }

    public static PageResult<HttpSessionUser> getSessionUserPage(HttpRequest request, int pageNo, int pageSize) {
        return request.getContext().getSessionManager().getSessionUserPage(pageNo, pageSize);
    }

    public static HttpSessionUser getSessionUser(HttpRequest request, String sessionId) {
        HttpSession session = request.getContext().getSessionManager().getSession(sessionId);
        return session == null ? null : session.getSessionUser();
    }

    public static void removeSession(HttpRequest request, String sessionId) {
        request.getContext().getSessionManager().invalidateSession(sessionId);
    }
}

