/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.httpd.sessioner;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.zhiqim.httpd.HttpContext;
import org.zhiqim.httpd.HttpSession;
import org.zhiqim.httpd.HttpSessionManager;
import org.zhiqim.httpd.HttpSessionUser;
import org.zhiqim.httpd.sessioner.HashSession;
import org.zhiqim.kernel.extend.HashMapSV;
import org.zhiqim.kernel.paging.PageBuilder;
import org.zhiqim.kernel.paging.PageResult;
import org.zhiqim.kernel.schedule.Interval;
import org.zhiqim.kernel.schedule.Task;
import org.zhiqim.kernel.util.Asserts;
import org.zhiqim.kernel.util.Lists;

public class HashSessionManager
implements HttpSessionManager,
Task {
    private HttpContext context;
    private int sessionTimeout = 1800;
    private String sessionIdName = "jsessionid";
    private HashMapSV<HttpSession> sessionMap;
    private Interval every;

    @Override
    public HttpSession newSession(String sessionId) {
        return new HashSession().setSessionManager(this).setSessionId(sessionId);
    }

    @Override
    public HttpContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(HttpContext context) {
        this.context = context;
    }

    @Override
    public void open() {
        this.sessionMap = new HashMapSV(999, true);
        this.every = Interval.shedule((Task)this, (int)29000);
    }

    @Override
    public void close() {
        if (this.every != null) {
            this.every.close();
            this.every = null;
        }
        this.sessionMap.clear();
        this.sessionMap = null;
    }

    @Override
    public void setSessionIdName(String sessionIdName) {
        this.sessionIdName = sessionIdName;
    }

    @Override
    public String getSessionIdName() {
        return this.sessionIdName;
    }

    @Override
    public void setSessionTimeout(int sessionTimeout) {
        this.sessionTimeout = sessionTimeout;
    }

    @Override
    public int getSessionTimeout() {
        return this.sessionTimeout;
    }

    @Override
    public void setSessionParameter(String sessionParameter) {
    }

    @Override
    public void setSession(HttpSession session) {
        this.sessionMap.put(session.getId(), (Object)session);
    }

    @Override
    public HttpSession getSession(String sessionId) {
        return (HttpSession)this.sessionMap.get(sessionId);
    }

    @Override
    public boolean hasSession(String sessionId) {
        return this.sessionMap.containsKey(sessionId);
    }

    @Override
    public void invalidateSession(String sessionId) {
        HttpSession session = (HttpSession)this.sessionMap.remove(sessionId);
        if (session == null) {
            return;
        }
        session.invalidate();
        session = null;
    }

    @Override
    public void updateLastAccessed(String sessionId) {
        HttpSession session = (HttpSession)this.sessionMap.get(sessionId);
        if (session == null) {
            return;
        }
        session.updateLastAccessed();
    }

    @Override
    public void updateInfo(String sessionId, String sessionIp, String userAgent) {
        HttpSession session = (HttpSession)this.sessionMap.get(sessionId);
        if (session == null) {
            return;
        }
        session.updateInfo(sessionIp, userAgent);
    }

    @Override
    public int size() {
        return this.sessionMap.size();
    }

    @Override
    public List<HttpSession> getSessionList() {
        ArrayList<HttpSession> list = new ArrayList<HttpSession>();
        for (HttpSession s : this.sessionMap.values()) {
            list.add(s);
        }
        return Collections.unmodifiableList(Lists.trim(list));
    }

    @Override
    public PageResult<HttpSession> getSessionPage(int pageNo, int pageSize) {
        int size = this.sessionMap.size();
        if (size == 0) {
            return PageBuilder.newResult((int)pageNo, (int)pageSize);
        }
        int pageNoMax = (size - 1) / pageSize + 1;
        if (pageNo < 1) {
            pageNo = 1;
        }
        if (pageNo > pageNoMax) {
            pageNo = pageNoMax;
        }
        int start = (pageNo - 1) * pageSize;
        int end = pageNo * pageSize;
        ArrayList<HttpSession> list = new ArrayList<HttpSession>();
        Iterator it = this.sessionMap.values().iterator();
        int i = 0;
        while (it.hasNext()) {
            HttpSession s = (HttpSession)it.next();
            if (i >= start) {
                if (i >= end) break;
                list.add(s);
            }
            ++i;
        }
        list.trimToSize();
        return PageBuilder.newResult((int)size, (int)pageNo, (int)pageSize, list);
    }

    @Override
    public int sizeUser() {
        int size = 0;
        for (HttpSession s : this.sessionMap.values()) {
            if (!s.hasSessionUser()) continue;
            ++size;
        }
        return size;
    }

    @Override
    public boolean hasSessionName(String sessionName) {
        Asserts.notNull((Object)sessionName, (String)"sessionName");
        for (HttpSession s : this.sessionMap.values()) {
            HttpSessionUser sessionUser = s.getSessionUser();
            if (sessionUser == null || !sessionName.equals(sessionUser.getSessionName())) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<HttpSessionUser> getSessionUserList() {
        ArrayList<HttpSessionUser> list = new ArrayList<HttpSessionUser>();
        for (HttpSession s : this.sessionMap.values()) {
            HttpSessionUser sessionUser = s.getSessionUser();
            if (sessionUser == null) continue;
            list.add(sessionUser);
        }
        return Collections.unmodifiableList(Lists.trim(list));
    }

    @Override
    public PageResult<HttpSessionUser> getSessionUserPage(int pageNo, int pageSize) {
        if (pageNo < 1) {
            pageNo = 1;
        }
        int start = (pageNo - 1) * pageSize;
        int end = pageNo * pageSize;
        int total = 0;
        List<Object> list = new ArrayList();
        for (HttpSession s : this.sessionMap.values()) {
            HttpSessionUser sessionUser = s.getSessionUser();
            if (sessionUser == null || ++total <= start || total > end) continue;
            list.add(sessionUser);
        }
        list = Collections.unmodifiableList(Lists.trim(list));
        return PageBuilder.newResult((int)total, (int)pageNo, (int)pageSize, list);
    }

    public void execute() {
        Iterator it = this.sessionMap.values().iterator();
        while (it.hasNext()) {
            HttpSession session = (HttpSession)it.next();
            if (session.getMaxInactiveInterval() <= 0 || System.currentTimeMillis() - session.getLastAccessed() < (long)(session.getMaxInactiveInterval() * 1000)) continue;
            it.remove();
            session.invalidate();
            Object var2_2 = null;
        }
    }
}

