/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.httpd.entities;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.zhiqim.httpd.HttpContext;
import org.zhiqim.httpd.HttpEntity;
import org.zhiqim.httpd.HttpHeader;
import org.zhiqim.httpd.HttpSender;
import org.zhiqim.kernel.util.DateTimes;
import org.zhiqim.kernel.util.Streams;

public class CrossdomainEntity
implements HttpEntity {
    private byte[] crossdomainBytes = null;
    private String crossdomainModified = null;

    public CrossdomainEntity(HttpContext context) {
        try {
            File file;
            URL url;
            if (this.crossdomainModified != null) {
                return;
            }
            this.crossdomainModified = DateTimes.getDateTimeHttp();
            String crossdomainPath = String.valueOf(context.getResourcePath()) + "/crossdomain.xml";
            this.crossdomainBytes = context.isClasspath() ? ((url = this.getClass().getResource(crossdomainPath)) == null ? Streams.getBytesClassPath(CrossdomainEntity.class, (String)"/org/zhiqim/httpd/resources/crossdomain.xml") : Streams.getBytesClassPath(CrossdomainEntity.class, (String)crossdomainPath)) : ((file = new File(crossdomainPath)) == null || !file.isFile() || !file.canRead() ? Streams.getBytesClassPath(CrossdomainEntity.class, (String)"/org/zhiqim/httpd/resources/crossdomain.xml") : Streams.getBytesFilePath((File)file));
        }
        catch (IOException iOException) {
            this.crossdomainBytes = new byte[0];
        }
    }

    @Override
    public boolean isMatch(String pathInContext) {
        return "/crossdomain.xml".equals(pathInContext);
    }

    @Override
    public void handle(HttpHeader request, HttpSender response) throws IOException {
        String ifModifiedSince = request.getHeader("If-Modified-Since");
        if (ifModifiedSince != null && ifModifiedSince.indexOf(this.crossdomainModified) != -1) {
            response.setHeader("Pragma", "no-cache");
            response.setHeader("Cache-Control", "no-cache");
            response.sendError(304);
            return;
        }
        response.setHeader("Last-Modified", this.crossdomainModified);
        response.setContentType("text/x-cross-domain-policy");
        response.setHeader("Pragma", "no-cache");
        response.setHeader("Cache-Control", "no-cache");
        if (request.isMethodResponseContent()) {
            response.write(this.crossdomainBytes);
        }
        response.commit();
    }
}

