/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.httpd.context.config;

import java.util.Collection;
import java.util.List;
import org.zhiqim.httpd.context.ZmlConfig;
import org.zhiqim.httpd.context.ZmlContextConstants;
import org.zhiqim.httpd.context.config.ZAction;
import org.zhiqim.httpd.context.config.ZConfig;
import org.zhiqim.kernel.annotation.AnNullable;
import org.zhiqim.kernel.extend.LinkedMapSV;
import org.zhiqim.kernel.extend.MapS;
import org.zhiqim.kernel.util.Asserts;
import org.zhiqim.kernel.util.Lists;
import org.zhiqim.kernel.util.Objects;
import org.zhiqim.kernel.util.Replaces;
import org.zhiqim.kernel.util.Validates;
import org.zhiqim.zml.Zmls;

public class ZActionMap
implements ZmlContextConstants {
    private final ZmlConfig zmlConfig;
    private final ZConfig config;
    private LinkedMapSV<ZAction> exactMap = new LinkedMapSV();
    private LinkedMapSV<ZAction> fuzzyMap = new LinkedMapSV();

    public ZActionMap(ZmlConfig zmlConfig, ZConfig config) {
        this.zmlConfig = zmlConfig;
        this.config = config;
    }

    public Collection<ZAction> getExactActionList() {
        return this.exactMap.values();
    }

    public Collection<ZAction> getFuzzyActionList() {
        return this.fuzzyMap.values();
    }

    public void addAction(ZAction action) {
        action.setConfig(this.config);
        String path = action.getPath();
        if (path.indexOf("*") == -1) {
            this.exactMap.put(path, (Object)action);
        } else {
            this.fuzzyMap.put(path, (Object)action);
        }
    }

    public void removeAction(String path) {
        this.exactMap.remove(path);
        this.fuzzyMap.remove(path);
    }

    public void chkVariable() {
        LinkedMapSV newExactMap = new LinkedMapSV();
        for (ZAction zAction : this.exactMap.values()) {
            ZAction newAction = this.chkVariable(zAction);
            newExactMap.put(newAction.getPath(), (Object)newAction);
        }
        this.exactMap.clear();
        this.exactMap = newExactMap;
        LinkedMapSV newFuzzyMap = new LinkedMapSV();
        for (ZAction zAction : this.fuzzyMap.values()) {
            ZAction newAction = this.chkVariable(zAction);
            newFuzzyMap.put(newAction.getPath(), (Object)newAction);
        }
        this.fuzzyMap.clear();
        this.fuzzyMap = newFuzzyMap;
    }

    private ZAction chkVariable(ZAction zAction) {
        String forward;
        String redirect;
        String path = zAction.getPath();
        if (path.contains("${") || path.contains("<#")) {
            try {
                zAction.setPath(Zmls.parseContext((String)path, (MapS[])new MapS[]{this.zmlConfig}));
            }
            catch (Exception exception) {
                throw Asserts.exception((String)"action\u914d\u7f6e[%s]\uff0cpath\u53d8\u91cf\u89e3\u6790\u5931\u8d25", (Object[])new Object[]{path});
            }
        }
        if (Validates.isNotEmpty((String)(redirect = zAction.getRedirect())) && path.contains("${") || path.contains("<#")) {
            try {
                zAction.setRedirect(Zmls.parseContext((String)redirect, (MapS[])new MapS[]{this.zmlConfig}));
            }
            catch (Exception exception) {
                throw Asserts.exception((String)"action\u914d\u7f6e[%s]\uff0credirect\u53d8\u91cf\u89e3\u6790\u5931\u8d25", (Object[])new Object[]{path});
            }
        }
        if (Validates.isNotEmpty((String)(forward = zAction.getForward())) && path.contains("${") || path.contains("<#")) {
            try {
                zAction.setForward(Zmls.parseContext((String)forward, (MapS[])new MapS[]{this.zmlConfig}));
            }
            catch (Exception exception) {
                throw Asserts.exception((String)"action\u914d\u7f6e[%s]\uff0cforward\u53d8\u91cf\u89e3\u6790\u5931\u8d25", (Object[])new Object[]{path});
            }
        }
        return zAction;
    }

    public String toString() {
        StringBuilder strb = new StringBuilder();
        for (ZAction action : this.fuzzyMap.values()) {
            strb.append("    ").append(action.toString()).append("\r\n");
        }
        for (ZAction action : this.exactMap.values()) {
            strb.append("    ").append(action.toString()).append("\r\n");
        }
        return strb.toString();
    }

    @AnNullable
    public ZAction getExactActionByClass(String clazz) {
        if (clazz == null) {
            return null;
        }
        for (ZAction action : this.exactMap.values()) {
            if (!clazz.equals(action.getClazz())) continue;
            return action;
        }
        return null;
    }

    @AnNullable
    public ZAction getFuzzyActionByClass(String clazz) {
        if (clazz == null) {
            return null;
        }
        for (ZAction action : this.fuzzyMap.values()) {
            if (!clazz.equals(action.getClazz())) continue;
            return action;
        }
        return null;
    }

    @AnNullable
    public ZAction getExactAction(String path) {
        return (ZAction)this.exactMap.get(path);
    }

    @AnNullable
    public ZAction getFuzzyAction(String path) {
        for (String p : this.fuzzyMap.keySet()) {
            List matchList = Lists.getMatchList((String)path, (String)p);
            if (matchList == null) continue;
            return this.getActionMatchParam(p, (ZAction)this.fuzzyMap.get(p), path, matchList);
        }
        return null;
    }

    private ZAction getActionMatchParam(String path, ZAction action, String pathInContext, List<String> paramList) {
        ZAction newAction = (ZAction)Objects.copy((Object)action, (Object)new ZAction());
        newAction.setPath(pathInContext);
        int i = 0;
        while (i < paramList.size()) {
            String regex = "{" + (i + 1) + "}";
            String replacement = paramList.get(i);
            newAction.setInterceptor(Replaces.replaceAllEscape((String)newAction.getInterceptor(), (String)regex, (String)replacement));
            newAction.setForward(Replaces.replaceAllEscape((String)newAction.getForward(), (String)regex, (String)replacement));
            newAction.setRedirect(Replaces.replaceAllEscape((String)newAction.getRedirect(), (String)regex, (String)replacement));
            newAction.setView(Replaces.replaceAllEscape((String)newAction.getView(), (String)regex, (String)replacement));
            newAction.setInclude(Replaces.replaceAllEscape((String)newAction.getInclude(), (String)regex, (String)replacement));
            newAction.setClazz(Replaces.replaceAllEscape((String)newAction.getClazz(), (String)regex, (String)replacement));
            newAction.setMethod(Replaces.replaceAllEscape((String)newAction.getMethod(), (String)regex, (String)replacement));
            newAction.setSuccess(Replaces.replaceAllEscape((String)newAction.getSuccess(), (String)regex, (String)replacement));
            ++i;
        }
        return newAction.setMatchList(paramList);
    }
}

