/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.httpd.bio;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.security.cert.X509Certificate;
import org.zhiqim.httpd.HttpConnection;
import org.zhiqim.httpd.HttpContext;
import org.zhiqim.httpd.HttpListener;
import org.zhiqim.httpd.HttpdConstants;
import org.zhiqim.httpd.bio.HttpBioHeader;
import org.zhiqim.httpd.bio.HttpBioWebsocketConnection;
import org.zhiqim.kernel.util.Threads;

public final class HttpBioConnection
implements HttpConnection,
Runnable,
HttpdConstants {
    private String connId = sequence.nextString();
    private HttpListener listener;
    private Socket socket;
    private InetAddress remoteAddress;
    private InputStream input;
    private OutputStream output;
    private HttpBioHeader header;
    private HttpBioWebsocketConnection websocket;

    public HttpBioConnection(HttpListener listener, Socket socket, InputStream input, OutputStream output) {
        this.listener = listener;
        this.socket = socket;
        this.remoteAddress = socket.getInetAddress();
        this.input = input;
        this.output = output;
        this.header = new HttpBioHeader(this);
    }

    public HttpBioConnection(HttpListener listener, Socket socket, InputStream input, OutputStream output, X509Certificate[] certs) {
        this(listener, socket, input, output);
        this.header.setCertificates(certs);
    }

    @Override
    public boolean isWebsocket() {
        return this.websocket != null;
    }

    @Override
    public void doWebsocket(HttpContext context, String protocol, String sessionId) {
        this.websocket = new HttpBioWebsocketConnection(this, context, protocol, sessionId);
        this.websocket.open();
    }

    @Override
    public boolean isActive() {
        return true;
    }

    @Override
    public boolean isOvertime() {
        return false;
    }

    @Override
    public boolean isClosed() {
        return this.socket.isClosed();
    }

    @Override
    public void run() {
        try {
            this.header.execute();
        }
        catch (Exception exception) {
            this.close();
        }
    }

    @Override
    public void write(byte[] data) throws IOException {
        this.write(data, 0, data.length);
    }

    @Override
    public void write(byte[] data, int off, int len) throws IOException {
        this.output.write(data, off, len);
    }

    @Override
    public void close() {
        this.listener.remove(this);
        Threads.closeIgnoreException((AutoCloseable)this.input);
        Threads.closeIgnoreException((AutoCloseable)this.output);
        Threads.closeIgnoreException((AutoCloseable)this.socket);
    }

    @Override
    public String getId() {
        return this.connId;
    }

    @Override
    public HttpListener getListener() {
        return this.listener;
    }

    @Override
    public String getRemoteAddr() {
        return this.remoteAddress.getHostAddress();
    }

    public InputStream getInputStream() {
        return this.input;
    }
}

