/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.httpd;

import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.zhiqim.httpd.HttpHeaderAbs;
import org.zhiqim.httpd.HttpOutputStream;
import org.zhiqim.httpd.HttpSender;
import org.zhiqim.httpd.constants.HttpStatus;
import org.zhiqim.kernel.util.Asserts;
import org.zhiqim.kernel.util.DateTimes;
import org.zhiqim.kernel.util.Strings;
import org.zhiqim.kernel.util.Urls;
import org.zhiqim.kernel.util.Validates;

public class HttpSenderImpl
implements HttpSender {
    private HttpHeaderAbs header;
    private HttpOutputStream output;
    private String version = "HTTP/1.1";
    private int status = 200;
    private String reason = "OK";
    private String characterEncoding = "UTF-8";
    private HashMap<String, String> headers;
    private StringBuilder headerBuffer;

    public HttpSenderImpl(HttpHeaderAbs header, boolean autoClose) {
        this.header = header;
        this.output = header.getOutputStream();
        this.output.setSender(this);
        this.headers = new HashMap(5);
        this.headers.put("Server", "zhiqim_httpd_v1.5.0");
        if (autoClose) {
            this.headers.put("Connection", "close");
        }
        this.headerBuffer = new StringBuilder();
    }

    public boolean isCommitted() {
        return this.header.isCommitted();
    }

    public boolean isEditable() {
        return this.header.isEditable();
    }

    public boolean isResponseGZip() {
        return this.header.isResponseGZip();
    }

    @Override
    public void commit() throws IOException {
        if (this.header.isCommitted()) {
            return;
        }
        this.header.setStep(11);
        this.output.commit();
        if (this.isClose()) {
            this.header.close();
        }
    }

    @Override
    public void setStatus(int code) {
        this.status = code;
        this.reason = HttpStatus.getStatusMsg(code);
    }

    @Override
    public int getStatus() {
        return this.status;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    @Override
    public String getReason() {
        return this.reason;
    }

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    public long getFlushLength() {
        return this.output.getOutputLength();
    }

    @Override
    public void setHeader(String key, Object value) {
        if (value == null) {
            return;
        }
        this.headers.put(key, Strings.valueOf((Object)value));
    }

    public String getHeader(String key) {
        return this.headers.get(key);
    }

    public boolean hasHeader(String key) {
        return this.headers.containsKey(key);
    }

    public boolean isClose() {
        String connection = this.getHeader("Connection");
        return Validates.isEmptyBlank((String)connection) || "close".equalsIgnoreCase(connection);
    }

    @Override
    public void setDateHeader(String key, long value) {
        String date = DateTimes.getDateTimeHttp((long)value);
        this.setHeader(key, date);
    }

    @Override
    public void addHeader(String key, Object value) {
        if (value == null) {
            return;
        }
        String v = this.getHeader(key);
        if (v == null) {
            this.setHeader(key, value);
        } else {
            this.setHeader(key, String.valueOf(v) + "," + Strings.valueOf((Object)value));
        }
    }

    @Override
    public void addDateHeader(String key, long value) {
        String date = DateTimes.getDateTimeHttp((long)value);
        String v = this.getHeader(key);
        if (v == null) {
            this.setHeader(key, date);
        } else {
            this.setHeader(key, String.valueOf(v) + "," + value);
        }
    }

    public void removeHeader(String key) {
        this.headers.remove(key);
    }

    public void addMultiHeader(String key, String value) {
        this.headerBuffer.append(key).append(':').append(value).append("\r\n");
    }

    @Override
    public void setCharacterEncoding(String encoding) {
        Asserts.assertNotEmptyBlank((String)encoding, (String)"\u7f16\u7801\u683c\u5f0f\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u767d");
        this.characterEncoding = encoding;
    }

    @Override
    public void setContentType(String contentType) {
        Asserts.assertNotEmptyBlank((String)contentType, (String)"\u5185\u5bb9\u7c7b\u578b\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u767d");
        String mimeType = null;
        int i0 = contentType.indexOf(59);
        if (i0 == -1) {
            mimeType = contentType;
        } else {
            mimeType = contentType.substring(0, i0).trim();
            int i1 = contentType.indexOf("charset=", i0);
            if (i1 >= 0) {
                this.characterEncoding = contentType.substring(i1 + 8);
            }
        }
        if (Validates.isEmptyBlank((String)this.characterEncoding)) {
            this.setHeader("Content-Type", mimeType);
        } else {
            this.setHeader("Content-Type", String.valueOf(mimeType) + "; charset=" + this.characterEncoding);
        }
    }

    @Override
    public void setContentTypeNoCharset(String contentType) {
        Asserts.assertNotEmptyBlank((String)contentType, (String)"\u5185\u5bb9\u7c7b\u578b\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u767d");
        Asserts.as((String)(contentType.indexOf(";") == -1 ? null : "\u5185\u5bb9\u7c7b\u578b\u542b\u5b57\u7b26\u96c6\u8bf7\u8c03\u7528setContentType\u65b9\u6cd5"));
        this.setHeader("Content-Type", contentType);
    }

    @Override
    public void sendError(int code) throws IOException {
        this.sendError(code, null);
    }

    @Override
    public void sendError(int code, String reason) throws IOException {
        Asserts.asState((String)(this.isEditable() ? null : "\u5df2\u63d0\u4ea4\u4e0d\u5141\u8bb8\u518d\u63d0\u4ea4"));
        this.status = code;
        this.reason = Validates.isEmptyBlank((String)reason) ? HttpStatus.getStatusMsg(code) : reason;
        this.clear();
        this.print(this.reason);
        this.commit();
    }

    @Override
    public void sendErrorHTML(int code) throws IOException {
        this.sendErrorHTML(code, null);
    }

    @Override
    public void sendErrorHTML(int code, String reason) throws IOException {
        Asserts.asState((String)(this.isEditable() ? null : "\u5df2\u63d0\u4ea4\u4e0d\u5141\u8bb8\u518d\u63d0\u4ea4"));
        this.status = code;
        this.reason = Validates.isEmptyBlank((String)reason) ? HttpStatus.getStatusMsg(code) : reason;
        StringBuilder strb = new StringBuilder();
        strb.append("<!DOCTYPE html>").append("\r\n");
        strb.append("<html>").append("\r\n");
        strb.append("<head>").append("<title>Error ").append(code).append("</title>").append("<head>").append("\r\n");
        strb.append("<body>").append("<h2>Error ").append(reason).append("</h2>").append("</body>").append("\r\n");
        strb.append("</html>").append("\r\n");
        this.clear();
        this.print(this.reason);
        this.commit();
    }

    @Override
    public void sendContent(int code, String content) throws IOException {
        Asserts.asState((String)(this.isEditable() ? null : "\u5df2\u63d0\u4ea4\u4e0d\u5141\u8bb8\u518d\u63d0\u4ea4"));
        this.status = code;
        this.reason = HttpStatus.getStatusMsg(code);
        this.print(content);
        this.commit();
    }

    @Override
    public void sendRedirect(String url) throws IOException {
        Asserts.asState((String)(!this.isCommitted() ? null : "\u5df2\u63d0\u4ea4\u4e0d\u5141\u8bb8\u518d\u63d0\u4ea4"));
        this.status = 302;
        this.reason = "FOUND";
        this.setHeader("Location", url);
        this.setHeader("Proxy-Connection", "close");
        this.commit();
    }

    @Override
    public void sendHeader(int code) throws IOException {
        Asserts.asState((String)(this.isEditable() ? null : "\u6709\u63d0\u4ea4\u6570\u636e\u65f6\u4e0d\u5141\u8bb8\u66f4\u65b0\u63d0\u4ea4\u5185\u5bb9"));
        this.status = code;
        this.reason = HttpStatus.getStatusMsg(code);
        this.clear();
        this.commit();
    }

    @Override
    public OutputStream getOutputStream() {
        return this.output;
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.output.write(b);
    }

    @Override
    public void println(String str) throws IOException {
        this.output.write(str.getBytes(this.characterEncoding));
        this.output.write(_CRLF_);
    }

    @Override
    public void println() throws IOException {
        this.output.write(_CRLF_);
    }

    @Override
    public void print(String str) throws IOException {
        this.output.write(str.getBytes(this.characterEncoding));
    }

    public void clear() {
        this.output.reset();
    }

    public void flush() throws IOException {
        if (this.isCommitted()) {
            return;
        }
        this.output.flush();
    }

    public byte[] buildChunkedHeader(boolean chunked) {
        if (chunked) {
            this.setHeader("Transfer-Encoding", "chunked");
        } else {
            if (this.isResponseGZip() && this.output.getContentLength() > 256 && this.output.processGZipCompress()) {
                this.addHeader("Content-Encoding", "gzip");
            }
            this.setHeader("Content-Length", this.output.getContentLength());
        }
        if (!this.hasHeader("Content-Type")) {
            this.setContentType("text/html; charset=UTF-8");
        }
        StringBuilder strb = new StringBuilder();
        strb.append(this.version).append(" ").append(this.status).append(" ").append(Urls.encodeUTF8((String)this.reason)).append("\r\n");
        for (Map.Entry<String, String> entry : this.headers.entrySet()) {
            strb.append(entry.getKey()).append(':').append(entry.getValue()).append("\r\n");
        }
        strb.append((CharSequence)this.headerBuffer);
        strb.append("Date").append(':').append(DateTimes.getDateTimeHttp()).append("\r\n");
        strb.append("\r\n");
        return strb.toString().getBytes(_UTF_8_C_);
    }

    public String toString() {
        StringBuilder strb = new StringBuilder();
        strb.append(this.version).append(" ").append(this.status).append(" ").append(Urls.encode((String)this.reason, (String)this.characterEncoding)).append("\r\n");
        if (this.headers != null) {
            for (Map.Entry<String, String> entry : this.headers.entrySet()) {
                strb.append(entry.getKey()).append(':').append(entry.getValue()).append("\r\n");
            }
        }
        if (this.headerBuffer != null) {
            strb.append(this.headerBuffer.toString());
        }
        strb.append("\r\n");
        return strb.toString();
    }

    public void destroy() {
        if (this.headers != null) {
            this.headers.clear();
            this.headers = null;
        }
        if (this.headerBuffer != null) {
            this.headerBuffer.setLength(0);
            this.headerBuffer = null;
        }
        this.output = null;
        this.header = null;
    }
}

