/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.httpd;

import java.io.IOException;
import java.io.InputStream;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import org.zhiqim.kernel.util.Asserts;

public class HttpInputStream
extends InputStream {
    private InputStream input;
    private ByteBuffer buffer;

    public HttpInputStream() {
    }

    public HttpInputStream(InputStream input) {
        this.input = input;
    }

    public synchronized void addBuffer(ByteBuffer buf) {
        Asserts.as((String)(this.input == null ? null : "\u5df2\u6709\u8f93\u5165\u6d41\uff0c\u4e0d\u652f\u6301\u589e\u52a0\u7f13\u51b2\u6570\u636e"));
        if (buf.position() != 0) {
            buf.flip();
        }
        if (!buf.hasRemaining()) {
            return;
        }
        if (this.buffer == null) {
            this.buffer = ByteBuffer.allocate(buf.remaining());
            this.buffer.put(buf).flip();
        } else {
            ByteBuffer nBuf = ByteBuffer.allocate(this.buffer.remaining() + buf.remaining());
            nBuf.put(this.buffer).put(buf).flip();
            this.buffer = nBuf;
        }
    }

    public synchronized byte[] read(int len) {
        Asserts.as((String)(this.input == null ? null : "\u5df2\u6709\u8f93\u5165\u6d41\uff0c\u4e0d\u652f\u6301\u8be5\u65b9\u6cd5\u8c03\u7528"));
        if (this.buffer == null) {
            return new byte[0];
        }
        int length = this.buffer.remaining();
        if (length <= 0) {
            return new byte[0];
        }
        int count = length <= len ? length : len;
        byte[] buf = new byte[count];
        this.buffer.get(buf);
        return buf;
    }

    @Override
    public synchronized int read() throws IOException {
        if (this.input != null) {
            return this.input.read();
        }
        if (this.buffer == null || !this.buffer.hasRemaining()) {
            return -1;
        }
        try {
            return this.buffer.get();
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            return -1;
        }
    }

    @Override
    public synchronized int read(byte[] b, int off, int len) throws IOException {
        if (this.input != null) {
            return this.input.read(b, off, len);
        }
        if (this.buffer == null || !this.buffer.hasRemaining()) {
            return -1;
        }
        int pos = this.buffer.position();
        this.buffer.get(b, off, len);
        return this.buffer.position() - pos;
    }

    @Override
    public synchronized int read(byte[] b) throws IOException {
        if (this.input != null) {
            return this.input.read(b);
        }
        if (this.buffer == null || !this.buffer.hasRemaining()) {
            return -1;
        }
        int pos = this.buffer.position();
        this.buffer.get(b);
        return this.buffer.position() - pos;
    }

    @Override
    public synchronized int available() {
        if (this.input != null) {
            try {
                return this.input.available();
            }
            catch (IOException e) {
                throw Asserts.exception((Exception)e);
            }
        }
        return this.buffer == null ? -1 : this.buffer.remaining();
    }
}

