/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.httpd;

import java.net.URL;
import java.net.URLClassLoader;

public class HttpContextLoader
extends URLClassLoader {
    private static final String[] _SYSTEM_CLASSES_ = new String[]{"java.", "javax.xml.", "org.xml.", "org.w3c.", "org.zhiqim."};
    private ClassLoader _parent;

    public HttpContextLoader(ClassLoader parent) {
        super(new URL[0], parent);
        this._parent = parent;
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        return this.loadClass(name, false);
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> c = this.findLoadedClass(name);
        if (c != null) {
            return c;
        }
        ClassNotFoundException ex = null;
        try {
            c = this.findClass(name);
        }
        catch (ClassNotFoundException e) {
            ex = e;
        }
        if (c == null && this._parent != null) {
            try {
                c = this._parent.loadClass(name);
            }
            catch (ClassNotFoundException e) {
                ex = e;
            }
        }
        if (c == null) {
            throw ex;
        }
        if (resolve) {
            this.resolveClass(c);
        }
        return c;
    }

    @Override
    public URL getResource(String name) {
        URL url = null;
        boolean triedParent = false;
        if (this.isSystemPath(name)) {
            triedParent = true;
            url = this._parent.getResource(name);
        }
        if (url == null && (url = this.findResource(name)) == null && name.startsWith("/")) {
            url = this.findResource(name.substring(1));
        }
        if (url == null && !triedParent) {
            url = this._parent.getResource(name);
        }
        return url;
    }

    public boolean isSystemPath(String name) {
        name = name.replace('/', '.');
        while (name.startsWith(".")) {
            name = name.substring(1);
        }
        String[] stringArray = _SYSTEM_CLASSES_;
        int n = _SYSTEM_CLASSES_.length;
        int n2 = 0;
        while (n2 < n) {
            String c = stringArray[n2];
            if (c.endsWith(".") ? name.startsWith(c) : name.equals(c)) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

