/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.kernel.httpclient;

import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.util.Map;
import org.zhiqim.kernel.httpclient.HttpClient;
import org.zhiqim.kernel.util.Stringx;
import org.zhiqim.kernel.util.Urls;
import org.zhiqim.kernel.util.Validates;

public class HttpUpload
extends HttpClient {
    private String name;
    private String fileName;
    private byte[] fileContent;
    private String queryString;
    private boolean hasEncoded;
    private String mimeType = "application/octet-stream";
    private String encoding = "UTF-8";
    private String boundary = "" + System.currentTimeMillis();

    public HttpUpload(String url) {
        super(url, "POST");
    }

    public void setContent(String name, String fileName, byte[] fileContent, String encoding) {
        this.name = Stringx.trim(name);
        this.fileName = Stringx.trim(fileName);
        this.fileContent = fileContent;
        this.encoding = Stringx.trim(encoding);
    }

    public void setEncoding(String encoding) {
        this.encoding = Stringx.trim(encoding);
    }

    public void setMimeType(String mimeType) {
        this.mimeType = Stringx.trim(mimeType);
    }

    public void setQueryString(String queryString, boolean hasEncoded) {
        this.queryString = Stringx.trim(queryString);
        this.hasEncoded = hasEncoded;
    }

    @Override
    protected boolean doPreRequestProperty() {
        if (Validates.isEmpty(this.fileName) || this.fileContent == null) {
            this.responseStatus = 99;
            this.responseText = "\u4e0a\u4f20\u7684\u6587\u4ef6\u540d\u548c\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a";
            return false;
        }
        this.setDoOutput(true);
        this.addRequestProperty("Content-Type", "multipart/form-data; charset=" + this.encoding + "; boundary=" + this.boundary);
        return true;
    }

    @Override
    protected void doWriteRequestContent(HttpURLConnection conn) throws IOException {
        OutputStream out = conn.getOutputStream();
        byte[] entryBoundaryBytes = ("\r\n--" + this.boundary + "\r\n").getBytes(this.encoding);
        Map<String, String> paramMap = null;
        paramMap = this.hasEncoded ? Urls.toMap(this.queryString, this.encoding) : Urls.toMapNoEncoded(this.queryString);
        for (Map.Entry<String, String> entry : paramMap.entrySet()) {
            byte[] textBytes = HttpUpload.getTextDisposition(entry.getKey(), this.encoding);
            out.write(entryBoundaryBytes);
            out.write(textBytes);
            out.write(entry.getValue().getBytes(this.encoding));
        }
        byte[] fileBytes = HttpUpload.getFileDisposition(this.name, this.fileName, this.mimeType, this.encoding);
        out.write(entryBoundaryBytes);
        out.write(fileBytes);
        out.write(this.fileContent);
        byte[] endBoundaryBytes = ("\r\n--" + this.boundary + "--" + "\r\n").getBytes(this.encoding);
        out.write(endBoundaryBytes);
    }
}

